(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63218,       1700]*)
(*NotebookOutlinePosition[     63914,       1725]*)
(*  CellTagsIndexPosition[     63870,       1721]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<c:\\math\\kniz\\linearal\\tridiago.m
<<c:\\math\\kniz\\options\\optvalue.m\
\>", "Input"],

Cell["\"Sold Straddle : 1 call short + 1 put short\"", "Text"],

Cell["\<\
SoldStraddleImpl[X_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

xright=Log[Slarge/X];
xleft=-xright;

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfSoldStraddlePayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(-Max[Exp[x]-1,0]-Max[1-Exp[\
x],0])];
Do[u[i,0]=TransfSoldStraddlePayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=Exp[0.5*(k2-1)*xleft+0.25*(k2-1)^2*k*j]-
    Exp[0.5*(k2+1)*xleft+0.25*(k2+1)^2*k*j];
op2=Exp[0.5*(k2+1)*xright+0.25*(k2+1)^2*k*j]-
    Exp[0.5*(k2-1)*xright+0.25*(k2-1)^2*k*j];
        
ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]+a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]+c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=-op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j]=-op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["SoldStraddleImpl[X,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
SoldStraddle[S_,X,sigma_,r_,DD_,t_]:=
N[-EuropeanCallDiv[S,X,sigma,r,DD,t]-EuropeanPutDiv[S,X,sigma,r,DD,t]]\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["Payoff[S_,X_]:=N[-Max[S-X,0]-Max[X-S,0]]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[SoldStraddle[S,X,sigma,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X],{S,0,150},PlotRange->All, DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{-80,1}}]\

\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0.610404 0.00763005 [
[.2 .5979 -6 -9 ]
[.2 .5979 6 0 ]
[.4 .5979 -6 -9 ]
[.4 .5979 6 0 ]
[.6 .5979 -6 -9 ]
[.6 .5979 6 0 ]
[.8 .5979 -9 -9 ]
[.8 .5979 9 0 ]
[1 .5979 -9 -9 ]
[1 .5979 9 0 ]
[1.025 .6104 0 -7.5 ]
[1.025 .6104 10 7.5 ]
[-0.0125 0 -18 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .1526 -18 -4.5 ]
[-0.0125 .1526 0 4.5 ]
[-0.0125 .3052 -18 -4.5 ]
[-0.0125 .3052 0 4.5 ]
[-0.0125 .4578 -18 -4.5 ]
[-0.0125 .4578 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 .6104 m
.2 .61665 L
s
[(40)] .2 .5979 0 1 Mshowa
.4 .6104 m
.4 .61665 L
s
[(60)] .4 .5979 0 1 Mshowa
.6 .6104 m
.6 .61665 L
s
[(80)] .6 .5979 0 1 Mshowa
.8 .6104 m
.8 .61665 L
s
[(100)] .8 .5979 0 1 Mshowa
1 .6104 m
1 .61665 L
s
[(120)] 1 .5979 0 1 Mshowa
.125 Mabswid
.05 .6104 m
.05 .61415 L
s
.1 .6104 m
.1 .61415 L
s
.15 .6104 m
.15 .61415 L
s
.25 .6104 m
.25 .61415 L
s
.3 .6104 m
.3 .61415 L
s
.35 .6104 m
.35 .61415 L
s
.45 .6104 m
.45 .61415 L
s
.5 .6104 m
.5 .61415 L
s
.55 .6104 m
.55 .61415 L
s
.65 .6104 m
.65 .61415 L
s
.7 .6104 m
.7 .61415 L
s
.75 .6104 m
.75 .61415 L
s
.85 .6104 m
.85 .61415 L
s
.9 .6104 m
.9 .61415 L
s
.95 .6104 m
.95 .61415 L
s
.25 Mabswid
0 .6104 m
1 .6104 L
s
gsave
1.025 .6104 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
.00625 0 L
s
[(-80)] -0.0125 0 1 0 Mshowa
0 .1526 m
.00625 .1526 L
s
[(-60)] -0.0125 .1526 1 0 Mshowa
0 .3052 m
.00625 .3052 L
s
[(-40)] -0.0125 .3052 1 0 Mshowa
0 .4578 m
.00625 .4578 L
s
[(-20)] -0.0125 .4578 1 0 Mshowa
.125 Mabswid
0 .03815 m
.00375 .03815 L
s
0 .0763 m
.00375 .0763 L
s
0 .11445 m
.00375 .11445 L
s
0 .19075 m
.00375 .19075 L
s
0 .2289 m
.00375 .2289 L
s
0 .26705 m
.00375 .26705 L
s
0 .34335 m
.00375 .34335 L
s
0 .3815 m
.00375 .3815 L
s
0 .41965 m
.00375 .41965 L
s
0 .49595 m
.00375 .49595 L
s
0 .5341 m
.00375 .5341 L
s
0 .57225 m
.00375 .57225 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .3052 m
.04948 .34295 L
.11328 .39163 L
.17469 .43849 L
.23997 .4883 L
.30286 .53628 L
.36336 .58245 L
.37949 .59476 L
.38738 .60078 L
.3946 .60629 L
.39647 .60771 L
.3985 .60926 L
.40042 .61009 L
.4022 .60873 L
.41037 .60249 L
.42773 .58925 L
.48936 .54223 L
.55485 .49225 L
.61795 .44411 L
.67867 .39778 L
.74325 .3485 L
.80544 .30105 L
.86525 .25542 L
.92892 .20684 L
.9902 .16008 L
s
.9902 .16008 m
1 .1526 L
s
.25 .25 1 r
.015 w
.04 .34118 Mdot
.04221 .34287 Mdot
.04444 .34457 Mdot
.04669 .34629 Mdot
.04896 .34802 Mdot
.05125 .34977 Mdot
.05356 .35153 Mdot
.0559 .35331 Mdot
.05825 .35511 Mdot
.06063 .35692 Mdot
.06303 .35875 Mdot
.06545 .3606 Mdot
.06789 .36247 Mdot
.07036 .36435 Mdot
.07285 .36625 Mdot
.07536 .36816 Mdot
.0779 .37009 Mdot
.08045 .37205 Mdot
.08304 .37401 Mdot
.08564 .376 Mdot
.08827 .37801 Mdot
.09092 .38003 Mdot
.0936 .38207 Mdot
.0963 .38413 Mdot
.09903 .38621 Mdot
.10178 .38831 Mdot
.10456 .39043 Mdot
.10737 .39256 Mdot
.11019 .39472 Mdot
.11305 .39689 Mdot
.11593 .39908 Mdot
.11884 .40129 Mdot
.12177 .40353 Mdot
.12474 .40578 Mdot
.12773 .40805 Mdot
.13074 .41034 Mdot
.13379 .41265 Mdot
.13686 .41497 Mdot
.13996 .41732 Mdot
.14309 .41969 Mdot
.14625 .42207 Mdot
.14944 .42447 Mdot
.15265 .4269 Mdot
.1559 .42933 Mdot
.15917 .43179 Mdot
.16248 .43427 Mdot
.16582 .43676 Mdot
.16918 .43926 Mdot
.17258 .44178 Mdot
.17601 .44432 Mdot
.17947 .44687 Mdot
.18297 .44943 Mdot
.18649 .45201 Mdot
.19005 .45459 Mdot
.19364 .45719 Mdot
.19726 .45979 Mdot
.20092 .4624 Mdot
.20461 .46501 Mdot
.20833 .46763 Mdot
.21209 .47025 Mdot
.21589 .47286 Mdot
.21972 .47548 Mdot
.22358 .47809 Mdot
.22748 .48069 Mdot
.23141 .48328 Mdot
.23538 .48585 Mdot
.23939 .48841 Mdot
.24344 .49095 Mdot
.24752 .49347 Mdot
.25164 .49596 Mdot
.25579 .49842 Mdot
.25999 .50085 Mdot
.26422 .50324 Mdot
.2685 .50559 Mdot
.27281 .50789 Mdot
.27716 .51014 Mdot
.28155 .51234 Mdot
.28599 .51447 Mdot
.29046 .51655 Mdot
.29498 .51855 Mdot
.29953 .52048 Mdot
.30413 .52234 Mdot
.30877 .52411 Mdot
.31345 .52579 Mdot
.31818 .52738 Mdot
.32295 .52887 Mdot
.32776 .53027 Mdot
.33262 .53155 Mdot
.33752 .53272 Mdot
.34247 .53378 Mdot
.34747 .53472 Mdot
.35251 .53553 Mdot
.35759 .53622 Mdot
.36272 .53677 Mdot
.3679 .53719 Mdot
.37313 .53747 Mdot
.37841 .53761 Mdot
.38373 .5376 Mdot
.3891 .53744 Mdot
.39453 .53714 Mdot
.4 .53668 Mdot
.40552 .53607 Mdot
.4111 .5353 Mdot
.41672 .53438 Mdot
.4224 .53329 Mdot
.42813 .53205 Mdot
.43391 .53065 Mdot
.43975 .52909 Mdot
.44563 .52737 Mdot
.45158 .5255 Mdot
.45757 .52346 Mdot
.46363 .52127 Mdot
.46974 .51893 Mdot
.4759 .51643 Mdot
.48212 .51377 Mdot
.4884 .51097 Mdot
.49474 .50802 Mdot
.50113 .50492 Mdot
.50759 .50168 Mdot
.5141 .4983 Mdot
.52067 .49478 Mdot
.52731 .49112 Mdot
.534 .48733 Mdot
.54076 .48341 Mdot
.54758 .47936 Mdot
.55446 .47519 Mdot
.5614 .47089 Mdot
.56841 .46648 Mdot
.57549 .46195 Mdot
.58263 .45731 Mdot
.58983 .45256 Mdot
.5971 .4477 Mdot
.60444 .44274 Mdot
.61184 .43768 Mdot
.61931 .43251 Mdot
.62686 .42725 Mdot
.63447 .4219 Mdot
.64215 .41645 Mdot
.6499 .41091 Mdot
.65772 .40529 Mdot
.66562 .39958 Mdot
.67359 .39378 Mdot
.68163 .38791 Mdot
.68974 .38195 Mdot
.69793 .37591 Mdot
.7062 .36979 Mdot
.71454 .3636 Mdot
.72296 .35733 Mdot
.73146 .35099 Mdot
.74003 .34457 Mdot
.74868 .33808 Mdot
.75742 .33151 Mdot
.76623 .32488 Mdot
.77512 .31817 Mdot
.7841 .31139 Mdot
.79316 .30454 Mdot
.8023 .29762 Mdot
.81153 .29062 Mdot
.82084 .28356 Mdot
.83023 .27643 Mdot
.83972 .26923 Mdot
.84929 .26195 Mdot
.85895 .25461 Mdot
.86869 .24719 Mdot
.87853 .2397 Mdot
.88846 .23215 Mdot
.89848 .22451 Mdot
.90859 .21681 Mdot
.91879 .20904 Mdot
.92909 .20119 Mdot
.93949 .19327 Mdot
.94998 .18527 Mdot
.96056 .1772 Mdot
.97124 .16905 Mdot
.98203 .16083 Mdot
.99291 .15253 Mdot
0 1 0 r
.5 Mabswid
0 .31066 m
.04948 .34841 L
.11328 .39709 L
.17469 .44389 L
.23997 .49231 L
.27267 .51428 L
.30286 .53148 L
.31802 .53855 L
.33223 .54404 L
.34704 .54846 L
.3549 .55024 L
.359 .55101 L
.36336 .55171 L
.36769 .55228 L
.37161 .55269 L
.37351 .55285 L
.37556 .553 L
.37748 .55311 L
.37928 .55319 L
.38037 .55323 L
.38137 .55326 L
.38248 .55329 L
.38368 .55331 L
.38482 .55332 L
.38606 .55331 L
.38724 .55331 L
.38832 .55329 L
.39024 .55324 L
.39133 .5532 L
.39236 .55316 L
.39441 .55305 L
.39665 .55291 L
.40052 .55258 L
.40459 .55213 L
.41187 .55107 L
.42038 .54943 L
.42829 .54754 L
.44486 .54246 L
.46051 .53642 L
.48979 .52236 L
.55037 .4853 L
.61482 .43962 L
.67688 .39329 L
.73655 .34805 L
.80008 .29965 L
.86123 .25301 L
.92624 .20342 L
.98887 .15563 L
s
.98887 .15563 m
1 .14714 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{412.5, 254.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006L0000oR000`400?l00000o`00003oo`3ooonM
0?ooo`00o`3ooonM0?ooo`00303oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0?l0
ooooR@3oool000/0oooo00=000000?oood0000000P3oool00d000000oooo@000003o0?ooohX0oooo
00060?ooo`=000000P3oool00d000000oooo@00000020?ooo`03@000003ooom0000000H0oooo0P00
00000d000000oooo0?ooo`3o0?ooogl0oooo000<0?ooo`07@000003oool0oooo0?oood000000oooo
@00000060?ooo`030000003oool0oooo0?l0ooooP@3oool000/0oooo00=000000?oood0000000P3o
ool00d000000oooo@00000060?ooo`030000003oool0oooo0?l0ooooP@3oool000`0oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooP@3oool0
01T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40
oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3o
oon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo
0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo
0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool001T0oooo00<00000
0?ooo`3oool0o`3ooon10?ooo`006@3oool00`00001000000?ooo`3o0?oooh40oooo000I0?ooo`03
0000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3o
ool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool0
01T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40
oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3o
oon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo
0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo
0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool001T0oooo00<00000
@000003oool0o`3ooon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`03
0000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3o
ool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool0
01T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40
oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3o
oon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo
0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo
0?ooo`3o0?oooh40oooo000I0?ooo`03000004000000oooo0?l0ooooP@3oool001T0oooo00<00000
0?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`03
0000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3o
ool00`000000oooo0?ooo`3o0?oooh40oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool0
01T0oooo00<000000?ooo`3oool0o`3ooon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40
oooo000I0?ooo`030000003oool0oooo0?l0ooooP@3oool001T0oooo00<000000?ooo`3oool0o`3o
oon10?ooo`006@3oool00`000000oooo0?ooo`3o0?oooh40oooo000;0?ooo`900000103oool00d00
0000oooo0?ooo`050?ooo`030000003oool0oooo0?l0ooooJP3oool00`00o`00oooo0?ooo`0D0?oo
o`002`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000H0oooo00<000000?ooo`3o
ool0o`3ooomU0?ooo`@0?coo00<00?l00?ooo`3oool05@3oool000H0oooo0d0000020?ooo`03@000
003ooom000000080oooo00=000000?oood0000001P3oool200000003@000003oool0oooo0?l0oooo
H`3oool203loo`800?l000<0oooo@000003oool05@3oool000/0oooo0T0000030?ooo`03@000003o
oom0000000H0oooo00<000000?ooo`3oool0o`3ooomU0?ooo`0503loo`00o`00?coo03loo`000000
5`3oool000/0oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000060?ooo`030000003o
ool0oooo0?l0ooooHP3oool203loo`800?l00P0o?olI0?ooo`00303oool2@00000<0oooo00=00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooof80oooo00D0?coo003o000o?ol0?coo0000
000J0?ooo`006@3oool00`000000oooo0?ooo`3o0?ooof80oooo00@00?l003loo`0o?ol0?coo6`3o
ool001T0oooo00<000000?ooo`3oool0o`3ooomN0?ooo`80?coo0P00o`000`3oool0?coo03loo`0L
0?ooo`006@3oool00`000000oooo0?ooo`3o0?oooeh0oooo00D0?coo003o000o?ol0?coo0000000N
0?ooo`006@3oool00`000000oooo0?ooo`3o0?oooeh0oooo00@00?l003loo`0o?ol0?coo7`3oool0
01T0oooo00<000000?ooo`3oool0o`3ooomJ0?ooo`80?coo0P00o`000`3oool0?coo03loo`0P0?oo
o`006@3oool00`000000oooo0?ooo`3o0?oooeX0oooo00D0?coo003o000o?ol0?coo0000000R0?oo
o`006@3oool00`000000oooo0?ooo`3o0?oooeX0oooo00@00?l003loo`0o?ol0?coo8`3oool001T0
oooo00<000000?ooo`3oool0o`3ooomF0?ooo`80?coo0P00o`000`3oool0?coo03loo`0T0?ooo`00
6@3oool00`000000oooo0?ooo`3o0?oooeH0oooo00D0?coo003o000o?ol0?coo0000000V0?ooo`00
6@3oool00`000000oooo0?ooo`3o0?oooeH0oooo00@00?l003loo`0o?ol0?coo9`3oool001T0oooo
00<00000@000003oool0o`3ooomB0?ooo`80?coo0P00o`000`3oool0?coo03loo`0X0?ooo`006@3o
ool00`000000oooo0?ooo`3o0?oooe80oooo00D0?coo003o000o?ol0?coo0000000Z0?ooo`006@3o
ool00`000000oooo0?ooo`3o0?oooe80oooo00@00?l003loo`0o?ol0?coo:`3oool001T0oooo00<0
00000?ooo`3oool0o`3ooom>0?ooo`80?coo0P00o`000`3oool0?coo03loo`0/0?ooo`006@3oool0
0`000000oooo0?ooo`3o0?ooodh0oooo00D0?coo003o000o?ol0?coo0000000^0?ooo`006@3oool0
0`000000oooo0?ooo`3o0?ooodX0oooo100o?ol01000o`00?coo03loo`0o?ol_0?ooo`006@3oool0
0`000000oooo0?ooo`3o0?ooodX0oooo0P0o?ol2003o00030?ooo`0o?ol0?coo0300oooo000I0?oo
o`030000003oool0oooo0?l0ooooBP3oool01@0o?ol00?l003loo`0o?ol000000380oooo000I0?oo
o`030000003oool0oooo0?l0ooooA`3oool303loo`03003o000o?ol0?coo03@0oooo000I0?ooo`03
0000003oool0oooo0?l0ooooA`3oool01@0o?ol00?l0003o000o?ol0000003D0oooo000I0?ooo`03
0000003oool0oooo0?l0ooooA`3oool01000o`00?coo03loo`0o?olf0?ooo`006@3oool00`000000
oooo0?ooo`3o0?oood<0oooo0`0o?ol01000o`00oooo03loo`0o?olg0?ooo`006@3oool00`000000
oooo0?ooo`3o0?oood<0oooo0P0o?ol00`00o`00?coo0000000i0?ooo`006@3oool00`000000oooo
0?ooo`3o0?oood<0oooo0P00o`0203loocX0oooo000I0?ooo`03000004000000oooo0?l0oooo?`3o
ool303loo`04003o003oool0?coo03looc/0oooo000I0?ooo`030000003oool0oooo0?l0oooo?`3o
ool203loo`03003o000o?ol0000003d0oooo000I0?ooo`030000003oool0oooo0?l0oooo?`3oool0
100o?ol00?l003loo`0o?oln0?ooo`006@3oool00`000000oooo0?ooo`3o0?oooc`0oooo0P0o?ol2
003o0080?coo?`3oool001T0oooo00<000000?ooo`3oool0o`3oooll0?ooo`0503loo`00o`00?coo
03loo`000000@03oool001T0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`@0?coo00@00?l003lo
o`0o?ol0?coo@@3oool001T0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`80?coo0P00o`000`3o
ool0?coo03loo`120?ooo`006@3oool00`000000oooo0?ooo`3o0?ooocP0oooo00D0?coo003o000o
?ol0?coo000000140?ooo`006@3oool00`000000oooo0?ooo`3o0?ooocD0oooo0`0o?ol00`00o`00
?coo03loo`160?ooo`006@3oool00`000000oooo0?ooo`3o0?ooocD0oooo00D0?coo003o0000o`00
?coo000000170?ooo`006@3oool00`000000oooo0?ooo`3o0?ooocD0oooo00@00?l003loo`0o?ol0
?cooB03oool001T0oooo00<000000?ooo`3oool0o`3ooola0?ooo`<0?coo00@00?l00?ooo`0o?ol0
?cooB@3oool001T0oooo00<000000?ooo`3oool0o`3ooola0?ooo`0503loo`00o`000?l003loo`00
0000B`3oool001T0oooo00<00000@000003oool0o`3oool^0?ooo`<0?coo00@00?l003loo`0o?ol0
?cooC03oool001T0oooo00<000000?ooo`3oool0o`3oool^0?ooo`80?coo00@00?l003loo`0o?ol0
?cooC@3oool001T0oooo00<000000?ooo`3oool0o`3oool^0?ooo`800?l00P0o?om?0?ooo`006@3o
ool00`000000oooo0?ooo`3o0?ooobX0oooo0`0o?ol01000o`00oooo03loo`0o?om@0?ooo`006@3o
ool00`000000oooo0?ooo`3o0?ooobX0oooo0P0o?ol01000o`00?coo0?ooo`00001A0?ooo`006@3o
ool00`000000oooo0?ooo`3o0?ooobX0oooo0P00o`0203loo`030000003oool0oooo0500oooo000I
0?ooo`030000003oool0oooo0?l0oooo9`3oool203loo`04003o000o?ol0?coo03looe@0oooo000I
0?ooo`030000003oool0oooo0?l0oooo9`3oool01@0o?ol00?l003loo`0o?ol0000005D0oooo000I
0?ooo`030000003oool0oooo0?l0oooo8`3oool303loo`800?l00`0o?omF0?ooo`006@3oool00`00
0000oooo0?ooo`3o0?ooob<0oooo0P0o?ol00`00o`00?coo0?ooo`0203looeL0oooo000I0?ooo`03
0000003oool0oooo0?l0oooo8`3oool01@0o?ol00?l003loo`0o?ol0000005T0oooo000I0?ooo`03
0000003oool0oooo0?l0oooo803oool203loo`800?l00P0o?ol00`000000oooo0?ooo`1H0?ooo`00
303oool3@0000080oooo00=000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooob00oooo
00D0?coo003o000o?ol0?coo0000001L0?ooo`003@3oool01T000000oooo0?oood000000oooo@000
00H0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`<0?coo00@00?l003loo`0o?ol0?cooG@3oool0
00H0oooo0d0000020?ooo`A0000000@0oooo@000003ooom000001P3oool200000003@000003oool0
oooo0?l0oooo6`3oool00`0o?ol00?l0003o000303looeh0oooo000;0?ooo`03@000003ooom00000
0080oooo00=000000?oood0000001P3oool200000?l0oooo7P3oool01@00o`00?coo03loo`0o?ol0
000005l0oooo000<0?ooo`9000000P3oool00d000000oooo@00000060?ooo`04003o003oool00000
00000?l0oooo603oool303loo`04003o003oool0?coo03loof40oooo000=0?ooo`05@000003oool0
oooo0?oood0000001`3oool01@0000000?l00?ooo`3oool000000?l0oooo5`3oool01P0o?ol00?l0
003o000o?ol0oooo00000680oooo000I0?ooo`060000003oool00?l0003o003oool00000o`3ooolC
0?ooo`<0?coo00D00?l003loo`0o?ol0?coo0000001S0?ooo`006@3oool01P000000oooo0?ooo`3o
ool00?l00?ooo`800000o`3ooolA0?ooo`80?coo00@00?l003loo`0o?ol0?cooI@3oool001T0oooo
00<000000?ooo`3oool00P3oool01000o`00oooo0?ooo`00003o0?oooa00oooo00D0?coo003o000o
?ol0?coo0000001V0?ooo`006@3oool00`000000oooo0?ooo`030?ooo`800?l000<0oooo0000003o
ool0o`3oool;0?ooo`80?coo0P00o`0203loo`030000003oool0oooo06D0oooo000I0?ooo`030000
003oool0oooo00D0oooo00<00?l00?ooo`000000o`3oool;0?ooo`0403loo`00o`00?coo03loo`80
0000J03oool001T0oooo00<000000?ooo`3oool01P3oool01000o`00oooo00000000003o0?ooo`H0
oooo0`0o?ol01000o`00?coo03loo`0o?omZ0?ooo`006@3oool00`000000oooo0?ooo`070?ooo`04
003o003oool0oooo00000?l0oooo1@3oool203loo`04003o000o?ol0?coo03loof/0oooo000I0?oo
o`030000003oool0oooo00P0oooo0P00o`000`3oool000000?ooo`3o0?ooo`<0oooo0P00o`0203lo
o`030000003oool0oooo06X0oooo000I0?ooo`030000003oool0oooo00X0oooo00@00?l00?ooo`00
00000000o@3oool303loo`04003o003oool0?coo03loofh0oooo000I0?ooo`030000003oool0oooo
00T0oooo0P0o?ol01000o`00?coo03loo`00003l0?ooo`80?coo00@00?l003loo`3oool00000K`3o
ool001T0oooo00<00000@000003oool02@3oool303loo`800?l00P0o?ooh0?ooo`<0?coo0P00o`02
03loo`030000003oool0oooo06h0oooo000I0?ooo`030000003oool0oooo00T0oooo1@0o?ol00`00
o`00?coo0000003g0?ooo`80?coo00@00?l003loo`0o?ol0?cooLP3oool001T0oooo00<000000?oo
o`3oool02P3oool503loo`04003o000o?ol0?coo00000?80oooo100o?ol01000o`00?coo03loo`00
001c0?ooo`006@3oool00`000000oooo0?ooo`0<0?ooo`@0?coo00@00?l003loo`0o?ol00000l@3o
ool203loo`800?l00P0o?ol00`000000oooo0?ooo`1b0?ooo`006@3oool00`000000oooo0?ooo`0=
0?ooo`@0?coo0P00o`0203looo00oooo00@0?coo003o000o?ol0?coo0P00001e0?ooo`006@3oool0
0`000000oooo0?ooo`0>0?ooo`D0?coo00@00?l003loo`0000000000j`3oool303loo`04003o000o
?ol0?coo000007L0oooo000I0?ooo`030000003oool0oooo0100oooo100o?ol01000o`00?coo03lo
o`00003Z0?ooo`0603loo`00o`000?l003loo`3oool00000N03oool001T0oooo00<000000?ooo`3o
ool04@3oool403loo`800?l000<0?coo0000003oool0i@3oool303loo`05003o000o?ol0?coo03lo
o`000000N@3oool001T0oooo00<000000?ooo`3oool04P3oool503loo`03003o000o?ol0?coo0>D0
oooo0P0o?ol01000o`00?coo03loo`0o?omk0?ooo`006@3oool00`000000oooo0?ooo`0C0?ooo`D0
?coo00@00?l003loo`0o?ol00000h03oool303loo`800?l00P0o?ol00`000000oooo0?ooo`1j0?oo
o`006@3oool00`000000oooo0?ooo`0E0?ooo`@0?coo00@00?l003loo`0o?ol00000g`3oool203lo
o`05003o000o?ol0?coo03loo`000000O@3oool001T0oooo00<000000?ooo`3oool05P3oool403lo
o`800?l00P0o?ooK0?ooo`<0?coo0P00o`0203loo`030000003oool0oooo07d0oooo000I0?ooo`03
0000003oool0oooo01P0oooo100o?ol00`00o`00?coo03loo`3J0?ooo`80?coo00D00?l003loo`0o
?ol0?coo000000200?ooo`006@3oool00`000000oooo0?ooo`0I0?ooo`@0?coo00@00?l003loo`0o
?ol00000f03oool0100o?ol00?l003loo`0o?ol200000840oooo000I0?ooo`03000004000000oooo
01X0oooo100o?ol01000o`00?coo03loo`0o?ooD0?ooo`80?coo0P00o`0203loo`030000003oool0
oooo0840oooo000I0?ooo`030000003oool0oooo01`0oooo0`0o?ol2003o0080?cood`3oool01P0o
?ol00?l003loo`0o?ol0oooo000008@0oooo000I0?ooo`030000003oool0oooo01d0oooo100o?ol0
1000o`00?coo03loo`00003>0?ooo`<0?coo00D00?l003loo`0o?ol0?coo000000250?ooo`006@3o
ool00`000000oooo0?ooo`0N0?ooo`@0?coo00@00?l003loo`0o?ol0?cooc@3oool00`0o?ol00?l0
003o000303loohL0oooo000I0?ooo`030000003oool0oooo0200oooo0`0o?ol2003o0080?coob@3o
ool303loo`05003o000o?ol0?coo03loo`000000R03oool001T0oooo00<000000?ooo`3oool08@3o
ool403loo`03003o000o?ol0?coo0<P0oooo0P0o?ol01@00o`00?coo03loo`0o?ol0000008T0oooo
000I0?ooo`030000003oool0oooo0280oooo100o?ol01000o`00?coo03loo`0000330?ooo`<0?coo
0P00o`0203loo`030000003oool0oooo08T0oooo000I0?ooo`030000003oool0oooo02@0oooo0`0o
?ol01000o`00?coo03loo`0o?oo20?ooo`80?coo00D00?l003loo`0o?ol0?coo0000002<0?ooo`00
6@3oool00`000000oooo0?ooo`0U0?ooo`<0?coo0P00o`0203lookh0oooo100o?ol00`00o`00?coo
03loo`02000008d0oooo000I0?ooo`030000003oool0oooo02H0oooo100o?ol01000o`00?coo03lo
o`00002l0?ooo`80?coo0P00o`0203loo`030000003oool0oooo08d0oooo000I0?ooo`030000003o
ool0oooo02L0oooo100o?ol01000o`00?coo03loo`00002h0?ooo`@0?coo00D00?l003loo`0o?ol0
oooo0000002@0?ooo`006@3oool00`000000oooo0?ooo`0Y0?ooo`<0?coo0P00o`000`0o?ol00000
0?ooo`2f0?ooo`<0?coo00<00?l003loo`0o?ol00P00002A0?ooo`006@3oool00`000000oooo0?oo
o`0Z0?ooo`@0?coo00@00?l003loo`0o?ol0?coo/`3oool403loo`04003o000o?ol0oooo000009<0
oooo000I0?ooo`030000003oool0oooo02/0oooo100o?ol01000o`00?coo03loo`0o?onb0?ooo`80
?coo0P00o`000`0o?ol0oooo0000002D0?ooo`006@3oool00`00001000000?ooo`0/0?ooo`@0?coo
00@00?l003loo`0o?ol0?coo[P3oool403loo`05003o000o?ol0?coo0?ooo`000000U@3oool001T0
oooo00<000000?ooo`3oool0;@3oool403loo`800?l00P0o?on]0?ooo`<0?coo00<00?l003loo`0o
?ol00P00002F0?ooo`006@3oool00`000000oooo0?ooo`0`0?ooo`<0?coo00@00?l003loo`0o?ol0
0000Z03oool403loo`800?l000<0?coo0?ooo`000000V03oool001T0oooo00<000000?ooo`3oool0
<@3oool303loo`04003o000o?ol0?coo00000:L0oooo0`0o?ol01@00o`00?coo03loo`3oool00000
09T0oooo000I0?ooo`030000003oool0oooo0380oooo0`0o?ol2003o0080?cooX`3oool503loo`03
003o000o?ol0oooo00800000VP3oool001T0oooo00<000000?ooo`3oool0<`3oool403loo`04003o
000o?ol0?coo03looj40oooo0`0o?ol2003o000303loo`3oool0000009`0oooo000I0?ooo`030000
003oool0oooo03@0oooo100o?ol01000o`00?coo03loo`0o?onN0?ooo`@0?coo00D00?l003loo`3o
ool0oooo0000002M0?ooo`006@3oool00`000000oooo0?ooo`0f0?ooo`<0?coo0P00o`0203looid0
oooo0`0o?ol00`00o`00?coo0?ooo`02000009h0oooo000I0?ooo`030000003oool0oooo03L0oooo
100o?ol01000o`00?coo03loo`0o?onH0?ooo`@0?coo0P00o`000`0o?ol0oooo0000002P0?ooo`00
6@3oool00`000000oooo0?ooo`0i0?ooo`<0?coo00@00?l003loo`0o?ol0?cooU03oool603loo`05
003o000o?ol0?coo0?ooo`000000X@3oool001T0oooo00<000000?ooo`3oool0>P3oool303loo`04
003o000o?ol0?coo03looi<0oooo1@0o?ol01@00o`00?coo0?ooo`3oool000000:80oooo000I0?oo
o`030000003oool0oooo03`0oooo0P0o?ol2003o0080?cooT03oool503loo`800?l000@0?coo0?oo
o`0000000000X`3oool000/0oooo0d0000030?ooo`03@000003oool0oooo00D0oooo00<000000?oo
o`3oool0?@3oool303loo`04003o000o?ol0?coo03loohh0oooo100o?ol01@00o`00oooo0?ooo`3o
ool000000:D0oooo000;0?ooo`03@000003oool0oooo0080oooo00=000000?oood0000001P3oool0
0`000000oooo0?ooo`0n0?ooo`<0?coo00@00?l003loo`0o?ol0?cooRP3oool503loo`800?l00`3o
ool00`000000oooo0?ooo`2T0?ooo`001P3oool3@00000<0oooo00M000000?ooo`3oool0oooo@000
003ooom0000000H0oooo0P0000000d000000oooo0?ooo`0m0?ooo`<0?coo0P00o`0203loohT0oooo
100o?ol01000o`00?coo0?ooo`3oool200000:L0oooo000<0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000060?ooo`030000003oool0oooo0440oooo0`0o?ol01000o`00?coo03loo`0o?on4
0?ooo`H0?coo00D00?l00?ooo`3oool0oooo0000002Y0?ooo`002`3oool00d000000oooo@0000002
0?ooo`03@000003ooom0000000H0oooo00<000000?ooo`3oool0@P3oool303loo`04003o000o?ol0
?coo03looh40oooo1P0o?ol2003o00<0oooo00<000000?ooo`3oool0Z03oool000`0oooo00=00000
0?ooo`3oool00P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo04<0oooo0`0o?ol2
003o0080?cooP03oool503loo`03003o003oool0oooo0080oooo00<000000?ooo`3oool0Z@3oool0
01T0oooo00<000000?ooo`3oool0A@3oool303loo`04003o000o?ol0?coo03loog/0oooo1P0o?ol2
003o00<0oooo0P00002/0?ooo`006@3oool00`000000oooo0?ooo`160?ooo`<0?coo00@00?l003lo
o`0o?ol0?cooN03oool703loo`03003o003oool0oooo0080oooo00<000000?ooo`3oool0[03oool0
01T0oooo00<000000?ooo`3oool0A`3oool303loo`800?l00`0o?omf0?ooo`D0?coo0P00o`040?oo
o`030000003oool0oooo0:d0oooo000I0?ooo`030000003oool0oooo04T0oooo0`0o?ol00`00o`00
?coo03loo`0203loog40oooo1`0o?ol00`00o`00oooo0?ooo`030?ooo`030000003oool0oooo0:h0
oooo000I0?ooo`030000003oool0oooo04X0oooo0`0o?ol00`00o`00?coo03loo`0303loofd0oooo
200o?ol00`00o`00oooo0?ooo`020?ooo`800000/@3oool001T0oooo00<000000?ooo`3oool0C03o
ool203loo`800?l0100o?om/0?ooo`H0?coo0P00o`040?ooo`030000003oool0oooo0;40oooo000I
0?ooo`030000003oool0oooo04d0oooo0`0o?ol00`00o`00?coo03loo`0303loofL0oooo200o?ol0
0`00o`00oooo0?ooo`030?ooo`030000003oool0oooo0;80oooo000I0?ooo`030000003oool0oooo
0500oooo00<0?coo003o000o?ol0100o?omT0?ooo`P0?coo0P00o`040?ooo`800000]@3oool001T0
oooo00<000000?ooo`3oool0D@3oool00`0o?ol00?l0003o000503loof80oooo1P0o?ol00`3oool0
0?l00?ooo`040?ooo`030000003oool0oooo0;D0oooo000I0?ooo`030000003oool0oooo05<0oooo
00<0?coo003o000o?ol0100o?omN0?ooo`P0?coo0P00o`050?ooo`030000003oool0oooo0;H0oooo
000I0?ooo`03000004000000oooo05@0oooo00<0?coo003o0000o`001@0o?omJ0?ooo`P0?coo0P00
o`060?ooo`030000003oool0oooo0;L0oooo000I0?ooo`030000003oool0oooo05H0oooo00<0?coo
003o000o?ol0100o?omG0?ooo`P0?coo00<0oooo003o003oool01@3oool200000;X0oooo000I0?oo
o`030000003oool0oooo05L0oooo00<0?coo003o0000o`001@0o?omB0?ooo`X0?coo0P00o`060?oo
o`030000003oool0oooo0;X0oooo000I0?ooo`030000003oool0oooo05T0oooo00<0?coo003o000o
?ol01P0o?om=0?ooo`X0?coo00<0oooo003o003oool01P3oool00`000000oooo0?ooo`2k0?ooo`00
6@3oool00`000000oooo0?ooo`1J0?ooo`0303loo`00o`000?l000L0?cooB`3oool803loo`030?oo
o`00o`000?l000H0oooo0P00002n0?ooo`006@3oool00`000000oooo0?ooo`1L0?ooo`0303loo`00
o`00?coo00H0?cooB03oool703loo`<0oooo00<00?l00?ooo`3oool01@3oool00`000000oooo0?oo
o`2n0?ooo`006@3oool00`000000oooo0?ooo`1M0?ooo`0303loo`00o`000?l000L0?coo@`3oool8
03loo`<0oooo0P00o`070?ooo`030000003oool0oooo0;l0oooo000I0?ooo`030000003oool0oooo
0600oooo00<00?l003loo`0o?ol01`0o?oll0?ooo`/0?coo0P3oool2003o00L0oooo0P0000320?oo
o`006@3oool00`000000oooo0?ooo`1Q0?ooo`800?l02@0o?olh0?ooo``0?coo0P3oool00`00o`00
oooo0?ooo`060?ooo`030000003oool0oooo0<80oooo000I0?ooo`030000003oool0oooo06<0oooo
0P00o`0:03looc80oooo300o?ol30?ooo`800?l0203oool00`000000oooo0?ooo`330?ooo`006@3o
ool00`000000oooo0?ooo`1T0?ooo`0300000000o`000?l000X0?coo;P3oool<03loo`@0oooo00<0
0?l00?ooo`3oool01P3oool200000<H0oooo000I0?ooo`030000003oool0oooo06H0oooo00<00000
003o0000o`002`0o?olW0?ooo``0?coo1P3oool2003o00P0oooo00<000000?ooo`3oool0aP3oool0
01T0oooo00<000000?ooo`3oool0I`3oool010000000oooo003o0000o`0?03looad0oooo3@0o?ol7
0?ooo`800?l02@3oool00`000000oooo0?ooo`370?ooo`006@3oool00`000000oooo0?ooo`1X0?oo
o`80000000@0oooo003o0000o`00oooo4@0o?olA0?oooa80?coo1`3oool2003o00T0oooo0P00003:
0?ooo`006@3oool00`00001000000?ooo`1Z0?ooo`030000003oool0oooo00<00?l0<00o?ol70?oo
o`800?l02P3oool00`000000oooo0?ooo`3:0?ooo`006@3oool00`000000oooo0?ooo`1[0?ooo`03
0000003oool0oooo0080oooo0`00o`0Y03loo`P0oooo0`00o`0;0?ooo`030000003oool0oooo0</0
oooo000I0?ooo`030000003oool0oooo06`0oooo0P0000050?ooo`800?l00`3ooolO03loo`X0oooo
0`00o`0<0?ooo`800000cP3oool001T0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?oo
o`040?ooo`<00?l01P3ooolC03loo`d0oooo0`00o`0>0?ooo`030000003oool0oooo0<h0oooo000I
0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool01P3oool2003o0240oooo0`00o`0@
0?ooo`030000003oool0oooo0<l0oooo000I0?ooo`030000003oool0oooo0700oooo0P0000080?oo
o`<00?l0603oool6003o0140oooo0P00003B0?ooo`006@3oool00`000000oooo0?ooo`1b0?ooo`03
0000003oool0oooo00P0oooo1`00o`0<0?ooo`D00?l05P3oool00`000000oooo0?ooo`3B0?ooo`00
6@3oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo00h0oooo3000o`0J0?ooo`030000
003oool0oooo0=<0oooo000I0?ooo`030000003oool0oooo07@0oooo0P00000b0?ooo`800000eP3o
ool001T0oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo0=H0oooo000I0?ooo`030000003oool0oooo07L0oooo0P00000]0?ooo`030000003oool0oooo
0=L0oooo000I0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0:@3oool00`000000
oooo0?ooo`3H0?ooo`006@3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo02H0oooo
0P00003K0?ooo`006@3oool00`000000oooo0?ooo`1k0?ooo`8000009@3oool00`000000oooo0?oo
o`3K0?ooo`006@3oool00`00001000000?ooo`1m0?ooo`030000003oool0oooo0240oooo00<00000
0?ooo`3oool0g03oool001T0oooo00<000000?ooo`3oool0@`3oool3@0000080oooo00=000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0:0?ooo`900000103oool00d000000oooo0?ooo`0;0?oo
o`800000<`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03d0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0>P3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool03`3oool001T0oooo00<000000?ooo`3oool0A03oool01T00
0000oooo0?oood000000oooo@00003D0oooo0P00000:0?ooo`03@000003ooom000000080oooo00=0
00000?oood0000002`3oool00`000000oooo0?ooo`0b0?ooo`03@000003ooom000000080oooo00=0
00000?oood000000@03oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000
oooo@000000m0?ooo`05@000003oool0oooo0?oood000000103oool00d000000oooo@000000@0?oo
o`006@3oool00`000000oooo0?ooo`120?ooo`A0000000@0oooo@000003ooom00000=`3oool00`00
0000oooo0?ooo`070?ooo`03@000003ooom000000080oooo00=000000?oood0000002P3oool00`00
0000oooo0?ooo`0c0?ooo`03@000003ooom000000080oooo00=000000?oood000000@03oool01d00
0000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000m0?ooo`03@000003o
ool0oooo0080oooo00M000000?ooo`3oool0oooo@000003ooom000000100oooo000I0?ooo`030000
003oool0oooo0480oooo00=000000?oood0000000P3oool00d000000oooo@000000h0?ooo`030000
003oool0oooo00H0oooo0T0000030?ooo`03@000003ooom0000000P0oooo0P00000g0?ooo`07@000
003oool0oooo0?oood000000oooo@00000100?ooo`07@000003oool0oooo0?oood000000oooo@000
00020?ooo`03@000003ooom0000003d0oooo00=000000?ooo`3oool00P3oool01d000000oooo0?oo
o`3ooom000000?oood000000403oool001T0oooo00<000000?ooo`3oool0@`3oool2@0000080oooo
00=000000?oood000000>@3oool00`000000oooo0?ooo`050?ooo`03@000003oool0oooo0080oooo
00=000000?oood0000001`3oool00`000000oooo0?ooo`0f0?ooo`03@000003ooom000000080oooo
00=000000?oood000000@03oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d00
0000oooo@000000m0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003o
oom000000100oooo000I0?ooo`030000003oool0oooo04@0oooo00E000000?ooo`3oool0oooo@000
000k0?ooo`8000001P3oool2@00000<0oooo00=000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0h0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0?P3oool2@00000@0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`0k0?ooo`900000103oool00d000000oooo0?oo
o`020?ooo`03@000003oool0oooo00l0oooo000I0?ooo`030000003oool0oooo08H0oooo00<00000
0?ooo`3oool03P3oool200000>L0oooo000I0?ooo`030000003oool0oooo08L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`3W0?ooo`006@3oool00`000000oooo0?ooo`280?ooo`80
00002`3oool00`000000oooo0?ooo`3X0?ooo`006@3oool00`000000oooo0?ooo`2:0?ooo`030000
003oool0oooo00H0oooo0P00003[0?ooo`006@3oool00`000000oooo0?ooo`2;0?ooo`8000001@3o
ool00`000000oooo0?ooo`3[0?ooo`006@3oool00`000000oooo0?ooo`2=0?ooo`030000003oool0
oooo00800000h`3oool3@00000P0oooo000I0?ooo`030000003oool0oooo08d0oooo0`00003U0?oo
o`03@000003ooom0000000P0oooo000I0?ooool00000K@0000000d000000oooo0?ooo`0;0?ooo`03
@000003oool0oooo00H0oooo000I0?ooo`030000003oool0oooo00l0oooo00=000000?ooo`3oool0
3`3oool00d000000oooo0?ooo`0?0?ooo`03@000003oool0oooo0100oooo00<000000?ooo`3oool0
3`3oool00d000000oooo0?ooo`0?0?ooo`03@000003oool0oooo00l0oooo00=000000?ooo`3oool0
403oool00`000000oooo0?ooo`0?0?ooo`03@000003oool0oooo00l0oooo00=000000?ooo`3oool0
3`3oool00d000000oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo00=000000?ooo`3oool0
3`3oool00d000000oooo0?ooo`0?0?ooo`03@000003oool0oooo00l0oooo00<000000?ooo`3oool0
403oool00d000000oooo0?ooo`0?0?ooo`03@000003oool0oooo00l0oooo00=000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0:0?ooo`03@000003oool0oooo00L0oooo000I0?ooo`03@000003o
ool0oooo04H0oooo00=000000?ooo`3oool0AP3oool00d000000oooo0?ooo`150?ooo`03@000003o
ool0oooo04H0oooo00=000000?ooo`3oool0AP3oool00d000000oooo0?ooo`090?ooo`03@000003o
oom0000000P0oooo003o0?oooi80oooo0d0000080?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00
o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00
o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00
o`3ooonM0?ooo`005`3oool2@0000?l0ooooQ03oool001H0oooo00=000000?oood000000o`3ooon4
0?ooo`005P3oool00d000000oooo@000003o0?oooh@0oooo000F0?ooo`04@000003oool0oooo@000
0?l0ooooP`3oool001D0oooo00E000000?ooo`3oool0oooo@000003o0?oooh<0oooo000E0?ooo`90
000000<0oooo@00004000000o`3ooon30?ooo`00o`3ooonM0?ooo`00o`3ooonM0?ooo`00o`3ooonM
0?ooo`00o`3ooonM0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 411.5}, {253.938, 0}} -> {13.0929, -81.6181, 
  0.274289, 0.359485}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=SoldStraddle[xs[[i]],X,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m = 100, n=100\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.157596 0.00755858 0.439132 34.4756 [
[.14475 .42663 -6 -9 ]
[.14475 .42663 6 0 ]
[.29592 .42663 -6 -9 ]
[.29592 .42663 6 0 ]
[.44709 .42663 -6 -9 ]
[.44709 .42663 6 0 ]
[.59826 .42663 -9 -9 ]
[.59826 .42663 9 0 ]
[.74943 .42663 -9 -9 ]
[.74943 .42663 9 0 ]
[.9006 .42663 -9 -9 ]
[.9006 .42663 9 0 ]
[-0.01892 .00819 -42 -4.5 ]
[-0.01892 .00819 0 4.5 ]
[-0.01892 .09438 -30 -4.5 ]
[-0.01892 .09438 0 4.5 ]
[-0.01892 .18056 -42 -4.5 ]
[-0.01892 .18056 0 4.5 ]
[-0.01892 .26675 -36 -4.5 ]
[-0.01892 .26675 0 4.5 ]
[-0.01892 .35294 -42 -4.5 ]
[-0.01892 .35294 0 4.5 ]
[-0.01892 .52532 -36 -4.5 ]
[-0.01892 .52532 0 4.5 ]
[-0.01892 .61151 -30 -4.5 ]
[-0.01892 .61151 0 4.5 ]
[ -0.00642 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.14475 .43913 m
.14475 .44538 L
s
[(40)] .14475 .42663 0 1 Mshowa
.29592 .43913 m
.29592 .44538 L
s
[(60)] .29592 .42663 0 1 Mshowa
.44709 .43913 m
.44709 .44538 L
s
[(80)] .44709 .42663 0 1 Mshowa
.59826 .43913 m
.59826 .44538 L
s
[(100)] .59826 .42663 0 1 Mshowa
.74943 .43913 m
.74943 .44538 L
s
[(120)] .74943 .42663 0 1 Mshowa
.9006 .43913 m
.9006 .44538 L
s
[(140)] .9006 .42663 0 1 Mshowa
.125 Mabswid
.03137 .43913 m
.03137 .44288 L
s
.06916 .43913 m
.06916 .44288 L
s
.10695 .43913 m
.10695 .44288 L
s
.18254 .43913 m
.18254 .44288 L
s
.22033 .43913 m
.22033 .44288 L
s
.25813 .43913 m
.25813 .44288 L
s
.33371 .43913 m
.33371 .44288 L
s
.3715 .43913 m
.3715 .44288 L
s
.4093 .43913 m
.4093 .44288 L
s
.48488 .43913 m
.48488 .44288 L
s
.52268 .43913 m
.52268 .44288 L
s
.56047 .43913 m
.56047 .44288 L
s
.63605 .43913 m
.63605 .44288 L
s
.67385 .43913 m
.67385 .44288 L
s
.71164 .43913 m
.71164 .44288 L
s
.78723 .43913 m
.78723 .44288 L
s
.82502 .43913 m
.82502 .44288 L
s
.86281 .43913 m
.86281 .44288 L
s
.9384 .43913 m
.9384 .44288 L
s
.97619 .43913 m
.97619 .44288 L
s
.25 Mabswid
0 .43913 m
1 .43913 L
s
-0.00642 .00819 m
-0.00017 .00819 L
s
[(-0.0125)] -0.01892 .00819 1 0 Mshowa
-0.00642 .09438 m
-0.00017 .09438 L
s
[(-0.01)] -0.01892 .09438 1 0 Mshowa
-0.00642 .18056 m
-0.00017 .18056 L
s
[(-0.0075)] -0.01892 .18056 1 0 Mshowa
-0.00642 .26675 m
-0.00017 .26675 L
s
[(-0.005)] -0.01892 .26675 1 0 Mshowa
-0.00642 .35294 m
-0.00017 .35294 L
s
[(-0.0025)] -0.01892 .35294 1 0 Mshowa
-0.00642 .52532 m
-0.00017 .52532 L
s
[(0.0025)] -0.01892 .52532 1 0 Mshowa
-0.00642 .61151 m
-0.00017 .61151 L
s
[(0.005)] -0.01892 .61151 1 0 Mshowa
.125 Mabswid
-0.00642 .02542 m
-0.00267 .02542 L
s
-0.00642 .04266 m
-0.00267 .04266 L
s
-0.00642 .0599 m
-0.00267 .0599 L
s
-0.00642 .07714 m
-0.00267 .07714 L
s
-0.00642 .11161 m
-0.00267 .11161 L
s
-0.00642 .12885 m
-0.00267 .12885 L
s
-0.00642 .14609 m
-0.00267 .14609 L
s
-0.00642 .16333 m
-0.00267 .16333 L
s
-0.00642 .1978 m
-0.00267 .1978 L
s
-0.00642 .21504 m
-0.00267 .21504 L
s
-0.00642 .23228 m
-0.00267 .23228 L
s
-0.00642 .24952 m
-0.00267 .24952 L
s
-0.00642 .28399 m
-0.00267 .28399 L
s
-0.00642 .30123 m
-0.00267 .30123 L
s
-0.00642 .31847 m
-0.00267 .31847 L
s
-0.00642 .3357 m
-0.00267 .3357 L
s
-0.00642 .37018 m
-0.00267 .37018 L
s
-0.00642 .38742 m
-0.00267 .38742 L
s
-0.00642 .40466 m
-0.00267 .40466 L
s
-0.00642 .42189 m
-0.00267 .42189 L
s
-0.00642 .45637 m
-0.00267 .45637 L
s
-0.00642 .47361 m
-0.00267 .47361 L
s
-0.00642 .49084 m
-0.00267 .49084 L
s
-0.00642 .50808 m
-0.00267 .50808 L
s
-0.00642 .54256 m
-0.00267 .54256 L
s
-0.00642 .5598 m
-0.00267 .5598 L
s
-0.00642 .57703 m
-0.00267 .57703 L
s
-0.00642 .59427 m
-0.00267 .59427 L
s
.25 Mabswid
-0.00642 0 m
-0.00642 .61803 L
s
.25 .25 1 r
.02 w
.02381 .43913 Mdot
.02548 .43907 Mdot
.02716 .43901 Mdot
.02887 .43895 Mdot
.03058 .4389 Mdot
.03231 .43885 Mdot
.03406 .43881 Mdot
.03583 .43877 Mdot
.03761 .43873 Mdot
.0394 .43869 Mdot
.04122 .43866 Mdot
.04305 .43864 Mdot
.04489 .43861 Mdot
.04676 .43859 Mdot
.04864 .43858 Mdot
.05054 .43857 Mdot
.05245 .43856 Mdot
.05439 .43857 Mdot
.05634 .43857 Mdot
.05831 .43859 Mdot
.06029 .43861 Mdot
.0623 .43865 Mdot
.06432 .4387 Mdot
.06637 .43877 Mdot
.06843 .43885 Mdot
.07051 .43896 Mdot
.07261 .4391 Mdot
.07473 .43926 Mdot
.07687 .43947 Mdot
.07903 .43972 Mdot
.0812 .44002 Mdot
.0834 .44038 Mdot
.08562 .44082 Mdot
.08786 .44134 Mdot
.09012 .44195 Mdot
.0924 .44267 Mdot
.0947 .44352 Mdot
.09702 .44451 Mdot
.09937 .44566 Mdot
.10173 .447 Mdot
.10412 .44854 Mdot
.10653 .4503 Mdot
.10896 .45232 Mdot
.11141 .4546 Mdot
.11389 .45719 Mdot
.11639 .4601 Mdot
.11891 .46336 Mdot
.12145 .46698 Mdot
.12402 .47099 Mdot
.12662 .47541 Mdot
.12923 .48024 Mdot
.13187 .48549 Mdot
.13454 .49117 Mdot
.13723 .49727 Mdot
.13994 .50378 Mdot
.14268 .51066 Mdot
.14544 .51788 Mdot
.14823 .5254 Mdot
.15105 .53315 Mdot
.15389 .54106 Mdot
.15676 .54904 Mdot
.15965 .55699 Mdot
.16257 .56478 Mdot
.16552 .57229 Mdot
.16849 .57936 Mdot
.17149 .58585 Mdot
.17452 .59158 Mdot
.17758 .59638 Mdot
.18066 .60005 Mdot
.18378 .60243 Mdot
.18692 .60332 Mdot
.19009 .60254 Mdot
.19329 .59993 Mdot
.19652 .59533 Mdot
.19978 .58861 Mdot
.20307 .57964 Mdot
.20639 .56834 Mdot
.20974 .55467 Mdot
.21312 .53859 Mdot
.21653 .52014 Mdot
.21998 .49938 Mdot
.22345 .47641 Mdot
.22696 .45139 Mdot
.2305 .42452 Mdot
.23407 .39603 Mdot
.23768 .36621 Mdot
.24132 .33539 Mdot
.24499 .30391 Mdot
.2487 .27216 Mdot
.25244 .24055 Mdot
.25621 .2095 Mdot
.26002 .17943 Mdot
.26386 .15078 Mdot
.26774 .12394 Mdot
.27166 .09932 Mdot
.27561 .07729 Mdot
.2796 .05818 Mdot
.28362 .04228 Mdot
.28768 .02983 Mdot
.29178 .02101 Mdot
.29592 .01595 Mdot
.30009 .01472 Mdot
.30431 .01731 Mdot
.30856 .02367 Mdot
.31285 .03368 Mdot
.31718 .04715 Mdot
.32155 .06386 Mdot
.32596 .08352 Mdot
.33041 .1058 Mdot
.3349 .13035 Mdot
.33944 .15679 Mdot
.34401 .18472 Mdot
.34863 .21371 Mdot
.35329 .24337 Mdot
.35799 .27327 Mdot
.36274 .30304 Mdot
.36753 .33231 Mdot
.37236 .36072 Mdot
.37724 .38797 Mdot
.38216 .4138 Mdot
.38713 .43796 Mdot
.39215 .46026 Mdot
.39721 .48057 Mdot
.40231 .49877 Mdot
.40747 .51481 Mdot
.41267 .52865 Mdot
.41792 .54031 Mdot
.42322 .54984 Mdot
.42856 .55731 Mdot
.43396 .56283 Mdot
.4394 .56652 Mdot
.4449 .56852 Mdot
.45044 .56899 Mdot
.45604 .56807 Mdot
.46169 .56595 Mdot
.46739 .56278 Mdot
.47314 .55874 Mdot
.47895 .55397 Mdot
.48481 .54864 Mdot
.49072 .54288 Mdot
.49669 .53682 Mdot
.50271 .53059 Mdot
.50879 .52429 Mdot
.51492 .518 Mdot
.52111 .51182 Mdot
.52736 .50581 Mdot
.53367 .50002 Mdot
.54003 .49449 Mdot
.54645 .48927 Mdot
.55293 .48436 Mdot
.55947 .4798 Mdot
.56607 .47557 Mdot
.57274 .47169 Mdot
.57946 .46814 Mdot
.58624 .46492 Mdot
.59309 .46202 Mdot
.6 .45942 Mdot
.60697 .45709 Mdot
.61401 .45503 Mdot
.62111 .45321 Mdot
.62828 .45161 Mdot
.63552 .45021 Mdot
.64282 .449 Mdot
.65018 .44795 Mdot
.65762 .44704 Mdot
.66512 .44627 Mdot
.6727 .44561 Mdot
.68034 .44504 Mdot
.68805 .44457 Mdot
.69584 .44416 Mdot
.70369 .44383 Mdot
.71162 .44354 Mdot
.71962 .44331 Mdot
.7277 .44311 Mdot
.73585 .44294 Mdot
.74407 .4428 Mdot
.75237 .44269 Mdot
.76075 .44258 Mdot
.7692 .44249 Mdot
.77773 .44241 Mdot
.78634 .44234 Mdot
.79503 .44227 Mdot
.8038 .4422 Mdot
.81265 .44212 Mdot
.82158 .44205 Mdot
.83059 .44197 Mdot
.83969 .44188 Mdot
.84887 .44179 Mdot
.85813 .44168 Mdot
.86748 .44156 Mdot
.87692 .44143 Mdot
.88644 .44129 Mdot
.89605 .44113 Mdot
.90575 .44095 Mdot
.91554 .44076 Mdot
.92542 .44054 Mdot
.93539 .44031 Mdot
.94545 .44005 Mdot
.9556 .43977 Mdot
.96585 .43946 Mdot
.97619 .43913 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`003P3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo0080oooo00=000000?ooo`3oool01D000000103ooom00000@000040000030?ooo`03
@000003oool0oooo0?H0oooo000=0?ooo`03@000003ooom0000000L0oooo00=000000?oood000000
0`3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oood000000103oool00`000000
oooo0?ooo`3`0?ooo`00203oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo
@00000030?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00d000000oooo
0?ooo`020?ooo`03000004000000oooo0?00oooo000=0?ooo`03@000003ooom0000000L0oooo00=0
00000?oood0000000`3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`900000
1@3oool00`000000oooo0?ooo`3`0?ooo`003@3oool00d000000oooo@00000070?ooo`03@000003o
oom0000000<0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?ooo`3o
ool0103oool00`000000oooo0?ooo`130?ooo`@0?cooZ@3oool000h0oooo00=000000?ooo`3oool0
1`3oool014000000oooo0?ooo`3oool2@00000@0oooo00A000000?ooo`3oool0oooo0d0000040?oo
o`030000003oool0oooo0480oooo1P0o?onX0?ooo`00;@3oool00`000000oooo0?ooo`120?ooo`L0
?cooY`3oool002d0oooo00<000000?ooo`3oool0@`3oool00`0o?ol0oooo0?ooo`0303loojL0oooo
000]0?ooo`030000003oool0oooo0440oooo0`0o?ol30?ooo`<0?cooYP3oool002d0oooo00<00000
0?ooo`3oool0@@3oool303loo`<0oooo0`0o?onV0?ooo`00;@3oool00`000000oooo0?ooo`120?oo
o`0303loo`3oool0oooo00<0oooo00<0?coo0?ooo`3oool0Y@3oool002d0oooo00<000000?ooo`3o
ool0@03oool303loojd0oooo000]0?ooo`030000003oool0oooo0400oooo0`0o?ol50?ooo`<0?coo
Y@3oool002d0oooo00<000000?ooo`3oool0@@3oool00`0o?ol0oooo0?ooo`040?ooo`<0?cooY@3o
ool002d0oooo00<000000?ooo`3oool0?`3oool303loo`L0oooo00<0?coo0?ooo`3oool0Y03oool0
02d0oooo00<000000?ooo`3oool0?`3oool303loojh0oooo000]0?ooo`030000003oool0oooo0400
oooo00<0?coo0?ooo`3oool01P3oool303looj@0oooo000]0?ooo`030000003oool0oooo04T0oooo
0`0o?onT0?ooo`00;@3oool00`000000oooo0?ooo`1:0?ooo`0303loo`3oool0oooo0:<0oooo000]
0?ooo`030000003oool0oooo03h0oooo0`0o?on_0?ooo`00;@3oool00`000000oooo0?ooo`0n0?oo
o`<0?coo2P3oool303looj80oooo000H0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`05@00000<0oooo00<000000?ooo`3oool0?`3oool00`0o?ol0
oooo0?ooo`090?ooo`<0?cooXP3oool001L0oooo00=000000?oood0000001`3oool00d000000oooo
@00000030?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool0C03oool00`0o?ol0oooo
0?ooo`2Q0?ooo`004P3oool3@0000080oooo00=000000?oood0000001`3oool00d000000oooo@000
00030?ooo`03@000003oool0oooo00<0oooo00<00000@000003oool0l03oool001L0oooo00=00000
0?oood0000001`3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00<00000
0?ooo`3oool0?@3oool303look00oooo000G0?ooo`03@000003ooom0000000L0oooo00=000000?oo
od0000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo03d0oooo0`0o?on`0?oo
o`00603oool00d000000oooo0?ooo`070?ooo`04@000003oool0oooo0?ooo`9000001@3oool00`00
0000oooo0?ooo`0n0?ooo`0303loo`3oool0oooo00/0oooo0`0o?onQ0?ooo`00;@3oool00`000000
oooo0?ooo`1<0?ooo`<0?cooX@3oool002d0oooo00<000000?ooo`3oool0C@3oool00`0o?ol0oooo
0?ooo`2P0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`0m
0?ooo`<0?coo/03oool002d0oooo00<000000?ooo`3oool0?@3oool303look00oooo000]0?ooo`03
0000003oool0oooo03h0oooo00<0?coo0?ooo`3oool0303oool303looj00oooo000]0?ooo`030000
003oool0oooo04d0oooo0`0o?onP0?ooo`00;@3oool00`000000oooo0?ooo`1>0?ooo`0303loo`3o
ool0oooo09l0oooo000]0?ooo`030000003oool0oooo0?00oooo000]0?ooo`030000003oool0oooo
0?00oooo000]0?ooo`030000003oool0oooo03`0oooo0`0o?ona0?ooo`00;@3oool00`000000oooo
0?ooo`0l0?ooo`<0?coo3`3oool303looil0oooo000]0?ooo`030000003oool0oooo03d0oooo00<0
?coo0?ooo`3oool03P3oool303looil0oooo000]0?ooo`030000003oool0oooo04l0oooo00<0?coo
0?ooo`3oool0WP3oool002d0oooo00<000000?ooo`3oool0l03oool000h0oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3o
ool0l03oool000d0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000
003ooom0000000<0oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo00<000000?oo
o`3oool0l03oool000P0oooo0d0000020?ooo`03@000003ooom0000000L0oooo00=000000?oood00
00000P3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3o
ool00P3oool00`00001000000?ooo`0k0?ooo`<0?coo/P3oool000d0oooo00=000000?oood000000
1`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool0
0T0000050?ooo`030000003oool0oooo03/0oooo0`0o?olA0?ooo`<0?cooWP3oool000d0oooo00=0
00000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=0
00000?oood0000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo03`0oooo00<0
?coo0?ooo`3oool0403oool303looih0oooo000>0?ooo`03@000003oool0oooo00L0oooo00=00000
0?ooo`3oool00P3oool014000000oooo0?ooo`3oool3@0000080oooo0d0000040?ooo`030000003o
ool0oooo0500oooo00<0?coo0?ooo`3oool0W@3oool002d0oooo00<000000?ooo`3oool0l03oool0
02d0oooo00<000000?ooo`3oool0l03oool002d0oooo00<000000?ooo`3oool0l03oool002d0oooo
00<000000?ooo`3oool0>P3oool303look<0oooo000]0?ooo`030000003oool0oooo03X0oooo0`0o
?olC0?ooo`<0?cooW@3oool002d0oooo00<000000?ooo`3oool0>`3oool00`0o?ol0oooo0?ooo`0B
0?ooo`<0?cooW@3oool002d0oooo00<000000?ooo`3oool0D@3oool00`0o?ol0oooo0?ooo`2L0?oo
o`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3o
ool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`0i0?ooo`<0?coo]03oool0
02d0oooo00<000000?ooo`3oool0>@3oool303looaD0oooo0`0o?onL0?ooo`00;@3oool00`000000
oooo0?ooo`0j0?ooo`0303loo`3oool0oooo01@0oooo0`0o?onL0?ooo`00;@3oool00`000000oooo
0?ooo`1B0?ooo`0303loo`3oool0oooo09/0oooo000]0?ooo`030000003oool0oooo0?00oooo000C
0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`02
0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`3`
0?ooo`004P3oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oo
od0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo0?00oooo000=0?ooo`=0
00000P3oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood00
0000103oool00d000000oooo0?ooo`020?ooo`03000004000000oooo0?00oooo000B0?ooo`03@000
003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`900000
1@3oool00`000000oooo0?ooo`0h0?ooo`<0?coo5`3oool303looi/0oooo000B0?ooo`03@000003o
oom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003o
ool0oooo00@0oooo00<000000?ooo`3oool0>03oool303looaL0oooo0`0o?onK0?ooo`004`3oool0
0d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00A000000?ooo`3oool0oooo0d00
00040?ooo`030000003oool0oooo03T0oooo00<0?coo0?ooo`3oool05`3oool00`0o?ol0oooo0?oo
o`2J0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?oo
o`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3o
ool00`000000oooo0?ooo`0g0?ooo`<0?coo6@3oool303looiX0oooo000]0?ooo`030000003oool0
oooo03L0oooo0`0o?olI0?ooo`<0?cooVP3oool002d0oooo00<000000?ooo`3oool0>03oool00`0o
?ol0oooo0?ooo`0I0?ooo`0303loo`3oool0oooo09T0oooo000]0?ooo`030000003oool0oooo0?00
oooo000]0?ooo`030000003oool0oooo0?00oooo000]0?ooo`030000003oool0oooo0?00oooo000]
0?ooo`030000003oool0oooo0?00oooo000]0?ooo`030000003oool0oooo05D0oooo0`0o?onH0?oo
o`00;@3oool00`000000oooo0?ooo`0f0?ooo`<0?coo703oool303looiP0oooo000]0?ooo`030000
003oool0oooo03H0oooo0`0o?olM0?ooo`0303loo`3oool0oooo09L0oooo000>0?ooo`03@000003o
ool0oooo0080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`04@000003o
ool0oooo0?ooo`=000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo03L0oooo
00<0?coo0?ooo`3oool0]P3oool000d0oooo00=000000?oood0000001`3oool00d000000oooo@000
00020?ooo`03@000003ooom000000080oooo00=000000?ooo`3oool00P3oool00d000000oooo@000
00040?ooo`030000003oool0oooo0?00oooo00080?ooo`=000000P3oool00d000000oooo@0000007
0?ooo`03@000003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`03
0?ooo`03@000003oool0oooo0080oooo00<00000@000003oool0l03oool000d0oooo00=000000?oo
od0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00A000000?oo
o`3oool0oooo0T0000050?ooo`030000003oool0oooo0?00oooo000=0?ooo`03@000003ooom00000
00L0oooo00=000000?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom00000
0080oooo00=000000?ooo`3oool0103oool00`000000oooo0?ooo`1F0?ooo`<0?cooU`3oool000h0
oooo00=000000?ooo`3oool01`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080
oooo00A000000?ooo`3oool0oooo0d0000040?ooo`030000003oool0oooo03D0oooo0`0o?olN0?oo
o`<0?cooU`3oool002d0oooo00<000000?ooo`3oool0=@3oool303looal0oooo00<0?coo0?ooo`3o
ool0UP3oool002d0oooo00<000000?ooo`3oool0=P3oool00`0o?ol0oooo0?ooo`2g0?ooo`00;@3o
ool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`3`0?ooo`00;@3oool00`00
0000oooo0?ooo`3`0?ooo`00;@3oool00`000000oooo0?ooo`1G0?ooo`<0?cooUP3oool002d0oooo
00<000000?ooo`3oool07P3oool3@0000080oooo00=000000?ooo`3oool06`3oool2@00000@0oooo
00=000000?ooo`3oool03@3oool303loo`d0oooo00=000000?ooo`3oool00P3oool00d000000oooo
0?ooo`0G0?ooo`E000000P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01H0oooo
1D000000103ooom00000@000040000030?ooo`03@000003oool0oooo01D0oooo1D0000020?ooo`=0
00000P3oool00d000000oooo0?ooo`0B0?ooo`00;@3oool00`000000oooo0?ooo`0O0?ooo`06@000
003oool0oooo@000003ooom000003`3oool303loo`X0oooo00=000000?oood0000000P3oool00d00
0000oooo@000000?0?ooo`0303loo`3oool0oooo00/0oooo00=000000?oood0000000P3oool00d00
0000oooo@000000J0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003o
oom0000001T0oooo00E000000?ooo`3oool0oooo@00000040?ooo`03@000003ooom0000001P0oooo
00=000000?ooo`3oool00`3oool01T000000oooo0?oood000000oooo@00001<0oooo000]0?ooo`03
0000003oool0oooo01d0oooo14000000103ooom000000?oood00000?0?ooo`<0?coo2P3oool00d00
0000oooo@00000020?ooo`03@000003ooom0000001d0oooo00=000000?oood0000000P3oool00d00
0000oooo@000000J0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003o
oom0000001T0oooo00=000000?ooo`3oool00P3oool01d000000oooo0?ooo`3ooom000000?oood00
0000603oool014000000oooo0?ooo`3oool4@00000040?oood000000oooo@00001<0oooo000]0?oo
o`030000003oool0oooo01d0oooo00=000000?oood0000000P3oool00d000000oooo@000000@0?oo
o`0303loo`3oool0oooo00T0oooo0T0000030?ooo`03@000003ooom0000001h0oooo00M000000?oo
o`3oool0oooo@000003ooom0000001X0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood0000006@3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oo
od000000oooo@000000H0?ooo`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000
003ooom0000001<0oooo000]0?ooo`030000003oool0oooo01h0oooo0T0000020?ooo`03@000003o
oom0000001`0oooo00=000000?ooo`3oool00P3oool00d000000oooo@000000M0?ooo`03@000003o
oom000000080oooo00=000000?oood0000006P3oool01d000000oooo0?ooo`3ooom000000?oood00
00000P3oool00d000000oooo@000000I0?ooo`07@000003oool0oooo0?oood000000oooo@0000002
0?ooo`03@000003ooom0000001P0oooo00=000000?ooo`3oool00P3oool2@0000080oooo00=00000
0?oood0000004`3oool002d0oooo00<000000?ooo`3oool07`3oool01D000000oooo0?ooo`3ooom0
000001h0oooo0T0000030?ooo`03@000003oool0oooo00h0oooo0`0o?ol<0?ooo`03@000003oool0
oooo0080oooo00=000000?ooo`3oool0603oool2@00000@0oooo00=000000?ooo`3oool00P3oool0
0d000000oooo0?ooo`0G0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0
oooo01H0oooo0T0000050?ooo`05@000003oool0oooo0?oood000000503oool002d0oooo00<00000
0?ooo`3oool0F03oool303looiD0oooo000]0?ooo`030000003oool0oooo03@0oooo0`0o?olR0?oo
o`0303loo`3oool0oooo09@0oooo000]0?ooo`030000003oool0oooo03@0oooo0`0o?oni0?ooo`00
;@3oool00`000000oooo0?ooo`0e0?ooo`0303loo`3oool0oooo0;P0oooo000]0?ooo`030000003o
ool0oooo0?00oooo000]0?ooo`D000004P0o?om5000000<0?cooN000000F03loo`D000000D000000
02d0oooo00<000000?ooo`3oool00P3ooolE03loo`030?oood000000oooo00L0oooo00<000000?oo
o`3oool01P3oool00d000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?oo
o`0o?ol00P0o?ol40?ooo`03@000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00d00
0000oooo0?ooo`060?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`03@000003oool0oooo00H0ooooBP0o?ol60?ooo`00;@3oool00`000000
oooo0?ooo`030?oooaD0?coo2@3oool00d000000oooo0?ooo`0Q0?ooo`03@000003oool0oooo0180
oooo00<0?coo0?ooo`3oool03@3oool00d000000oooo0?ooo`0Q0?ooo`03@000003oool0oooo00H0
oooo?@0o?ol01P3oool0?coo0?ooo`0o?ol0oooo03loo`80oooo00<0?coo0?ooo`0o?ol00P3oool0
1@0o?ol0oooo03loo`3oool0?coo0080oooo00<0?coo0?ooo`3oool01@3oool002d0oooo00<00000
0?ooo`3oool04P3oool703looaX0oooo0`0o?omL0?oooa00?coo01d0oooo03loo`0o?ol0oooo03lo
o`3oool0?coo0?ooo`0o?ol0oooo03loo`3oool0?coo0?ooo`0o?ol0oooo03loo`3oool0?coo0?oo
o`0o?ol0oooo03loo`3oool0?coo0?ooo`0o?ol0oooo03loo`020?ooo`0903loo`3oool0?coo0?oo
o`0o?ol0oooo03loo`3oool0?coo0080oooo00L0?coo0?ooo`0o?ol0oooo03loo`3oool0?coo01d0
oooo000]0?ooo`030000003oool0oooo01D0oooo1P0o?olH0?ooo`<0?cooF03oool;03loo`070?oo
o`0o?ol0?coo0?ooo`0o?ol0oooo03loo`1@0?ooo`00;@3oool00`000000oooo0?ooo`0G0?ooo`@0
?coo6@3oool00`0o?ol0oooo0?ooo`0S0?ooo`<0?coo;P3oool:03loo`030?ooo`0o?ol0oooo05P0
oooo000]0?ooo`030000003oool0oooo01P0oooo100o?oln0?ooo`<0?coo;03oool703loo`030?oo
o`0o?ol0oooo05d0oooo000]0?ooo`030000003oool0oooo01T0oooo0`0o?olo0?ooo`0303loo`3o
ool0oooo02X0oooo1P0o?omR0?ooo`00;@3oool00`000000oooo0?ooo`0I0?ooo`@0?cooJ@3oool5
03loofD0oooo000]0?ooo`030000003oool0oooo01X0oooo100o?olD0?ooo`<0?cooC`3oool603lo
ofH0oooo000]0?ooo`030000003oool0oooo01/0oooo0`0o?olD0?ooo`<0?coo9`3oool303loob@0
oooo1@0o?omX0?ooo`00;@3oool00`000000oooo0?ooo`0K0?ooo`@0?coo503oool00`0o?ol0oooo
0?ooo`0V0?ooo`<0?coo8P3oool503loofX0oooo000]0?ooo`030000003oool0oooo01`0oooo0`0o
?oln0?ooo`0303loo`3oool0oooo0200oooo1@0o?om[0?ooo`00;@3oool00`000000oooo0?ooo`0M
0?ooo`<0?cooGP3oool503loofd0oooo000]0?ooo`030000003oool0oooo01d0oooo0`0o?olA0?oo
o`<0?coo:@3oool303looah0oooo100o?om^0?ooo`00;@3oool00`000000oooo0?ooo`0M0?ooo`<0
?coo4@3oool303loobT0oooo0`0o?olL0?ooo`@0?cooL03oool002d0oooo00<000000?ooo`3oool0
7P3oool303looa40oooo00<0?coo0?ooo`3oool0:@3oool00`0o?ol0oooo0?ooo`0J0?ooo`@0?coo
L@3oool002d0oooo00<000000?ooo`3oool07P3oool303looeP0oooo1@0o?omb0?ooo`00;@3oool0
0`000000oooo0?ooo`0N0?ooo`<0?coo?@3oool303looaP0oooo100o?omc0?ooo`003P3oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool01400
0000oooo0?ooo`3oool3@00000<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`0O
0?ooo`<0?coo3P3oool303loob/0oooo0`0o?olG0?ooo`<0?cooM@3oool000d0oooo00=000000?oo
od0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oo
o`3oool00P3oool00d000000oooo@00000040?ooo`030000003oool0oooo01l0oooo0`0o?ol>0?oo
o`<0?coo;03oool00`0o?ol0oooo0?ooo`0E0?ooo`@0?cooM@3oool000d0oooo00=000000?oood00
00001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3o
ool00`3oool00d000000oooo0?ooo`020?ooo`03000004000000oooo0200oooo0`0o?ol>0?ooo`03
03loo`3oool0oooo04<0oooo0`0o?omf0?ooo`003@3oool00d000000oooo@00000070?ooo`03@000
003ooom000000080oooo00=000000?oood0000000`3oool014000000oooo0?ooo`3oool2@00000D0
oooo00<000000?ooo`3oool0803oool303looc`0oooo0`0o?olC0?ooo`@0?cooM`3oool000d0oooo
00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo
00=000000?oood0000000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo0200oooo
0`0o?oll0?ooo`<0?coo4P3oool403loogP0oooo000>0?ooo`03@000003oool0oooo00L0oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000
103oool00`000000oooo0?ooo`0P0?ooo`@0?coo2`3oool303loobh0oooo100o?ol@0?ooo`<0?coo
N@3oool002d0oooo00<000000?ooo`3oool08@3oool303loo`/0oooo0`0o?ol_0?ooo`<0?coo3P3o
ool403loogX0oooo000]0?ooo`030000003oool0oooo0280oooo0`0o?ol;0?ooo`0303loo`3oool0
oooo02l0oooo00<0?coo0?ooo`3oool0303oool403loog/0oooo000]0?ooo`030000003oool0oooo
0280oooo0`0o?olm0?ooo`<0?coo303oool303loog`0oooo000]0?ooo`030000003oool0oooo02<0
oooo0`0o?ol90?ooo`<0?coo<03oool403loo`T0oooo100o?omm0?ooo`00;@3oool00`000000oooo
0?ooo`0S0?ooo`<0?coo2@3oool303looc40oooo0`0o?ol80?ooo`@0?cooOP3oool002d0oooo00<0
00000?ooo`3oool08`3oool303loo`X0oooo00<0?coo0?ooo`3oool0<@3oool403loo`<0oooo1P0o
?omo0?ooo`00;@3oool00`000000oooo0?ooo`0S0?ooo`<0?coo203oool303looc@0oooo2`0o?on0
0?ooo`00;@3oool00`000000oooo0?ooo`0T0?ooo`<0?coo1`3oool303loocD0oooo1`0o?ol00`3o
ool0?coo0?ooo`200?ooo`00;@3oool00`000000oooo0?ooo`0T0?ooo`<0?coo203oool00`0o?ol0
oooo0?ooo`0e0?ooo`<0?coo00<0oooo03loo`3oool0P`3oool002d0oooo00<000000?ooo`3oool0
9@3oool303loo`D0oooo0`0o?oo00?ooo`00;@3oool00`000000oooo0?ooo`0U0?ooo`<0?coo1@3o
ool303lool00oooo000]0?ooo`030000003oool0oooo02D0oooo0`0o?ol40?ooo`<0?coo`@3oool0
02d0oooo00<000000?ooo`3oool09P3oool303loo`<0oooo0`0o?oo10?ooo`00;@3oool00`000000
oooo0?ooo`0V0?ooo`@0?coo00@0oooo03loo`0o?ol0?coo`P3oool002d0oooo00<000000?ooo`3o
ool09`3oool703lool80oooo000C0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0
0P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0X0?ooo`H0?coo`P3oool00180oooo00=000000?oood0000001`3o
ool00d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000103o
ool00`000000oooo0?ooo`0Y0?ooo`@0?coo``3oool00180oooo00=000000?oood0000001`3oool0
0d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00=000000?ooo`3oool00P3oool0
0`00001000000?ooo`3`0?ooo`004P3oool00d000000oooo@00000070?ooo`03@000003ooom00000
0080oooo00=000000?oood0000000P3oool2@00000D0oooo00=000000?ooo`3oool0l03oool00180
oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom000000080
oooo00=000000?ooo`3oool0m`3oool001<0oooo00=000000?ooo`3oool01`3oool00d000000oooo
0?ooo`020?ooo`04@000003oool0oooo0?ooo`=00000m`3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.76318, -0.0144222, 
  0.550222, 0.000120633}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{485, 335},
WindowMargins->{{37, Automatic}, {Automatic, 16}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 101, 3, 48, "Input"],
Cell[1813, 54, 62, 0, 33, "Text"],
Cell[1878, 56, 1387, 55, 1020, "Input"],
Cell[3268, 113, 44, 0, 33, "Text"],
Cell[3315, 115, 114, 11, 192, "Input"],
Cell[3432, 128, 47, 0, 33, "Text"],
Cell[3482, 130, 73, 0, 30, "Input"],
Cell[3558, 132, 64, 0, 30, "Input"],
Cell[3625, 134, 50, 0, 33, "Text"],
Cell[3678, 136, 133, 3, 66, "Input"],
Cell[3814, 141, 34, 0, 33, "Text"],
Cell[3851, 143, 57, 0, 30, "Input"],
Cell[3911, 145, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3960, 149, 432, 11, 210, "Input"],
Cell[4395, 162, 32353, 807, 263, 8595, 509, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[36763, 972, 183, 3, 52, "Text"],
Cell[36949, 977, 127, 3, 48, "Input"],
Cell[37079, 982, 42, 0, 33, "Text"],
Cell[37124, 984, 131, 3, 48, "Input"],
Cell[37258, 989, 64, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[37347, 993, 178, 5, 84, "Input"],
Cell[37528, 1000, 25674, 697, 186, 7762, 471, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

