(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     60544,       1708]*)
(*NotebookOutlinePosition[     61240,       1733]*)
(*  CellTagsIndexPosition[     61196,       1729]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<c:\\math\\kniz\\options\\optvalue.m", "Input"],

Cell["\<\
\"Sold Strangle : predaj
 call opcie za vysoku realizacnu cenu
 put opcie za nizku realizacnu cenu\"\
\>", "Text"],

Cell["\<\
SoldStrangleImpl[X1_,X2_,sigma_,r_,D_,t_,m_,n_,trans_,time_]:=
Module[
{doldiag,diag,hordiag},

X=(X1+X2)/2;
xright=Log[Slarge/X];
xleft=-xright;

k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k2^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfSoldStranglePayoff[x_]:=N[Exp[0.5*(k2-1)*x]*(-Max[Exp[x]-X1/X,0]-Max[-\
Exp[x]+X2/X,0])];
Do[u[i,0]=TransfSoldStranglePayoff[i*h],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
ClenAbs[i]=Abs[N[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

op1=Exp[0.5*(k2+1)*xleft+0.25*(k2+1)^2*k*j]-
    Exp[0.5*(k2-1)*xleft+0.25*(k2-1)^2*k*j]*X2/X;
op2=Exp[0.5*(k2-1)*xright+0.25*(k2-1)^2*k*j]*X1/X-
    Exp[0.5*(k2+1)*xright+0.25*(k2+1)^2*k*j];

ps = Join[{u[-m+1,j-1]-k3*k*ClenAbs[-m+1]-a*op1},
          Table[u[i,j-1]-k3*k*ClenAbs[i],{i,-m+2,m-2}],
          {u[m-1,j-1]-k3*k*ClenAbs[m-1]-c*op2}];

hordiag=Table[c,{i,-m+1,m-2}];
diag=Table[b,{i,-m+1,m-1}];
doldiag=Table[a,{i,-m+2,m-1}];

riesenie=TridiagonalSolve[N[doldiag],N[diag],N[hordiag],N[ps]];
 
u[-m,j]=op1;
Do[u[i,j]=riesenie[[i+m]],{i,-m+1,m-1}];
u[m,j] =op2;

xs=Table[X*Exp[i*h],{i,-m,m}];
ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-m,m}];
graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
{j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X1=65;
X2=50;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.3;
m=100;
n=100;
Slarge=150;
trans=0.02;
time=0.03;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["SoldStrangleImpl[X1,X2,sigma,r,DD,t,m,n,trans,time]", "Input"],

Cell["\"Explicitn\[EAcute] rie\.9aenie\"", "Text"],

Cell["\<\
SoldStrangle[S_,X1_,X2_,sigma_,r_,DD_,t_]:=
N[-EuropeanCallDiv[S,X1,sigma,r,DD,t]-EuropeanPutDiv[S,X2,sigma,r,DD,t]]\
\>", "Input"],

Cell["\"Payoff diagram\"", "Text"],

Cell["Payoff[S_,X1_,X2_]:=N[-Max[S-X1,0]-Max[X2-S,0]]", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=Plot[SoldStrangle[S,X1,X2,sigma,r,DD,t],{S,0,150},PlotRange->All,PlotStyle->\
RGBColor[0,1,0], DisplayFunction->Identity];
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[Payoff[S,X1,X2],{S,0,150},PlotStyle -> 
{Thickness[0.006]},PlotRange->All, DisplayFunction->Identity];

Show[g2,g1,g,AxesLabel -> \
{\"S\",\"V\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{-60,1}}]\

\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0.607902 0.0101317 [
[.2 .5954 -6 -9 ]
[.2 .5954 6 0 ]
[.4 .5954 -6 -9 ]
[.4 .5954 6 0 ]
[.6 .5954 -6 -9 ]
[.6 .5954 6 0 ]
[.8 .5954 -9 -9 ]
[.8 .5954 9 0 ]
[1 .5954 -9 -9 ]
[1 .5954 9 0 ]
[1.025 .6079 0 -7.5 ]
[1.025 .6079 10 7.5 ]
[-0.0125 0 -18 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .10132 -18 -4.5 ]
[-0.0125 .10132 0 4.5 ]
[-0.0125 .20263 -18 -4.5 ]
[-0.0125 .20263 0 4.5 ]
[-0.0125 .30395 -18 -4.5 ]
[-0.0125 .30395 0 4.5 ]
[-0.0125 .40527 -18 -4.5 ]
[-0.0125 .40527 0 4.5 ]
[-0.0125 .50659 -18 -4.5 ]
[-0.0125 .50659 0 4.5 ]
[0 .64303 -5.5 0 ]
[0 .64303 5.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 .6079 m
.2 .61415 L
s
[(40)] .2 .5954 0 1 Mshowa
.4 .6079 m
.4 .61415 L
s
[(60)] .4 .5954 0 1 Mshowa
.6 .6079 m
.6 .61415 L
s
[(80)] .6 .5954 0 1 Mshowa
.8 .6079 m
.8 .61415 L
s
[(100)] .8 .5954 0 1 Mshowa
1 .6079 m
1 .61415 L
s
[(120)] 1 .5954 0 1 Mshowa
.125 Mabswid
.05 .6079 m
.05 .61165 L
s
.1 .6079 m
.1 .61165 L
s
.15 .6079 m
.15 .61165 L
s
.25 .6079 m
.25 .61165 L
s
.3 .6079 m
.3 .61165 L
s
.35 .6079 m
.35 .61165 L
s
.45 .6079 m
.45 .61165 L
s
.5 .6079 m
.5 .61165 L
s
.55 .6079 m
.55 .61165 L
s
.65 .6079 m
.65 .61165 L
s
.7 .6079 m
.7 .61165 L
s
.75 .6079 m
.75 .61165 L
s
.85 .6079 m
.85 .61165 L
s
.9 .6079 m
.9 .61165 L
s
.95 .6079 m
.95 .61165 L
s
.25 Mabswid
0 .6079 m
1 .6079 L
s
gsave
1.025 .6079 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
.00625 0 L
s
[(-60)] -0.0125 0 1 0 Mshowa
0 .10132 m
.00625 .10132 L
s
[(-50)] -0.0125 .10132 1 0 Mshowa
0 .20263 m
.00625 .20263 L
s
[(-40)] -0.0125 .20263 1 0 Mshowa
0 .30395 m
.00625 .30395 L
s
[(-30)] -0.0125 .30395 1 0 Mshowa
0 .40527 m
.00625 .40527 L
s
[(-20)] -0.0125 .40527 1 0 Mshowa
0 .50659 m
.00625 .50659 L
s
[(-10)] -0.0125 .50659 1 0 Mshowa
.125 Mabswid
0 .02026 m
.00375 .02026 L
s
0 .04053 m
.00375 .04053 L
s
0 .06079 m
.00375 .06079 L
s
0 .08105 m
.00375 .08105 L
s
0 .12158 m
.00375 .12158 L
s
0 .14184 m
.00375 .14184 L
s
0 .16211 m
.00375 .16211 L
s
0 .18237 m
.00375 .18237 L
s
0 .2229 m
.00375 .2229 L
s
0 .24316 m
.00375 .24316 L
s
0 .26342 m
.00375 .26342 L
s
0 .28369 m
.00375 .28369 L
s
0 .32421 m
.00375 .32421 L
s
0 .34448 m
.00375 .34448 L
s
0 .36474 m
.00375 .36474 L
s
0 .385 m
.00375 .385 L
s
0 .42553 m
.00375 .42553 L
s
0 .4458 m
.00375 .4458 L
s
0 .46606 m
.00375 .46606 L
s
0 .48632 m
.00375 .48632 L
s
0 .52685 m
.00375 .52685 L
s
0 .54711 m
.00375 .54711 L
s
0 .56738 m
.00375 .56738 L
s
0 .58764 m
.00375 .58764 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(V) show
69.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.006 w
0 .30395 m
.04948 .35408 L
.11328 .41872 L
.17469 .48094 L
.23997 .54708 L
.27267 .58021 L
.28704 .59477 L
.29466 .60249 L
.29685 .60471 L
.29794 .60581 L
.29894 .60683 L
.30081 .6079 L
.30286 .6079 L
.31802 .6079 L
.33223 .6079 L
.36336 .6079 L
.39297 .6079 L
.42499 .6079 L
.43353 .6079 L
.4382 .6079 L
.44255 .6079 L
.44627 .6079 L
.44734 .6079 L
.44836 .6079 L
.45026 .60764 L
.45128 .60661 L
.45236 .60551 L
.45431 .60354 L
.45871 .59907 L
.49048 .56689 L
.54994 .50665 L
.61326 .44249 L
.67419 .38076 L
.73899 .31511 L
.8014 .25188 L
.86142 .19107 L
.9253 .12634 L
.9868 .06404 L
s
.9868 .06404 m
1 .05066 L
s
.25 .25 1 r
.015 w
.02042 .33068 Mdot
.02254 .33283 Mdot
.02468 .335 Mdot
.02685 .3372 Mdot
.02903 .33941 Mdot
.03124 .34165 Mdot
.03347 .3439 Mdot
.03572 .34618 Mdot
.03799 .34848 Mdot
.04028 .3508 Mdot
.0426 .35315 Mdot
.04494 .35552 Mdot
.04729 .35791 Mdot
.04968 .36032 Mdot
.05208 .36275 Mdot
.05451 .36521 Mdot
.05696 .36769 Mdot
.05944 .3702 Mdot
.06194 .37273 Mdot
.06446 .37528 Mdot
.06701 .37786 Mdot
.06958 .38046 Mdot
.07218 .38309 Mdot
.0748 .38574 Mdot
.07745 .38841 Mdot
.08012 .39111 Mdot
.08282 .39384 Mdot
.08555 .39658 Mdot
.0883 .39936 Mdot
.09108 .40215 Mdot
.09388 .40498 Mdot
.09671 .40782 Mdot
.09957 .41069 Mdot
.10246 .41359 Mdot
.10537 .41651 Mdot
.10831 .41945 Mdot
.11128 .42242 Mdot
.11428 .42541 Mdot
.11731 .42842 Mdot
.12037 .43145 Mdot
.12345 .43451 Mdot
.12657 .43758 Mdot
.12972 .44068 Mdot
.13289 .44379 Mdot
.1361 .44693 Mdot
.13934 .45008 Mdot
.14261 .45325 Mdot
.14591 .45643 Mdot
.14924 .45963 Mdot
.15261 .46283 Mdot
.15601 .46605 Mdot
.15944 .46928 Mdot
.1629 .47251 Mdot
.16639 .47575 Mdot
.16992 .479 Mdot
.17349 .48224 Mdot
.17709 .48548 Mdot
.18072 .48872 Mdot
.18439 .49195 Mdot
.18809 .49517 Mdot
.19183 .49838 Mdot
.19561 .50157 Mdot
.19942 .50474 Mdot
.20327 .50789 Mdot
.20715 .51102 Mdot
.21107 .51412 Mdot
.21503 .51718 Mdot
.21903 .5202 Mdot
.22307 .52319 Mdot
.22715 .52613 Mdot
.23126 .52901 Mdot
.23542 .53185 Mdot
.23961 .53463 Mdot
.24385 .53734 Mdot
.24812 .53999 Mdot
.25244 .54257 Mdot
.2568 .54507 Mdot
.2612 .54749 Mdot
.26564 .54982 Mdot
.27013 .55207 Mdot
.27466 .55421 Mdot
.27923 .55626 Mdot
.28385 .55821 Mdot
.28851 .56005 Mdot
.29322 .56177 Mdot
.29797 .56338 Mdot
.30277 .56486 Mdot
.30761 .56622 Mdot
.3125 .56744 Mdot
.31744 .56853 Mdot
.32243 .56948 Mdot
.32746 .57029 Mdot
.33254 .57095 Mdot
.33767 .57146 Mdot
.34285 .57181 Mdot
.34808 .572 Mdot
.35336 .57204 Mdot
.3587 .57191 Mdot
.36408 .57161 Mdot
.36951 .57114 Mdot
.375 .5705 Mdot
.38054 .56968 Mdot
.38613 .56868 Mdot
.39178 .5675 Mdot
.39748 .56614 Mdot
.40324 .5646 Mdot
.40905 .56287 Mdot
.41492 .56096 Mdot
.42084 .55886 Mdot
.42682 .55657 Mdot
.43286 .55409 Mdot
.43896 .55143 Mdot
.44512 .54857 Mdot
.45133 .54553 Mdot
.45761 .5423 Mdot
.46394 .53888 Mdot
.47034 .53527 Mdot
.4768 .53147 Mdot
.48332 .52749 Mdot
.4899 .52333 Mdot
.49655 .51899 Mdot
.50326 .51446 Mdot
.51004 .50976 Mdot
.51688 .50488 Mdot
.52378 .49982 Mdot
.53076 .49459 Mdot
.5378 .4892 Mdot
.54491 .48363 Mdot
.55208 .4779 Mdot
.55933 .47201 Mdot
.56665 .46596 Mdot
.57403 .45975 Mdot
.58149 .45339 Mdot
.58902 .44687 Mdot
.59662 .44021 Mdot
.6043 .4334 Mdot
.61205 .42645 Mdot
.61987 .41936 Mdot
.62777 .41213 Mdot
.63574 .40476 Mdot
.6438 .39726 Mdot
.65193 .38963 Mdot
.66013 .38188 Mdot
.66842 .37399 Mdot
.67679 .36599 Mdot
.68523 .35786 Mdot
.69376 .34961 Mdot
.70237 .34124 Mdot
.71107 .33276 Mdot
.71985 .32416 Mdot
.72871 .31545 Mdot
.73766 .30663 Mdot
.74669 .29769 Mdot
.75581 .28865 Mdot
.76502 .2795 Mdot
.77432 .27024 Mdot
.78371 .26087 Mdot
.79318 .25139 Mdot
.80275 .24181 Mdot
.81241 .23213 Mdot
.82217 .22234 Mdot
.83202 .21244 Mdot
.84196 .20243 Mdot
.852 .19233 Mdot
.86213 .18211 Mdot
.87237 .17179 Mdot
.8827 .16137 Mdot
.89313 .15084 Mdot
.90366 .1402 Mdot
.91429 .12946 Mdot
.92503 .1186 Mdot
.93587 .10764 Mdot
.94681 .09657 Mdot
.95786 .0854 Mdot
.96902 .07411 Mdot
.98028 .06271 Mdot
.99165 .0512 Mdot
0 1 0 r
.5 Mabswid
0 .30999 m
.04948 .36012 L
.11328 .42473 L
.17469 .48584 L
.20599 .51491 L
.23997 .54271 L
.25584 .5538 L
.27267 .56398 L
.28843 .57193 L
.30286 .57777 L
.31768 .58232 L
.32586 .58419 L
.33363 .58556 L
.33709 .58604 L
.34077 .58646 L
.34425 .58677 L
.34741 .58699 L
.34934 .58709 L
.35113 .58716 L
.35308 .58721 L
.35515 .58724 L
.35695 .58724 L
.35863 .58722 L
.36047 .58718 L
.36245 .58712 L
.36437 .58703 L
.36648 .5869 L
.37077 .58656 L
.37474 .58614 L
.37847 .58565 L
.38686 .58425 L
.3959 .58226 L
.41243 .57739 L
.42759 .57159 L
.4574 .55679 L
.49 .53612 L
.55388 .48552 L
.61538 .42908 L
.68074 .36521 L
.74371 .30215 L
.8043 .24099 L
.86874 .17577 L
.9308 .11291 L
.99047 .05245 L
s
.99047 .05245 m
1 .0428 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{333.313, 205.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005=0000cB000`400?l00000o`00003oo`3ooom>
0?ooo`00o`3ooom>0?ooo`002`3oool2@00000@0oooo00=000000?ooo`3oool0o`3ooolj0?ooo`00
2`3oool00d000000oooo@00000020?ooo`03@000003ooom000000?l0oooo>`3oool000H0oooo0d00
00020?ooo`03@000003ooom000000080oooo00=000000?oood0000001@3oool00`00001000000?oo
o`3o0?oooc<0oooo000;0?ooo`9000000`3oool00d000000oooo@00000050?ooo`030000003oool0
oooo0?l0oooo<`3oool000/0oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000050?oo
o`030000003oool0oooo0?l0oooo<`3oool000`0oooo0T0000030?ooo`03@000003oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooolc0?ooo`00603oool00`000000oooo0?ooo`3o0?oooc<0oooo
000H0?ooo`030000003oool0oooo0?l0oooo<`3oool001P0oooo00<00000@000003oool0o`3ooolc
0?ooo`00603oool00`000000oooo0?ooo`3o0?oooc<0oooo000H0?ooo`030000003oool0oooo0?l0
oooo<`3oool001P0oooo00<000000?ooo`3oool0o`3ooolc0?ooo`00603oool00`000000oooo0?oo
o`3o0?oooc<0oooo000H0?ooo`030000003oool0oooo0?l0oooo<`3oool001P0oooo00<00000@000
003oool0o`3ooolN0?ooo`03003o003oool0oooo0180oooo000H0?ooo`030000003oool0oooo0?l0
oooo7@3oool00`00o`00oooo0?ooo`0C0?ooo`00603oool00`000000oooo0?ooo`3o0?oooaX0oooo
0P0o?ol00`00o`00oooo0?ooo`0D0?ooo`00603oool00`000000oooo0?ooo`3o0?oooaX0oooo00D0
?coo003o000o?ol0oooo@000000D0?ooo`00603oool00`000000oooo0?ooo`3o0?oooaX0oooo00@0
0?l003loo`3oool000005@3oool001P0oooo00<000000?ooo`3oool0o`3ooolI0?ooo`04003o003o
ool0oooo000001H0oooo000H0?ooo`03000004000000oooo0?l0oooo5`3oool01@0o?ol00?l003lo
o`3oool0000001L0oooo000H0?ooo`030000003oool0oooo0?l0oooo5`3oool01000o`00?coo03lo
o`00000H0?ooo`00603oool00`000000oooo0?ooo`3o0?oooaH0oooo00@00?l00?ooo`0o?ol00000
6@3oool001P0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`80?coo00@00?l00?ooo`3oool00000
6P3oool001P0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`0503loo`00o`00?coo0?ooo`000000
6`3oool001P0oooo00<00000@000003oool0o`3ooolC0?ooo`04003o000o?ol0oooo000001`0oooo
000H0?ooo`030000003oool0oooo0?l0oooo403oool203loo`04003o003oool0oooo000001d0oooo
000H0?ooo`030000003oool0oooo0?l0oooo403oool203loo`03003o003oool0000001h0oooo000H
0?ooo`030000003oool0oooo0?l0oooo4@3oool00`00o`00oooo0000000O0?ooo`00303oool00d00
0000oooo0?ooo`020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`03003o003oool000000200oooo000;0?ooo`03@000003ooom000000080oooo00=000000?oood00
00001@3oool00`000000oooo0?ooo`3o0?ooo`d0oooo0P0o?ol00`00o`00oooo0000000Q0?ooo`00
1P3oool3@00000@0oooo00I000000?ooo`3ooom000000?oood0000050?ooo`03000004000000oooo
0?l0oooo3@3oool0100o?ol00?l003loo`00000R0?ooo`002`3oool2@00000<0oooo00=000000?oo
od0000001@3oool00`000000oooo0?ooo`3o0?ooo`d0oooo00<00?l003loo`0000008`3oool000/0
oooo00=000000?ooo`3oool00P3oool00d000000oooo@00000050?ooo`030000003oool0oooo0?l0
oooo2P3oool203loo`03003o003oool0000002@0oooo000;0?ooo`=000000`3oool00d000000oooo
0?ooo`040?ooo`030000003oool0oooo0?l0oooo2P3oool0100o?ol00?l003loo`00000U0?ooo`00
603oool00`000000oooo0?ooo`3o0?ooo`X0oooo00<00?l003loo`0000009P3oool001P0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`80?coo00<00?l00?ooo`0000009`3oool001P0oooo00<00000
@000003oool0o`3oool70?ooo`0403loo`00o`00?coo000002P0oooo000H0?ooo`030000003oool0
oooo0?l0oooo1`3oool00`00o`00?coo0000000Y0?ooo`00603oool00`000000oooo0?ooo`3o0?oo
o`@0oooo0P0o?ol00`00o`00oooo0000000Z0?ooo`00603oool00`000000oooo0?ooo`3o0?ooo`@0
oooo00@0?coo003o000o?ol00000:`3oool001P0oooo00<000000?ooo`3oool0o`3oool40?ooo`03
003o000o?ol0000002`0oooo000H0?ooo`030000003oool0oooo0?l0oooo0@3oool203loo`03003o
003oool0000002d0oooo000H0?ooo`03000004000000oooo0?l0oooo0@3oool0100o?ol00?l003lo
o`00000^0?ooo`00603oool00`000000oooo0?ooo`3o0?ooo`40oooo00<00?l003loo`000000;`3o
ool001P0oooo00<000000?ooo`3oool0o@3oool203loo`03003o003oool000000300oooo000H0?oo
o`030000003oool0oooo0?d0oooo00@0?coo003o000o?ol00000<@3oool001P0oooo00<000000?oo
o`3oool0o@3oool00`00o`00?coo0000000b0?ooo`00603oool00`000000oooo0?ooo`3j0?ooo`80
?coo00<00?l00?ooo`000000<`3oool001P0oooo00<00000@000003oool0nP3oool0100o?ol00?l0
03loo`00000d0?ooo`00603oool00`000000oooo0?ooo`3j0?ooo`03003o000o?ol0000003D0oooo
000H0?ooo`030000003oool0oooo0?L0oooo0P0o?ol00`00o`00oooo0000000f0?ooo`00603oool0
0`000000oooo0?ooo`3g0?ooo`0403loo`00o`00?coo000003L0oooo000H0?ooo`030000003oool0
oooo0?L0oooo00<00?l003loo`000000>03oool001P0oooo00<000000?ooo`3oool0m03oool203lo
o`03003o003oool0000003T0oooo000H0?ooo`03000004000000oooo0?@0oooo00@0?coo003o000o
?ol00000>P3oool001P0oooo00<000000?ooo`3oool0m03oool00`00o`00?coo0000000k0?ooo`00
603oool00`000000oooo0?ooo`3a0?ooo`80?coo00<00?l00?ooo`000000?03oool000`0oooo0d00
00020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0l@3oool0100o?ol00?l003lo
o`00000m0?ooo`003@3oool01T000000oooo0?oood000000oooo@00000D0oooo00<000000?ooo`3o
ool0l@3oool00`00o`00?coo0000000n0?ooo`001P3oool3@0000080oooo14000000103ooom00000
0?oood0000050?ooo`03000004000000oooo0>h0oooo0P0o?ol00`00o`00oooo0000000o0?ooo`00
2`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000D0oooo00<000000?ooo`3oool0
kP3oool0100o?ol00?l003loo`0000100?ooo`00303oool2@0000080oooo00=000000?oood000000
1@3oool00`000000oooo0?ooo`3^0?ooo`03003o000o?ol000000440oooo000=0?ooo`05@000003o
ool0oooo0?oood0000001P3oool00`000000oooo0?ooo`3[0?ooo`<0?coo00<00?l00000003oool0
@@3oool001P0oooo00<000000?ooo`3oool0j`3oool203loo`03003o00000000oooo0480oooo000H
0?ooo`030000003oool0oooo0>`0oooo00<00?l00000003oool0@`3oool001P0oooo00<00000@000
003oool0j03oool303loo`03003o00000000oooo04@0oooo000H0?ooo`030000003oool0oooo0>P0
oooo0P0o?ol00`00o`00oooo000000150?ooo`00603oool00`000000oooo0?ooo`3Y0?ooo`03003o
003oool0000004H0oooo000H0?ooo`030000003oool0oooo0>D0oooo0`0o?ol00`00o`00oooo0000
00170?ooo`00603oool00`000000oooo0?ooo`3U0?ooo`80?coo00<00?l00?ooo`000000B03oool0
01P0oooo00<000000?ooo`3oool0h`3oool303loo`03003o003oool0000004T0oooo000H0?ooo`03
000004000000oooo0><0oooo0P0o?ol00`00o`00oooo0000001:0?ooo`00603oool00`000000oooo
0?ooo`3T0?ooo`03003o003oool0000004/0oooo000H0?ooo`030000003oool0oooo0>00oooo0`0o
?ol00`00o`00oooo0000001<0?ooo`00603oool00`000000oooo0?ooo`3P0?ooo`80?coo00<00?l0
0?ooo`000000C@3oool001P0oooo00<000000?ooo`3oool0h@3oool00`00o`00oooo0000001>0?oo
o`00603oool00`000000oooo0?ooo`3M0?ooo`<0?coo00<00?l00?ooo`000000C`3oool001P0oooo
00<00000@000003oool0g@3oool203loo`03003o003oool000000500oooo000H0?ooo`030000003o
ool0oooo0=h0oooo00<00?l00?ooo`000000D@3oool001P0oooo00<000000?ooo`3oool0fP3oool3
03loo`03003o003oool000000580oooo000H0?ooo`030000003oool0oooo0=X0oooo00D0?coo003o
0000o`00oooo0000001C0?ooo`00603oool00`000000oooo0?ooo`3H0?ooo`80?coo00@00?l003lo
o`3oool00000E03oool001P0oooo00<000000?ooo`3oool0f03oool01@0o?ol00?l003loo`3oool0
000005D0oooo000H0?ooo`03000004000000oooo0=P0oooo00@00?l003loo`3oool00000EP3oool0
01P0oooo00<000000?ooo`3oool0e@3oool203loo`04003o003oool0oooo000005L0oooo000H0?oo
o`030000003oool0oooo0=D0oooo00D0?coo003o000o?ol0oooo0000001H0?ooo`00603oool00`00
0000oooo0?ooo`3E0?ooo`04003o000o?ol0oooo000005T0oooo000;0?ooo`900000103oool00d00
0000oooo0?ooo`040?ooo`030000003oool0oooo0=80oooo0P0o?ol01000o`00oooo0?ooo`00001J
0?ooo`003@3oool01T000000oooo0?oood000000oooo@00000D0oooo00<000000?ooo`3oool0dP3o
ool01@0o?ol00?l003loo`3oool0000005/0oooo00060?ooo`=000000`3oool01d000000oooo0?oo
o`3ooom000000?oood0000001@3oool00`00001000000?ooo`3@0?ooo`80?coo00@00?l003loo`3o
ool00000G03oool000d0oooo00I000000?ooo`3ooom000000?oood0000050?ooo`03003o00000000
oooo0=00oooo00D0?coo003o000o?ol0oooo0000001M0?ooo`002`3oool00d000000oooo@0000002
0?ooo`03@000003ooom0000000D0oooo00<00000003o00000000d03oool01000o`00?coo0?ooo`00
001N0?ooo`00303oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00@0oooo00@00000
0?ooo`00o`000000c03oool203loo`04003o003oool0oooo000005l0oooo000H0?ooo`050000003o
ool0oooo003o00000000b`3oool01@0o?ol00?l003loo`3oool000000600oooo000H0?ooo`060000
003oool0oooo0?ooo`00o`000000b03oool203loo`04003o000o?ol0oooo00000640oooo000H0?oo
o`03000004000000oooo0080oooo00<00?l00000003oool0aP3oool01@0o?ol00?l003loo`3oool0
00000680oooo000H0?ooo`040000003oool0oooo0?ooo`80?coo00<00?l00000003oool0a@3oool0
1000o`00?coo0?ooo`00001S0?ooo`00603oool010000000oooo0?ooo`3oool303loo`03003o0000
0000oooo0<40oooo0P0o?ol01000o`00oooo0?ooo`00001T0?ooo`00603oool00`000000oooo0?oo
o`020?ooo`80?coo00<00?l003loo`000000`@3oool01@0o?ol00?l003loo`3oool0000006D0oooo
000H0?ooo`030000003oool0oooo00<0oooo0P0o?ol00`00o`00?coo0000002n0?ooo`80?coo00@0
0?l003loo`3oool00000IP3oool001P0oooo00<00000@000003oool00`3oool303loo`03003o000o
?ol000000;d0oooo00D0?coo003o000o?ol0oooo0000001W0?ooo`00603oool00`000000oooo0?oo
o`040?ooo`<0?coo00<00?l003loo`000000_03oool01000o`00?coo0?ooo`00001X0?ooo`00603o
ool00`000000oooo0?ooo`050?ooo`<0?coo00<00?l003loo`000000^03oool203loo`04003o003o
ool0oooo000006T0oooo000H0?ooo`030000003oool0oooo00H0oooo0`0o?ol00`00o`00?coo0000
002g0?ooo`0503loo`00o`00?coo0?ooo`000000JP3oool001P0oooo00<000000?ooo`3oool01`3o
ool303loo`03003o000o?ol000000;@0oooo0P0o?ol01000o`00?coo0?ooo`00001[0?ooo`00603o
ool00`000000oooo0?ooo`080?ooo`<0?coo00<00?l003loo`000000/`3oool01@0o?ol00?l003lo
o`3oool0000006`0oooo000H0?ooo`03000004000000oooo00T0oooo0`0o?ol00`00o`00?coo0000
002_0?ooo`<0?coo00@00?l003loo`3oool00000K@3oool001P0oooo00<000000?ooo`3oool02P3o
ool303loo`03003o000o?ol000000:h0oooo0P0o?ol01000o`00oooo0?ooo`00001^0?ooo`00603o
ool00`000000oooo0?ooo`0;0?ooo`<0?coo00<00?l003loo`000000[P3oool01000o`00oooo0?oo
o`00001_0?ooo`00603oool00`000000oooo0?ooo`0<0?ooo`<0?coo00<00?l003loo`000000ZP3o
ool203loo`04003o003oool0oooo00000700oooo000H0?ooo`030000003oool0oooo00h0oooo0P0o
?ol00`00o`00?coo0000002Y0?ooo`0503loo`00o`00?coo0?ooo`000000L@3oool001P0oooo00<0
00000?ooo`3oool03P3oool303loo`03003o000o?ol000000:D0oooo0`0o?ol01000o`00?coo0?oo
o`00001b0?ooo`00603oool00`00001000000?ooo`0?0?ooo`<0?coo00<00?l003loo`000000Y03o
ool203loo`04003o003oool0oooo000007<0oooo000H0?ooo`030000003oool0oooo0140oooo0P0o
?ol00`00o`00?coo0?ooo`2Q0?ooo`<0?coo00@00?l00?ooo`3oool00000M03oool001P0oooo00<0
00000?ooo`3oool04@3oool303loo`03003o000o?ol0oooo0:00oooo0P0o?ol01000o`00oooo0?oo
o`00001e0?ooo`00603oool00`000000oooo0?ooo`0B0?ooo`80?coo00<00?l003loo`0o?ol0WP3o
ool303loo`04003o003oool0oooo000007H0oooo000;0?ooo`=000000`3oool00d000000oooo0?oo
o`040?ooo`030000003oool0oooo01@0oooo00@0?coo003o000o?ol0?cooW@3oool203loo`04003o
003oool0oooo000007L0oooo000;0?ooo`03@000003oool0oooo0080oooo00=000000?oood000000
1@3oool00`000000oooo0?ooo`0E0?ooo`0403loo`00o`00?coo03looiT0oooo0`0o?ol01@3oool0
0?l00?ooo`3oool0000007P0oooo00060?ooo`=000000`3oool01d000000oooo0?ooo`3ooom00000
0?oood0000001@3oool00`00001000000?ooo`0E0?ooo`80?coo00<00?l003loo`0o?ol0V03oool3
03loo`04003o003oool0oooo000007T0oooo000<0?ooo`07@000003oool0oooo0?oood000000oooo
@00000050?ooo`030000003oool0oooo01H0oooo0P0o?ol00`00o`00?coo03loo`2H0?ooo`0503lo
o`00o`00oooo0?ooo`000000NP3oool000/0oooo00=000000?oood0000000P3oool00d000000oooo
@00000050?ooo`030000003oool0oooo01P0oooo00@0?coo003o000o?ol0?cooU03oool303loo`04
003o003oool0oooo000007/0oooo000<0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0I0?ooo`0403loo`00o`00?coo000009<0oooo0P0o?ol01@00
o`00oooo0?ooo`3oool0000007/0oooo000H0?ooo`030000003oool0oooo01T0oooo0P0o?ol00`00
o`00?coo0000002@0?ooo`<0?coo00D00?l00?ooo`3oool0oooo0000001l0?ooo`00603oool00`00
0000oooo0?ooo`0J0?ooo`80?coo00<00?l003loo`0o?ol0S`3oool203loo`05003o003oool0oooo
0?ooo`000000O@3oool001P0oooo00<00000@000003oool06`3oool203loo`03003o000o?ol0?coo
08`0oooo0`0o?ol01@00o`00oooo0?ooo`3oool0000007h0oooo000H0?ooo`030000003oool0oooo
01`0oooo0P0o?ol00`00o`00?coo03loo`2;0?ooo`80?coo00D00?l00?ooo`3oool0oooo0000001o
0?ooo`00603oool00`000000oooo0?ooo`0N0?ooo`0403loo`00o`00?coo03loohL0oooo0`0o?ol0
0`3oool00?l00?ooo`020?ooo`030000003oool0oooo07h0oooo000H0?ooo`030000003oool0oooo
01l0oooo00@0?coo003o000o?ol0?cooQP3oool303loo`05003o003oool0oooo0?ooo`000000P@3o
ool001P0oooo00<000000?ooo`3oool0803oool0100o?ol00?l003loo`0000230?ooo`@0?coo00D0
0?l00?ooo`3oool0oooo000000220?ooo`00603oool00`000000oooo0?ooo`0P0?ooo`80?coo00<0
0?l003loo`000000PP3oool203loo`800?l00`3oool00`000000oooo0?ooo`210?ooo`00603oool0
0`00001000000?ooo`0Q0?ooo`80?coo00<00?l003loo`0o?ol0O`3oool303loo`03003o003oool0
oooo0080oooo00<000000?ooo`3oool0PP3oool001P0oooo00<000000?ooo`3oool08P3oool203lo
o`03003o000o?ol0?coo07`0oooo100o?ol00`00o`00oooo0?ooo`020?ooo`030000003oool0oooo
08<0oooo000H0?ooo`030000003oool0oooo02<0oooo0P0o?ol00`00o`00?coo03loo`1k0?ooo`<0
?coo00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`240?ooo`00603oool00`000000oooo
0?ooo`0U0?ooo`0403loo`00o`000?l003loogP0oooo100o?ol00`00o`00oooo0?ooo`020?ooo`03
0000003oool0oooo08D0oooo000H0?ooo`030000003oool0oooo02H0oooo0P0o?ol00`00o`00?coo
0?ooo`1f0?ooo`<0?coo00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`260?ooo`00603o
ool00`00001000000?ooo`0W0?ooo`80?coo00<00?l003loo`3oool0LP3oool303loo`030?ooo`0o
?ol00?l000@0oooo00<000000?ooo`3oool0Q`3oool001P0oooo00<000000?ooo`3oool0:03oool2
03loo`03003o000o?ol0oooo0740oooo0`0o?ol00`3oool00?l00?ooo`030?ooo`030000003oool0
oooo08P0oooo000H0?ooo`030000003oool0oooo02T0oooo0P0o?ol00`00o`00?coo0?ooo`1^0?oo
o`@0?coo0P00o`040?ooo`030000003oool0oooo08T0oooo000H0?ooo`030000003oool0oooo02X0
oooo0P0o?ol00`00o`00?coo0?ooo`1]0?ooo`<0?coo00<00?l00?ooo`3oool00P3oool2000008`0
oooo000H0?ooo`030000003oool0oooo02/0oooo0P0o?ol00`00o`00?coo0?ooo`1Z0?ooo`@0?coo
00<00?l00?ooo`3oool00P3oool00`000000oooo0?ooo`2<0?ooo`00603oool00`000000oooo0?oo
o`0/0?ooo`80?coo00<00?l003loo`3oool0I`3oool503loo`03003o003oool0oooo0080oooo00<0
00000?ooo`3oool0S@3oool001P0oooo00<00000@000003oool0;@3oool203loo`03003o000o?ol0
oooo06H0oooo100o?ol00`00o`00oooo0?ooo`020?ooo`030000003oool0oooo08h0oooo000H0?oo
o`030000003oool0oooo02h0oooo0P0o?ol00`00o`00?coo0?ooo`1S0?ooo`@0?coo00<0oooo003o
003oool00`3oool00`000000oooo0?ooo`2?0?ooo`00603oool00`000000oooo0?ooo`0_0?ooo`80
?coo00<00?l003loo`0o?ol0H03oool503loo`030?ooo`00o`00oooo00<0oooo00<000000?ooo`3o
ool0T03oool001P0oooo00<000000?ooo`3oool0<03oool203loo`03003o000o?ol0?coo05l0oooo
100o?ol2003o00@0oooo00<000000?ooo`3oool0T@3oool000X0oooo1D0000020?ooo`03@000003o
ool0oooo00@0oooo00<000000?ooo`3oool0<@3oool203loo`03003o000o?ol0?coo05`0oooo100o
?ol00`3oool00?l00?ooo`040?ooo`030000003oool0oooo0980oooo000<0?ooo`07@000003oool0
oooo0?oood000000oooo@00000050?ooo`030000003oool0oooo03<0oooo00<0?coo003o000o?ol0
0P0o?omH0?ooo`D0?coo00<0oooo003o003oool0103oool00`000000oooo0?ooo`2C0?ooo`001P3o
ool3@00000<0oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0oooo00<00000@000003o
ool0=03oool00`0o?ol00?l003loo`0203looeL0oooo100o?ol00`3oool00?l00?ooo`040?ooo`03
0000003oool0oooo09@0oooo000<0?ooo`07@000003oool0oooo0?oood000000oooo@00000050?oo
o`030000003oool0oooo03H0oooo00@00?l003loo`0o?ol0?cooE03oool403loo`80oooo00<00?l0
0?ooo`3oool00`3oool00`000000oooo0?ooo`2E0?ooo`00303oool01d000000oooo0?ooo`3ooom0
00000?oood0000001@3oool00`000000oooo0?ooo`0g0?ooo`04003o000o?ol0?coo03looe40oooo
1@0o?ol00`3oool00?l0003o00050?ooo`030000003oool0oooo09H0oooo000;0?ooo`900000103o
ool00d000000oooo0?ooo`040?ooo`030000003oool0oooo03P0oooo00@00?l003loo`0o?ol0?coo
CP3oool603loo`030?ooo`00o`00oooo00D0oooo00<000000?ooo`3oool0U`3oool001P0oooo00<0
00000?ooo`3oool0>@3oool01000o`00?coo03loo`0o?om=0?ooo`@0?coo0P3oool00`00o`00oooo
0?ooo`040?ooo`030000003oool0oooo09P0oooo000H0?ooo`030000003oool0oooo03X0oooo0P00
o`0403loodP0oooo100o?ol30?ooo`03003o003oool0oooo00@0oooo00<000000?ooo`3oool0V@3o
ool001P0oooo00<00000@000003oool0>`3oool00`0o?ol00?l003loo`0303loodD0oooo1@0o?ol3
0?ooo`03003o003oool0oooo00@0oooo00<000000?ooo`3oool0VP3oool001P0oooo00<000000?oo
o`3oool0?03oool00`0o?ol00?l003loo`0303lood<0oooo1@0o?ol20?ooo`800?l01P3oool00`00
0000oooo0?ooo`2K0?ooo`00603oool00`000000oooo0?ooo`0n0?ooo`03003o000o?ol0?coo0080
?coo@03oool503loo`<0oooo00<00?l00?ooo`3oool01@3oool00`000000oooo0?ooo`2L0?ooo`00
603oool00`000000oooo0?ooo`0o0?ooo`800?l01@0o?olk0?ooo`H0?coo0`3oool00`00o`00oooo
0?ooo`050?ooo`030000003oool0oooo09d0oooo000H0?ooo`030000003oool0oooo0400oooo00<0
0000003o000o?ol0100o?olh0?ooo`H0?coo0`3oool2003o00P0oooo00<000000?ooo`3oool0W@3o
ool001P0oooo00<000000?ooo`3oool0@@3oool00`0000000?l00?ooo`0403loocD0oooo1P0o?ol4
0?ooo`03003o003oool0oooo00L0oooo00<000000?ooo`3oool0WP3oool001P0oooo00<00000@000
003oool0@P3oool00`0000000?l00?ooo`0603looc00oooo1P0o?ol40?ooo`800?l02@3oool00`00
0000oooo0?ooo`2O0?ooo`00603oool00`000000oooo0?ooo`130?ooo`0300000000o`000?l000H0
?coo;03oool703loo`D0oooo00<00?l00?ooo`3oool0203oool00`000000oooo0?ooo`2P0?ooo`00
603oool00`000000oooo0?ooo`140?ooo`050000003oool00?l003loo`3oool01P0o?olW0?ooo`L0
?coo1@3oool2003o00X0oooo00<000000?ooo`3oool0X@3oool001P0oooo00<000000?ooo`3oool0
A@3oool01@000000oooo003o0000o`00oooo00L0?coo8P3oool703loo`030?ooo`0o?ol0oooo00<0
oooo0P00o`0;0?ooo`030000003oool0oooo0:80oooo000H0?ooo`030000003oool0oooo04H0oooo
00<000000?ooo`3oool00P00o`000`0o?ol0oooo03loo`0603looad0oooo1`0o?ol60?ooo`800?l0
303oool00`000000oooo0?ooo`2S0?ooo`00603oool00`000000oooo0?ooo`170?ooo`040000003o
ool0oooo0?ooo`800?l000<0oooo03loo`0o?ol0200o?olD0?ooo`X0?coo1P3oool2003o00d0oooo
00<000000?ooo`3oool0Y03oool001P0oooo00<00000@000003oool0<`3oool3@0000080oooo00=0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`800?l00P3oool>03loo`L0oooo3@0o
?ol70?ooo`800?l03P3oool00`000000oooo0?ooo`0J0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0;@3oool5@0000080oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0[0?ooo`E0000000@0oooo@0000400001000000`3oool00d000000oooo0?ooo`0=0?ooo`00603o
ool00`000000oooo0?ooo`0d0?ooo`06@000003oool0oooo@000003ooom000003`3oool00`000000
oooo0?ooo`030?ooo`800?l00P3oool00`0o?ol0oooo03loo`0H03loo`06@000000o?ol0?coo@000
003ooom00000103oool2003o00l0oooo00<000000?ooo`3oool06P3oool00d000000oooo@0000002
0?ooo`03@000003ooom000000300oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo
00=000000?oood000000;P3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oood00
00003P3oool001P0oooo00<000000?ooo`3oool0<P3oool4@00000040?oood000000oooo@0000100
oooo00<000000?ooo`3oool0103oool2003o00D0oooo0`0o?ol00`3oool0?coo03loo`0;03loo`06
0?ooo`0o?ol0?coo@000003ooom000000P3oool00d000000oooo@00000020?ooo`800?l0403oool0
0`000000oooo0?ooo`0K0?ooo`03@000003ooom000000080oooo00=000000?oood000000<03oool0
1d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000^0?ooo`03@000
003oool0oooo0080oooo00M000000?ooo`3oool0oooo@000003ooom0000000h0oooo000H0?ooo`03
0000003oool0oooo0380oooo00=000000?oood0000000P3oool00d000000oooo@000000A0?ooo`03
0000003oool0oooo00D0oooo0`00o`090?ooo`80?coo00D0oooo03loo`0o?ol0oooo03loo`060?oo
o`9000000`3oool00d0000000?l0003o0002003o0140oooo00<000000?ooo`3oool07@3oool01d00
0000oooo0?ooo`3ooom000000?oood000000<03oool01d000000oooo0?ooo`3ooom000000?oood00
00000P3oool00d000000oooo@000000^0?ooo`03@000003oool0oooo0080oooo00M000000?ooo`3o
ool0oooo@000003ooom0000000h0oooo000H0?ooo`030000003oool0oooo03<0oooo0T0000020?oo
o`03@000003ooom000000180oooo00<000000?ooo`3oool01`3oool4003o0180oooo00=000000?oo
o`00o`000`00o`000`3ooom000000?ooo`0A0?ooo`030000003oool0oooo01d0oooo00=000000?oo
od0000000P3oool00d000000oooo@000000`0?ooo`07@000003oool0oooo0?oood000000oooo@000
00020?ooo`03@000003ooom0000002h0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood0000003P3oool001P0oooo00<000000?ooo`3oool0=03oool01D000000oooo
0?ooo`3ooom0000001@0oooo00<000000?ooo`3oool02P3ooolD003o0005@000003oool0oooo0?oo
od0000004P3oool00`000000oooo0?ooo`0O0?ooo`03@000003oool0oooo0080oooo00=000000?oo
o`3oool0;P3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0/0?oo
o`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00d0oooo000H0?ooo`03
000004000000oooo04d0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2[0?ooo`00
603oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0
[03oool001P0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0`0?ooo`030000003o
ool0oooo0:d0oooo000H0?ooo`030000003oool0oooo0500oooo0P00000_0?ooo`030000003oool0
oooo0:<0oooo0d0000080?ooo`00603oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool0Y03oool00d000000oooo@00000080?ooo`00603ooooo00000240
000000=000000?ooo`3oool02@3oool00d000000oooo0?ooo`060?ooo`00603oool00`000000oooo
0?ooo`0;0?ooo`03@000003oool0oooo00`0oooo00=000000?ooo`3oool02`3oool00d000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00=000000?ooo`3oool02`3oool00d000000oooo
0?ooo`0<0?ooo`03@000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00d000000oooo
0?ooo`0<0?ooo`03@000003oool0oooo00/0oooo00=000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`03@000003oool0oooo00`0oooo00=000000?ooo`3oool02`3oool00d000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00=000000?ooo`3oool02`3oool00d000000oooo
0?ooo`0<0?ooo`03@000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool00d000000oooo
0?ooo`070?ooo`00603oool00`000000oooo0?ooo`0f0?ooo`03@000003oool0oooo03L0oooo00=0
00000?ooo`3oool0=`3oool00d000000oooo0?ooo`0f0?ooo`03@000003oool0oooo03L0oooo00=0
00000?ooo`3oool01`3oool00d000000oooo@00000080?ooo`00603oool00d000000oooo0?ooo`3o
0?ooobP0oooo0d0000080?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3o
oom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3o
oom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`005P3oool2@0000?l0oooo
=P3oool001D0oooo00=000000?oood000000o`3ooolf0?ooo`005@3oool00d000000oooo@000003o
0?ooocH0oooo000E0?ooo`04@000003oool0oooo@0000?l0oooo=@3oool001@0oooo00E000000?oo
o`3oool0oooo@000003o0?ooocD0oooo000D0?ooo`90000000<0oooo@00004000000o`3ooole0?oo
o`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00o`3ooom>0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 332.313}, {204.938, 0}} -> {11.6204, -61.5405, 
  0.346767, 0.34226}}]
}, Open  ]],

Cell[TextData[
"\"Err - rozdiel medzi explicitn\[YAcute]m rie\.9aen\[IAcute]m a na\.9aim v\
\[YAcute]sledkom\ntr1: tabu\:017eka chyby pribli\.9en\[EAcute]ho \
rie\.9aenia\""], "Text"],

Cell["\<\
Err[i_,sgm_]:=SoldStrangle[xs[[i]],X1,X2,sgm,r,DD,t]-ys[[i]];
tr1:=Table[{xs[[i]],Err[i,sigma]},{i,2m+1}];\
\>", "Input"],

Cell["\"Maximov\[AAcute] chyba\"", "Text"],

Cell["\<\
Print[\"m = \",m,\" n = \",n,\" trans = \",trans,\" Max.chyba = \
\",Max[Table[Abs[Err[i,str]],{i,2m+1}]]]\
\>", "Input"],

Cell["\"Graf chyby pri delen\[IAcute] m=100, n=100\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
g=ListPlot[tr1,PlotStyle->{PointSize[0.02],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];

Show[g,DisplayFunction->$DisplayFunction,PlotRange->All]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.140244 0.0074429 0.361604 92.8222 [
[.15747 .3491 -6 -9 ]
[.15747 .3491 6 0 ]
[.30633 .3491 -6 -9 ]
[.30633 .3491 6 0 ]
[.45519 .3491 -6 -9 ]
[.45519 .3491 6 0 ]
[.60405 .3491 -9 -9 ]
[.60405 .3491 9 0 ]
[.7529 .3491 -9 -9 ]
[.7529 .3491 9 0 ]
[.90176 .3491 -9 -9 ]
[.90176 .3491 9 0 ]
[-0.00389 .08314 -36 -4.5 ]
[-0.00389 .08314 0 4.5 ]
[-0.00389 .17596 -36 -4.5 ]
[-0.00389 .17596 0 4.5 ]
[-0.00389 .26878 -36 -4.5 ]
[-0.00389 .26878 0 4.5 ]
[-0.00389 .45443 -30 -4.5 ]
[-0.00389 .45443 0 4.5 ]
[-0.00389 .54725 -30 -4.5 ]
[-0.00389 .54725 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15747 .3616 m
.15747 .36785 L
s
[(40)] .15747 .3491 0 1 Mshowa
.30633 .3616 m
.30633 .36785 L
s
[(60)] .30633 .3491 0 1 Mshowa
.45519 .3616 m
.45519 .36785 L
s
[(80)] .45519 .3491 0 1 Mshowa
.60405 .3616 m
.60405 .36785 L
s
[(100)] .60405 .3491 0 1 Mshowa
.7529 .3616 m
.7529 .36785 L
s
[(120)] .7529 .3491 0 1 Mshowa
.90176 .3616 m
.90176 .36785 L
s
[(140)] .90176 .3491 0 1 Mshowa
.125 Mabswid
.04583 .3616 m
.04583 .36535 L
s
.08304 .3616 m
.08304 .36535 L
s
.12026 .3616 m
.12026 .36535 L
s
.19469 .3616 m
.19469 .36535 L
s
.2319 .3616 m
.2319 .36535 L
s
.26912 .3616 m
.26912 .36535 L
s
.34354 .3616 m
.34354 .36535 L
s
.38076 .3616 m
.38076 .36535 L
s
.41797 .3616 m
.41797 .36535 L
s
.4924 .3616 m
.4924 .36535 L
s
.52962 .3616 m
.52962 .36535 L
s
.56683 .3616 m
.56683 .36535 L
s
.64126 .3616 m
.64126 .36535 L
s
.67847 .3616 m
.67847 .36535 L
s
.71569 .3616 m
.71569 .36535 L
s
.79012 .3616 m
.79012 .36535 L
s
.82733 .3616 m
.82733 .36535 L
s
.86455 .3616 m
.86455 .36535 L
s
.93898 .3616 m
.93898 .36535 L
s
.97619 .3616 m
.97619 .36535 L
s
.25 Mabswid
0 .3616 m
1 .3616 L
s
.00861 .08314 m
.01486 .08314 L
s
[(-0.003)] -0.00389 .08314 1 0 Mshowa
.00861 .17596 m
.01486 .17596 L
s
[(-0.002)] -0.00389 .17596 1 0 Mshowa
.00861 .26878 m
.01486 .26878 L
s
[(-0.001)] -0.00389 .26878 1 0 Mshowa
.00861 .45443 m
.01486 .45443 L
s
[(0.001)] -0.00389 .45443 1 0 Mshowa
.00861 .54725 m
.01486 .54725 L
s
[(0.002)] -0.00389 .54725 1 0 Mshowa
.125 Mabswid
.00861 .1017 m
.01236 .1017 L
s
.00861 .12027 m
.01236 .12027 L
s
.00861 .13883 m
.01236 .13883 L
s
.00861 .15739 m
.01236 .15739 L
s
.00861 .19452 m
.01236 .19452 L
s
.00861 .21309 m
.01236 .21309 L
s
.00861 .23165 m
.01236 .23165 L
s
.00861 .25022 m
.01236 .25022 L
s
.00861 .28735 m
.01236 .28735 L
s
.00861 .30591 m
.01236 .30591 L
s
.00861 .32447 m
.01236 .32447 L
s
.00861 .34304 m
.01236 .34304 L
s
.00861 .38017 m
.01236 .38017 L
s
.00861 .39873 m
.01236 .39873 L
s
.00861 .4173 m
.01236 .4173 L
s
.00861 .43586 m
.01236 .43586 L
s
.00861 .47299 m
.01236 .47299 L
s
.00861 .49155 m
.01236 .49155 L
s
.00861 .51012 m
.01236 .51012 L
s
.00861 .52868 m
.01236 .52868 L
s
.00861 .06457 m
.01236 .06457 L
s
.00861 .04601 m
.01236 .04601 L
s
.00861 .02744 m
.01236 .02744 L
s
.00861 .00888 m
.01236 .00888 L
s
.00861 .56581 m
.01236 .56581 L
s
.00861 .58438 m
.01236 .58438 L
s
.00861 .60294 m
.01236 .60294 L
s
.25 Mabswid
.00861 0 m
.00861 .61803 L
s
.25 .25 1 r
.02 w
.02381 .36159 Mdot
.02539 .36144 Mdot
.02699 .3613 Mdot
.0286 .36117 Mdot
.03022 .36105 Mdot
.03187 .36095 Mdot
.03352 .36086 Mdot
.0352 .36078 Mdot
.03689 .36072 Mdot
.0386 .36068 Mdot
.04032 .36066 Mdot
.04206 .36066 Mdot
.04381 .36068 Mdot
.04559 .36074 Mdot
.04738 .36083 Mdot
.04919 .36096 Mdot
.05101 .36113 Mdot
.05285 .36136 Mdot
.05471 .36166 Mdot
.05659 .36202 Mdot
.05849 .36248 Mdot
.0604 .36304 Mdot
.06234 .36371 Mdot
.06429 .36452 Mdot
.06626 .36549 Mdot
.06825 .36663 Mdot
.07026 .36798 Mdot
.07229 .36957 Mdot
.07433 .37141 Mdot
.0764 .37355 Mdot
.07849 .37601 Mdot
.0806 .37884 Mdot
.08272 .38206 Mdot
.08487 .38571 Mdot
.08704 .38984 Mdot
.08923 .39446 Mdot
.09144 .39962 Mdot
.09367 .40534 Mdot
.09593 .41164 Mdot
.0982 .41855 Mdot
.1005 .42607 Mdot
.10282 .4342 Mdot
.10516 .44294 Mdot
.10753 .45225 Mdot
.10991 .4621 Mdot
.11232 .47244 Mdot
.11476 .48321 Mdot
.11721 .49431 Mdot
.11969 .50565 Mdot
.1222 .51711 Mdot
.12473 .52854 Mdot
.12728 .5398 Mdot
.12986 .55072 Mdot
.13246 .56111 Mdot
.13509 .5708 Mdot
.13774 .57959 Mdot
.14042 .58728 Mdot
.14312 .59367 Mdot
.14585 .59859 Mdot
.14861 .60186 Mdot
.15139 .60332 Mdot
.1542 .60285 Mdot
.15704 .60034 Mdot
.1599 .59573 Mdot
.16279 .58899 Mdot
.16571 .58014 Mdot
.16866 .56922 Mdot
.17164 .55635 Mdot
.17464 .54167 Mdot
.17768 .52538 Mdot
.18074 .5077 Mdot
.18383 .4889 Mdot
.18695 .46929 Mdot
.19011 .44918 Mdot
.19329 .4289 Mdot
.1965 .4088 Mdot
.19975 .3892 Mdot
.20302 .37042 Mdot
.20633 .35274 Mdot
.20967 .33642 Mdot
.21304 .32166 Mdot
.21644 .3086 Mdot
.21988 .29735 Mdot
.22335 .28791 Mdot
.22685 .28026 Mdot
.23039 .27428 Mdot
.23396 .2698 Mdot
.23757 .26659 Mdot
.24121 .26437 Mdot
.24488 .26283 Mdot
.24859 .26161 Mdot
.25234 .26035 Mdot
.25612 .25868 Mdot
.25994 .25626 Mdot
.2638 .25276 Mdot
.26769 .24791 Mdot
.27162 .24146 Mdot
.27559 .23327 Mdot
.27959 .22325 Mdot
.28364 .21138 Mdot
.28772 .19776 Mdot
.29185 .18253 Mdot
.29601 .16595 Mdot
.30021 .14833 Mdot
.30446 .13005 Mdot
.30874 .11156 Mdot
.31307 .09332 Mdot
.31743 .07586 Mdot
.32184 .05968 Mdot
.32629 .0453 Mdot
.33079 .03319 Mdot
.33533 .02381 Mdot
.33991 .01754 Mdot
.34454 .01472 Mdot
.34921 .01558 Mdot
.35392 .02029 Mdot
.35868 .02892 Mdot
.36349 .04146 Mdot
.36834 .05778 Mdot
.37324 .07769 Mdot
.37819 .10091 Mdot
.38319 .12708 Mdot
.38823 .15578 Mdot
.39332 .18655 Mdot
.39846 .21889 Mdot
.40365 .25226 Mdot
.40889 .28613 Mdot
.41418 .31998 Mdot
.41952 .35329 Mdot
.42492 .38558 Mdot
.43036 .41642 Mdot
.43586 .44539 Mdot
.44141 .47218 Mdot
.44701 .4965 Mdot
.45267 .51814 Mdot
.45839 .53695 Mdot
.46415 .55284 Mdot
.46998 .56579 Mdot
.47586 .57583 Mdot
.48179 .58303 Mdot
.48778 .58752 Mdot
.49383 .58947 Mdot
.49994 .58907 Mdot
.50611 .58654 Mdot
.51234 .58213 Mdot
.51863 .57607 Mdot
.52497 .56862 Mdot
.53138 .56002 Mdot
.53785 .55052 Mdot
.54439 .54035 Mdot
.55098 .52972 Mdot
.55764 .51883 Mdot
.56437 .50785 Mdot
.57116 .49695 Mdot
.57801 .48625 Mdot
.58493 .47588 Mdot
.59192 .46591 Mdot
.59897 .45644 Mdot
.60609 .44751 Mdot
.61328 .43915 Mdot
.62054 .4314 Mdot
.62787 .42425 Mdot
.63527 .41772 Mdot
.64275 .41178 Mdot
.65029 .40642 Mdot
.65791 .4016 Mdot
.6656 .39731 Mdot
.67336 .3935 Mdot
.6812 .39013 Mdot
.68911 .38718 Mdot
.6971 .38461 Mdot
.70517 .38237 Mdot
.71332 .38043 Mdot
.72154 .37877 Mdot
.72984 .37733 Mdot
.73823 .37611 Mdot
.74669 .37506 Mdot
.75524 .37416 Mdot
.76386 .37339 Mdot
.77257 .37273 Mdot
.78137 .37215 Mdot
.79025 .37165 Mdot
.79921 .37121 Mdot
.80826 .3708 Mdot
.8174 .37042 Mdot
.82663 .37007 Mdot
.83595 .36971 Mdot
.84535 .36936 Mdot
.85485 .369 Mdot
.86443 .36862 Mdot
.87411 .36822 Mdot
.88389 .36779 Mdot
.89375 .36732 Mdot
.90372 .36681 Mdot
.91377 .36625 Mdot
.92393 .36563 Mdot
.93418 .36496 Mdot
.94453 .36423 Mdot
.95498 .36342 Mdot
.96554 .36255 Mdot
.97619 .36159 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`009`3oool00`000000oooo0?ooo`3f0?ooo`00
9`3oool00`00001000000?ooo`1?0?ooo`@0?cooX`3oool002L0oooo00<000000?ooo`3oool0C@3o
ool703looj80oooo000W0?ooo`030000003oool0oooo04d0oooo200o?onQ0?ooo`009`3oool00`00
0000oooo0?ooo`1<0?ooo`T0?cooX@3oool002L0oooo00<000000?ooo`3oool0C03oool403loo`03
0?ooo`0o?ol0?coo00<0?cooX03oool002L0oooo00<00000@000003oool0B`3oool503loo`80oooo
100o?onP0?ooo`009`3oool00`000000oooo0?ooo`1;0?ooo`@0?coo0`3oool403looj00oooo000W
0?ooo`030000003oool0oooo04/0oooo100o?ol40?ooo`@0?cooW`3oool002L0oooo00<000000?oo
o`3oool0BP3oool403loo`D0oooo100o?onO0?ooo`009`3oool00`00001000000?ooo`1:0?ooo`@0
?coo1@3oool403looil0oooo000W0?ooo`030000003oool0oooo04X0oooo100o?ol60?ooo`80?coo
X03oool002L0oooo00<000000?ooo`3oool0B`3oool203loo`P0oooo100o?onM0?ooo`009`3oool0
0`000000oooo0?ooo`190?ooo`@0?coo203oool403looid0oooo000W0?ooo`030000003oool0oooo
04T0oooo100o?ol80?ooo`@0?cooW@3oool002L0oooo00<00000@000003oool0B@3oool403loo`T0
oooo0P0o?onN0?ooo`009`3oool00`000000oooo0?ooo`1:0?ooo`80?cooZP3oool002L0oooo00<0
00000?ooo`3oool0B03oool403loo`X0oooo100o?onL0?ooo`003@3oool00d000000oooo0?ooo`02
0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3o
ool2@00000D0oooo00<000000?ooo`3oool0B03oool403loo`X0oooo100o?onL0?ooo`00303oool0
0d000000oooo@00000070?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool0
0d000000oooo0?ooo`020?ooo`030000003oool0oooo04P0oooo100o?ol:0?ooo`@0?cooW03oool0
00L0oooo0d0000020?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d00
0000oooo@00000030?ooo`03@000003oool0oooo00<0oooo00<00000@000003oool0B@3oool203lo
o``0oooo0P0o?onM0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080
oooo00=000000?oood000000103oool00d000000oooo0?ooo`020?ooo`030000003oool0oooo04L0
oooo100o?on[0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo
00=000000?oood0000000P3oool00d000000oooo@00000040?ooo`030000003oool0oooo04L0oooo
100o?on[0?ooo`003@3oool00d000000oooo0?ooo`070?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo04L0oooo100o
?ol<0?ooo`@0?cooV`3oool002L0oooo00<00000@000003oool0B03oool203loo`d0oooo100o?onK
0?ooo`009`3oool00`000000oooo0?ooo`1G0?ooo`@0?cooV`3oool002L0oooo00<000000?ooo`3o
ool0AP3oool403loo`h0oooo0P0o?onL0?ooo`009`3oool00`000000oooo0?ooo`160?ooo`@0?coo
[03oool002L0oooo00<000000?ooo`3oool0AP3oool403looj`0oooo000W0?ooo`03000004000000
oooo04L0oooo0P0o?on]0?ooo`009`3oool00`000000oooo0?ooo`150?ooo`@0?coo3`3oool403lo
oiX0oooo000W0?ooo`030000003oool0oooo04D0oooo100o?ol?0?ooo`@0?cooVP3oool002L0oooo
00<000000?ooo`3oool0A@3oool403loo`l0oooo100o?onJ0?ooo`009`3oool00`00001000000?oo
o`160?ooo`80?coo4@3oool203looi/0oooo000W0?ooo`030000003oool0oooo0?H0oooo000W0?oo
o`030000003oool0oooo04@0oooo100o?on^0?ooo`009`3oool00`000000oooo0?ooo`140?ooo`@0
?coo[P3oool002L0oooo00<000000?ooo`3oool0A03oool403looa80oooo100o?onH0?ooo`009`3o
ool00`00001000000?ooo`150?ooo`80?coo4`3oool403looiP0oooo000W0?ooo`030000003oool0
oooo0480oooo100o?olD0?ooo`@0?cooV03oool002L0oooo00<000000?ooo`3oool0@P3oool403lo
oaD0oooo0P0o?onI0?ooo`003@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080
oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool3@00000@0oooo00<000000?oo
o`3oool0@P3oool403look00oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood00
00000P3oool00d000000oooo@00000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3o
ool0@`3oool203look40oooo00070?ooo`=000000P3oool00d000000oooo@00000070?ooo`03@000
003ooom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000
04000000oooo0440oooo100o?ona0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003o
oom000000080oooo00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000003o
ool0oooo0440oooo100o?olF0?ooo`@0?cooU`3oool000`0oooo00=000000?oood0000001`3oool0
0d000000oooo@00000020?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool0
0`000000oooo0?ooo`110?ooo`@0?coo5P3oool403looiL0oooo000=0?ooo`03@000003oool0oooo
00L0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo
00<0oooo00<000000?ooo`3oool0@P3oool203looaL0oooo100o?onG0?ooo`009`3oool00`000010
00000?ooo`100?ooo`@0?coo603oool203looiP0oooo000W0?ooo`030000003oool0oooo0400oooo
100o?onb0?ooo`009`3oool00`000000oooo0?ooo`100?ooo`@0?coo/P3oool002L0oooo00<00000
0?ooo`3oool0@@3oool203look<0oooo000W0?ooo`030000003oool0oooo03l0oooo100o?onc0?oo
o`009`3oool00`00001000000?ooo`0o0?ooo`@0?coo6@3oool403looiH0oooo000W0?ooo`030000
003oool0oooo03l0oooo100o?olI0?ooo`@0?cooUP3oool002L0oooo00<000000?ooo`3oool0?P3o
ool403looaX0oooo100o?onF0?ooo`009`3oool00`000000oooo0?ooo`0n0?ooo`@0?coo6`3oool2
03looiL0oooo000W0?ooo`030000003oool0oooo03d0oooo1@0o?ond0?ooo`009`3oool00`000010
00000?ooo`0m0?ooo`@0?coo]@3oool002L0oooo00<000000?ooo`3oool0?03oool503lookD0oooo
000W0?ooo`030000003oool0oooo03`0oooo100o?onf0?ooo`009`3oool00`000000oooo0?ooo`0k
0?ooo`D0?coo]P3oool002L0oooo00<00000@000003oool0>P3oool503looah0oooo100o?onE0?oo
o`009`3oool00`000000oooo0?ooo`0i0?ooo`H0?coo7P3oool403looiD0oooo000W0?ooo`030000
003oool0oooo03H0oooo200o?olO0?ooo`@0?cooU@3oool000d0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool01D00
00030?ooo`030000003oool0oooo03@0oooo2@0o?olQ0?ooo`80?cooUP3oool000`0oooo00=00000
0?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0c0?ooo`T0?coo^P3oool000L0oooo0d0000020?oo
o`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000030?oo
o`03@000003oool0oooo00<0oooo00<00000@000003oool0<P3oool903look/0oooo000<0?ooo`03
@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000030?ooo`03
@000003oool0oooo00<0oooo00<000000?ooo`3oool0<P3oool603lookh0oooo000<0?ooo`03@000
003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@00000030?ooo`03@000
003oool0oooo00<0oooo00<000000?ooo`3oool0<@3oool503lool00oooo000=0?ooo`03@000003o
ool0oooo00L0oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool2@00000D0oooo
00<000000?ooo`3oool0<@3oool403loobX0oooo100o?onC0?ooo`009`3oool00`000000oooo0?oo
o`0`0?ooo`D0?coo:P3oool403looi<0oooo000W0?ooo`03000004000000oooo0300oooo100o?ol[
0?ooo`@0?cooT`3oool002L0oooo00<000000?ooo`3oool0;`3oool503loob`0oooo0P0o?onD0?oo
o`009`3oool00`000000oooo0?ooo`0_0?ooo`@0?coo``3oool002L0oooo00<000000?ooo`3oool0
;`3oool403lool<0oooo000W0?ooo`03000004000000oooo02l0oooo100o?oo30?ooo`009`3oool0
0`000000oooo0?ooo`0_0?ooo`@0?coo``3oool002L0oooo00<000000?ooo`3oool0;`3oool403lo
ol<0oooo000W0?ooo`030000003oool0oooo01l0oooo0d0000020?ooo`03@000003oool0oooo00L0
oooo100o?olA0?ooo`900000103oool00d000000oooo0?ooo`0D0?ooo`@0?coo1@3oool00d000000
oooo0?ooo`020?ooo`03@000003oool0oooo01T0oooo1D0000020?ooo`03@000003oool0oooo0080
oooo00=000000?ooo`3oool05P3oool5@00000040?oood0000100000@00000<0oooo00=000000?oo
o`3oool05P3oool5@0000080oooo0d0000020?ooo`03@000003oool0oooo01<0oooo000W0?ooo`03
0000003oool0oooo0200oooo00I000000?ooo`3ooom000000?oood0000080?ooo`@0?coo4@3oool0
0d000000oooo@00000020?ooo`03@000003ooom0000001D0oooo100o?ol40?ooo`03@000003ooom0
00000080oooo00=000000?oood000000703oool01d000000oooo0?ooo`3ooom000000?oood000000
0P3oool00d000000oooo@000000I0?ooo`05@000003oool0oooo0?oood000000103oool00d000000
oooo@000000I0?ooo`03@000003oool0oooo00<0oooo00I000000?ooo`3ooom000000?oood00000D
0?ooo`009`3oool00`00001000000?ooo`0N0?ooo`A0000000@0oooo@000003ooom00000203oool4
03looa40oooo00=000000?oood0000000P3oool00d000000oooo@000000E0?ooo`@0?coo103oool0
0d000000oooo@00000020?ooo`03@000003ooom0000001`0oooo00M000000?ooo`3oool0oooo@000
003ooom000000080oooo00=000000?oood0000006@3oool00d000000oooo0?ooo`020?ooo`07@000
003oool0oooo0?oood000000oooo@000000I0?ooo`04@000003oool0oooo0?ooo`A0000000@0oooo
@000003ooom00000503oool002L0oooo00<000000?ooo`3oool07P3oool00d000000oooo@0000002
0?ooo`03@000003ooom0000000T0oooo0P0o?olB0?ooo`9000000`3oool00d000000oooo@000000F
0?ooo`80?coo1P3oool01d000000oooo0?ooo`3ooom000000?oood000000703oool01d000000oooo
0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000I0?ooo`03@000003oool0oooo
0080oooo00M000000?ooo`3oool0oooo@000003ooom0000001T0oooo00M000000?ooo`3oool0oooo
@000003ooom000000080oooo00=000000?oood000000503oool002L0oooo00<000000?ooo`3oool0
7`3oool2@0000080oooo00=000000?oood0000001`3oool403looa80oooo00=000000?ooo`3oool0
0P3oool00d000000oooo@000000M0?ooo`03@000003ooom000000080oooo00=000000?oood000000
703oool01d000000oooo0?ooo`3ooom000000?oood0000000P3oool00d000000oooo@000000I0?oo
o`07@000003oool0oooo0?oood000000oooo@00000020?ooo`03@000003ooom0000001T0oooo00=0
00000?ooo`3oool00P3oool2@0000080oooo00=000000?oood000000503oool002L0oooo00<00000
0?ooo`3oool0803oool01D000000oooo0?ooo`3ooom0000000P0oooo100o?olC0?ooo`9000000`3o
ool00d000000oooo0?ooo`0M0?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3oool06P3o
ool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`0G0?ooo`900000103o
ool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo01L0oooo0T0000050?ooo`05@000003o
ool0oooo0?oood0000005@3oool002L0oooo00<000000?ooo`3oool0;@3oool403loolD0oooo000W
0?ooo`03000004000000oooo02h0oooo0P0o?oo60?ooo`009`3oool00`000000oooo0?ooo`0/0?oo
o`@0?coo<@3oool403looi40oooo000W0?ooo`030000003oool0oooo02`0oooo100o?ola0?ooo`@0
?cooT@3oool002L0oooo00<0000003loo`0o?ol02`0o?olQ0?ooo`@0?coo<@3oool403loohD0oooo
1`0o?ol50?ooo`00903oool400000100?coo7`00000203looc<000000P0o?omf000001L0?coo1000
0001@00000009`3oool00`000000?coo03loo`0?03loo`03@000003oool0oooo00L0oooo00=00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`@0?coo1@3oool00d000000oooo0?ooo`07
0?ooo`03@000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00d000000oooo0?ooo`07
0?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`03@000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00=000000?ooo`3oool01P3oool00d000000oooo0?ooo`06
0?ooo`03@000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00d000000oooo0?ooo`0^
03loo`D0oooo000W0?ooo`030000003oool0?coo0100?coo4P3oool00d000000oooo0?ooo`060?oo
o`@0?coo603oool00d000000oooo0?ooo`0R0?ooo`03@000003oool0oooo02<0oooo00=000000?oo
o`3oool0803ooolh03loo`030?ooo`0o?ol0?coo00H0oooo000W0?ooo`030000003oool0oooo00T0
oooo200o?olJ0?ooo`@0?cooOP3oool`03loo`030?ooo`0o?ol0?coo0080?coo00@0oooo03loo`0o
?ol0oooo100o?ol<0?ooo`009`3oool00`000000oooo0?ooo`0;0?ooo`H0?coo6`3oool203loog/0
oooo8`0o?ol00`3oool0?coo03loo`0203loo`030?ooo`0o?ol0?coo00@0?coo00<0oooo03loo`0o
?ol06`3oool002L0oooo00<00000@000003oool0303oool603looe40oooo100o?om00?oooa<0?coo
00<0oooo03loo`0o?ol01P0o?olc0?ooo`009`3oool00`000000oooo0?ooo`0=0?ooo`D0?coo603o
ool403loocD0oooo100o?oll0?oooa<0?coo@03oool002L0oooo00<000000?ooo`3oool03P3oool5
03looaL0oooo100o?ole0?ooo`@0?coo>P3oool=03loodP0oooo000W0?ooo`030000003oool0oooo
00h0oooo1@0o?olG0?ooo`@0?coo=P3oool203loocT0oooo2`0o?om<0?ooo`009`3oool00`000010
00000?ooo`0?0?ooo`@0?coo603oool203loog00oooo2`0o?om>0?ooo`009`3oool00`000000oooo
0?ooo`0?0?ooo`D0?cooQ`3oool903looe80oooo000W0?ooo`030000003oool0oooo00l0oooo1@0o
?olF0?ooo`@0?cooK@3oool703looe@0oooo000W0?ooo`030000003oool0oooo0100oooo100o?olF
0?ooo`@0?cooJ`3oool703looeH0oooo000W0?ooo`030000003oool0oooo0100oooo1@0o?olE0?oo
o`@0?coo=P3oool403loobl0oooo1`0o?omH0?ooo`009`3oool00`00001000000?ooo`0@0?ooo`D0
?coo5P3oool203loocL0oooo100o?ol_0?ooo`H0?cooF@3oool002L0oooo00<000000?ooo`3oool0
4@3oool503loodh0oooo100o?ol]0?ooo`L0?cooFP3oool002L0oooo00<000000?ooo`3oool04P3o
ool403looa<0oooo100o?olh0?ooo`80?coo;P3oool503looe`0oooo000W0?ooo`030000003oool0
oooo0180oooo100o?olC0?ooo`@0?cooI`3oool503looed0oooo000W0?ooo`030000003oool0oooo
0180oooo100o?olC0?ooo`@0?cooI`3oool403looeh0oooo000W0?ooo`03000004000000oooo0180
oooo100o?olD0?ooo`80?cooIP3oool603looeh0oooo000W0?ooo`030000003oool0oooo01<0oooo
100o?om>0?ooo`@0?coo:@3oool503looel0oooo000=0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool00P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00E000000`3o
ool00`000000oooo0?ooo`0C0?ooo`@0?coo4@3oool403loocT0oooo100o?olW0?ooo`H0?cooH03o
ool000`0oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0
000000<0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`@0?coo4@3oool4
03loocT0oooo100o?olW0?ooo`D0?cooH@3oool000`0oooo00=000000?oood0000001`3oool00d00
0000oooo@00000020?ooo`03@000003ooom0000000<0oooo00=000000?ooo`3oool00`3oool00`00
001000000?ooo`0C0?ooo`@0?coo4@3oool403loocX0oooo0P0o?olV0?ooo`H0?cooHP3oool000`0
oooo00=000000?oood0000001`3oool00d000000oooo@00000020?ooo`03@000003ooom0000000<0
oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`D0?coo4@3oool203loof<0
oooo1@0o?omS0?ooo`00303oool00d000000oooo@00000070?ooo`03@000003ooom000000080oooo
00=000000?oood0000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo01@0oooo
100o?omd0?ooo`H0?cooI03oool000d0oooo00=000000?ooo`3oool01`3oool00d000000oooo0?oo
o`020?ooo`04@000003oool0oooo0?ooo`9000001@3oool00`000000oooo0?ooo`0D0?ooo`@0?coo
3`3oool403loof40oooo1@0o?omU0?ooo`009`3oool00`000000oooo0?ooo`0E0?ooo`@0?coo3P3o
ool403looc`0oooo100o?olQ0?ooo`@0?cooIP3oool002L0oooo00<00000@000003oool05@3oool4
03loo`h0oooo100o?oll0?ooo`@0?coo803oool403loofL0oooo000W0?ooo`030000003oool0oooo
01D0oooo100o?ol?0?ooo`80?coo?@3oool403loob00oooo100o?omW0?ooo`009`3oool00`000000
oooo0?ooo`0E0?ooo`@0?cooC`3oool203looal0oooo1P0o?omW0?ooo`009`3oool00`000000oooo
0?ooo`0E0?ooo`@0?coo3@3oool403looel0oooo1@0o?omX0?ooo`009`3oool00`000000oooo0?oo
o`0E0?ooo`D0?coo303oool403looel0oooo100o?omY0?ooo`009`3oool00`00001000000?ooo`0F
0?ooo`@0?coo303oool403looch0oooo100o?olK0?ooo`D0?cooJP3oool002L0oooo00<000000?oo
o`3oool05P3oool403loo`d0oooo0P0o?olo0?ooo`@0?coo6`3oool403loof/0oooo000W0?ooo`03
0000003oool0oooo01H0oooo100o?om>0?ooo`@0?coo6`3oool403loof/0oooo000W0?ooo`030000
003oool0oooo01H0oooo100o?ol<0?ooo`@0?coo?`3oool203looa/0oooo100o?om/0?ooo`009`3o
ool00`00001000000?ooo`0F0?ooo`@0?coo303oool403looe`0oooo100o?om/0?ooo`009`3oool0
0`000000oooo0?ooo`0G0?ooo`@0?coo2`3oool403lood00oooo100o?olF0?ooo`H0?cooK03oool0
02L0oooo00<000000?ooo`3oool05`3oool403loo``0oooo0P0o?om10?ooo`@0?coo5P3oool503lo
ofd0oooo000W0?ooo`030000003oool0oooo01L0oooo100o?ol:0?ooo`@0?coo@@3oool403looaH0
oooo100o?om^0?ooo`009`3oool00`000000oooo0?ooo`0H0?ooo`@0?coo2@3oool403lood80oooo
0P0o?olE0?ooo`D0?cooK`3oool002L0oooo00<00000@000003oool0603oool403loo`T0oooo100o
?omI0?ooo`@0?cooL03oool002L0oooo00<000000?ooo`3oool0603oool403loo`X0oooo0P0o?om3
0?ooo`@0?coo4`3oool403loog00oooo000W0?ooo`030000003oool0oooo01P0oooo100o?ol80?oo
o`@0?coo@`3oool403looa80oooo100o?oma0?ooo`003@3oool00d000000oooo0?ooo`020?ooo`03
@000003oool0oooo0080oooo00=000000?ooo`3oool00P3oool014000000oooo0?ooo`3oool3@000
00@0oooo00<000000?ooo`3oool0603oool403loo`P0oooo100o?om30?ooo`@0?coo4P3oool403lo
og40oooo000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000
oooo@00000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool503loo`L0
oooo100o?om40?ooo`80?coo4@3oool603loog40oooo000<0?ooo`03@000003ooom0000000L0oooo
00=000000?oood0000000P3oool00d000000oooo@00000030?ooo`03@000003oool0oooo00<0oooo
00<00000@000003oool06@3oool403loo`P0oooo0P0o?om60?ooo`@0?coo3P3oool503loog80oooo
000<0?ooo`03@000003ooom0000000L0oooo00=000000?oood0000000P3oool00d000000oooo@000
00030?ooo`03@000003oool0oooo00<0oooo00<000000?ooo`3oool06@3oool403loo`H0oooo100o
?om60?ooo`@0?coo3P3oool403loog<0oooo000<0?ooo`03@000003ooom0000000L0oooo00=00000
0?oood0000000P3oool00d000000oooo@00000020?ooo`03@000003ooom0000000@0oooo00<00000
0?ooo`3oool06P3oool403loo`D0oooo100o?om60?ooo`@0?coo303oool503loog@0oooo000=0?oo
o`03@000003oool0oooo00L0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`020?oo
o`03@000003oool0oooo00<0oooo00<000000?ooo`3oool06P3oool403loo`D0oooo100o?om70?oo
o`@0?coo2`3oool403loogD0oooo000W0?ooo`03000004000000oooo01X0oooo100o?ol50?ooo`@0
?cooA`3oool403loo`X0oooo1@0o?ome0?ooo`009`3oool00`000000oooo0?ooo`0J0?ooo`@0?coo
1@3oool403loodL0oooo100o?ol:0?ooo`@0?cooMP3oool002L0oooo00<000000?ooo`3oool06P3o
ool403loo`D0oooo100o?om80?ooo`@0?coo1`3oool603loogH0oooo000W0?ooo`030000003oool0
oooo01/0oooo100o?ol30?ooo`@0?cooB@3oool403loo`H0oooo1P0o?omg0?ooo`009`3oool00`00
0000oooo0?ooo`0K0?ooo`@0?coo0`3oool403loodT0oooo1P0o?ol20?ooo`L0?cooN03oool002L0
oooo00<00000@000003oool06`3oool503loo`030?ooo`0o?ol0?coo00<0?cooBP3oool=03loogT0
oooo000W0?ooo`030000003oool0oooo01`0oooo100o?ol00`3oool0?coo03loo`0203lood`0oooo
2`0o?omj0?ooo`009`3oool00`000000oooo0?ooo`0L0?ooo`T0?cooC@3oool803loog`0oooo000W
0?ooo`030000003oool0oooo01`0oooo200o?om?0?ooo`D0?cooOP3oool002L0oooo00<000000?oo
o`3oool07@3oool703loom80oooo000W0?ooo`03000004000000oooo01h0oooo1P0o?ooB0?ooo`00
9`3oool00`000000oooo0?ooo`0N0?ooo`D0?cood`3oool002L0oooo00<000000?ooo`3oool07`3o
ool203loomD0oooo000W0?ooo`03@000003oool0oooo0?H0oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.02604, -0.00437857, 
  0.537371, 4.30889*^-05}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{463, 319},
WindowMargins->{{30, Automatic}, {Automatic, 20}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 54, 0, 30, "Input"],
Cell[1766, 51, 124, 4, 71, "Text"],
Cell[1893, 57, 1413, 56, 1074, "Input"],
Cell[3309, 115, 44, 0, 33, "Text"],
Cell[3356, 117, 122, 12, 210, "Input"],
Cell[3481, 131, 47, 0, 33, "Text"],
Cell[3531, 133, 73, 0, 30, "Input"],
Cell[3607, 135, 68, 0, 30, "Input"],
Cell[3678, 137, 50, 0, 33, "Text"],
Cell[3731, 139, 141, 3, 66, "Input"],
Cell[3875, 144, 34, 0, 33, "Text"],
Cell[3912, 146, 64, 0, 30, "Input"],
Cell[3979, 148, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4028, 152, 473, 12, 246, "Input"],
Cell[4504, 166, 30707, 835, 214, 9332, 567, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[35226, 1004, 183, 3, 52, "Text"],
Cell[35412, 1009, 131, 3, 66, "Input"],
Cell[35546, 1014, 42, 0, 33, "Text"],
Cell[35591, 1016, 131, 3, 48, "Input"],
Cell[35725, 1021, 62, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[35812, 1025, 178, 5, 102, "Input"],
Cell[35993, 1032, 24535, 673, 186, 7286, 456, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

