(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63792,       1688]*)
(*NotebookOutlinePosition[     64487,       1713]*)
(*  CellTagsIndexPosition[     64443,       1709]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<c:\\math\\kniz\\options\\optvalue.m", "Input"],

Cell["\<\
PSOR[V_,ps_,g_,a_,b_,c_,m_,eps_,omega_]:=
Module[{error},
error=1;
While
   [error>eps*eps,
    error=0.0;
    V[-m]=g[-m];
    V[m]=g[m];
    
    For[i=-m+1,i<m,i++,
        y= (ps[i]-a*V[i-1]-c*V[i+1])/b;
        y= Max[g[i],V[i]+omega*(y-V[i])];
        error += (y - V[i])^2;
        V[i]= y;];
    
   ];
]       \
\>", "Input"],

Cell["\<\
AmericanCall[X_,sigma_,r_,D_,t_,m_,n_,trans_,time_,eps_]:=
Module[{},

xright=Log[Slarge/X];
c1=N[r/(0.5*sigma^2)];
c2=N[(r-D)/(0.5*sigma^2)];
c3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
c4=N[0.25*(c1^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

TransfCallPayoff[x_,tau_]:=N[Exp[(0.25*(c2-1)^2+c1)*tau]*Max[0,Exp[0.5*(c2+1)*\
x]-Exp[0.5*(c2-1)*x]]];

Do[u[i,0]=TransfCallPayoff[i*h,0],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[  g[i]=TransfCallPayoff[i*h,j*k];
      der1=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      der2=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
 ps[i]=N[u[i,j-1]-c3*k*Abs[c4*u[i,j-1]-c2*der1+der2]],{i,-m+1,m-1}];

 g[-m] =0;
 g[m]  =Max[TransfCallPayoff[m*h,j*k],
           Exp[0.5*(c2+1)*xright+0.25*(c2+1)^2*k*j]-
           Exp[0.5*(c2-1)*xright+0.25*(c2-1)^2*k*j]];

 Do[V[i]=Max[g[i],u[i,j-1]],{i,-m+1,m-1}];
 
 PSOR[V,ps,g,a,b,c,m,eps,omega]; 
  
 Do[u[i,j]=V[i],{i,-m,m}];  

 xs=Table[X*Exp[i*h],{i,-m,m}];
 ys=Table[X*Exp[-0.5*(c2-1)*i*h-(0.25*(c2-1)^2+c1)*j*k]*u[i,j],{i,-m,m}];
 graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
 {j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.1;
t=0.6;
m=10;
n=10;
Slarge=150;
trans=0.0;
time=0.03;
eps=0.0001;
omega=1.6;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["AmericanCall[X,sigma,r,DD,t,m,n,trans,time,eps]", "Input"],

Cell["\"Defin\[IAcute]cia payoff diagramu.\"", "Text"],

Cell["PayoffCall[S_]:=Max[S-X,0];", "Input"],

Cell["\"Graf\"", "Text"],

Cell["\<\
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.017],RGBColor[0.25,0.25,1]},\
DisplayFunction->Identity];
g2=Plot[PayoffCall[S],{S,0,150},PlotStyle->{Thickness[0.007]},PlotRange->All, \
DisplayFunction->Identity];
g3=Plot[EuropeanCallDiv[S,X,sigma,r,DD,t],{S,0,150},PlotStyle->RGBColor[0,1,0]\
,PlotRange->All, DisplayFunction->Identity];
\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
Show[g2,g1,g3,AxesLabel->{\"CENA AKCIE\",\"CENA \
OPCIE\"},DisplayFunction->$DisplayFunction,PlotRange->{{20,120},{0,60}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.2 0.01 0 0.0103006 [
[.2 -0.0125 -6 -9 ]
[.2 -0.0125 6 0 ]
[.4 -0.0125 -6 -9 ]
[.4 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 65 7.5 ]
[-0.0125 .10301 -12 -4.5 ]
[-0.0125 .10301 0 4.5 ]
[-0.0125 .20601 -12 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .41202 -12 -4.5 ]
[-0.0125 .41202 0 4.5 ]
[-0.0125 .51503 -12 -4.5 ]
[-0.0125 .51503 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -32.5 0 ]
[0 .64303 32.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2 0 m
.2 .00625 L
s
[(40)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(60)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(80)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(100)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(120)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.437500 14.437500 moveto
(AKCIE) show
123.437500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .10301 m
.00625 .10301 L
s
[(10)] -0.0125 .10301 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(20)] -0.0125 .20601 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(30)] -0.0125 .30902 1 0 Mshowa
0 .41202 m
.00625 .41202 L
s
[(40)] -0.0125 .41202 1 0 Mshowa
0 .51503 m
.00625 .51503 L
s
[(50)] -0.0125 .51503 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(60)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0206 m
.00375 .0206 L
s
0 .0412 m
.00375 .0412 L
s
0 .0618 m
.00375 .0618 L
s
0 .0824 m
.00375 .0824 L
s
0 .12361 m
.00375 .12361 L
s
0 .14421 m
.00375 .14421 L
s
0 .16481 m
.00375 .16481 L
s
0 .18541 m
.00375 .18541 L
s
0 .22661 m
.00375 .22661 L
s
0 .24721 m
.00375 .24721 L
s
0 .26781 m
.00375 .26781 L
s
0 .28842 m
.00375 .28842 L
s
0 .32962 m
.00375 .32962 L
s
0 .35022 m
.00375 .35022 L
s
0 .37082 m
.00375 .37082 L
s
0 .39142 m
.00375 .39142 L
s
0 .43262 m
.00375 .43262 L
s
0 .45322 m
.00375 .45322 L
s
0 .47383 m
.00375 .47383 L
s
0 .49443 m
.00375 .49443 L
s
0 .53563 m
.00375 .53563 L
s
0 .55623 m
.00375 .55623 L
s
0 .57683 m
.00375 .57683 L
s
0 .59743 m
.00375 .59743 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -93.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(CENA) show
93.250000 14.437500 moveto
(OPCIE) show
123.250000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.007 w
.04948 0 m
.11328 0 L
.17469 0 L
.23997 0 L
.30286 0 L
.36336 0 L
.37949 0 L
.38738 0 L
.3946 0 L
.39647 0 L
.3985 0 L
.40042 .00043 L
.4022 .00226 L
.41037 .01068 L
.42773 .02856 L
.48936 .09204 L
.55485 .1595 L
.61795 .2245 L
.67867 .28705 L
.74325 .35357 L
.80544 .41763 L
.86525 .47923 L
.92892 .54481 L
.9902 .60794 L
s
.9902 .60794 m
1 .61803 L
s
.25 .25 1 r
.017 w
.04 0 Mdot
.06303 1e-005 Mdot
.08827 2e-005 Mdot
.11593 8e-005 Mdot
.14625 .00023 Mdot
.17947 .00065 Mdot
.21589 .00175 Mdot
.25579 .00438 Mdot
.29953 .01029 Mdot
.34747 .02211 Mdot
.4 .04359 Mdot
.45757 .07821 Mdot
.52067 .12836 Mdot
.58983 .19553 Mdot
.66562 .2736 Mdot
.74868 .35916 Mdot
.83972 .45293 Mdot
.93949 .5557 Mdot
0 1 0 r
.5 Mabswid
0 0 m
.00095 0 L
.0031 0 L
.0051 0 L
.00843 0 L
.0102 0 L
.01209 0 L
.01408 0 L
.01596 0 L
.01949 0 L
.02135 0 L
.02342 0 L
.02543 0 L
.0276 0 L
.03147 0 L
.03511 0 L
.03942 0 L
.0416 0 L
.04397 0 L
.04819 0 L
.05211 0 L
.05624 0 L
.06005 0 L
.06423 0 L
.06866 0 L
.0725 0 L
.0761 0 L
.08005 0 L
.08429 1e-005 L
.08804 1e-005 L
.09213 1e-005 L
.09574 1e-005 L
.09958 1e-005 L
.10683 2e-005 L
.11356 3e-005 L
.122 5e-005 L
.12977 7e-005 L
.1383 .0001 L
.1473 .00015 L
.15514 .00021 L
.16246 .00028 L
.17048 .00037 L
.17908 .00051 L
.18741 .00067 L
.19512 .00087 L
.20341 .00112 L
.21256 .00146 L
.22793 .00223 L
.24426 .00336 L
.26017 .00484 L
Mistroke
.27475 .00658 L
.29178 .00916 L
.30761 .01214 L
.33743 .01949 L
.37005 .03034 L
.43157 .05915 L
.49696 .10072 L
.55997 .14906 L
.62058 .20076 L
.68506 .25921 L
.74715 .31741 L
.80686 .37433 L
.87042 .43547 L
.9316 .49457 L
.99664 .55755 L
Mfstroke
.99664 .55755 m
1 .5608 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{350.563, 216.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N0000f2000`400?l00000o`00003oo`3ooomO
0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO
0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO
0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO
0?ooo`00CP3oool3@0000080oooo00=000000?ooo`3oool0:03oool2@00000@0oooo00=000000?oo
o`3oool0:P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02@0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool08P3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool0@@3oool004l0oooo00I000000?ooo`3ooom000000?oood00
000Y0?ooo`03@000003ooom000000080oooo00=000000?oood000000:P3oool00d000000oooo@000
00020?ooo`03@000003ooom0000002L0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood0000009@3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od000000@P3oool004d0oooo14000000103ooom000000?oood00000Y0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000:P3oool00d000000oooo@00000020?ooo`03@000003ooom00000
02L0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood0000009@3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@00000120?ooo`00
C@3oool00d000000oooo@00000020?ooo`03@000003ooom0000002T0oooo0T0000030?ooo`03@000
003ooom0000002/0oooo00M000000?ooo`3oool0oooo@000003ooom0000002L0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood0000009@3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@00000120?ooo`00CP3oool2@0000080oooo
00=000000?oood000000:@3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000002X0oooo
00=000000?oood0000000P3oool00d000000oooo@000000W0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000002D0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood000000@P3oool004l0oooo00E000000?ooo`3oool0oooo@000
000[0?ooo`9000000`3oool00d000000oooo0?ooo`0Z0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool09@3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0S0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0440oooo003o
0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?ooob40oooo0T0000000`3ooom00000
@0000006@00000050?oood0000100000@000003oool00T00000;0?ooo`90000000<0oooo@0000400
00000T0000000`3ooom00000@00000020?ooo`9000000P3oool3@00000030?oood000010000000=0
0000203oool00?l0oooo803oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo@000003o
oom000000?ooo`03@00000<0oooo00=000000?ooo`3oool02@3oool02D000000oooo0?ooo`3ooom0
00000?oood000000oooo@00000020?ooo`03@000003oool0oooo00<0oooo00E000000?ooo`3oool0
oooo@00000020?ooo`03@000003oool0oooo00H0oooo000P0?oooc<00?l000@0000003loo`0o?ol0
?coo_`0000000d000000oooo0?ooo`060?ooo`03@000003oool0oooo0080oooo00=000000?ooo`3o
ool00P3oool01D000000oooo@00004000000oooo00=000003@3oool3@0000080oooo0d0000020?oo
o`03@000003oool0oooo00<0oooo00E000000?ooo`3oool0oooo@000000;0?ooo`00803oool00`00
0000oooo0?ooo`050?ooo`<0?coo00<0oooo@000003oool00`0o?ol30?ooo`<0?coo0P3oool00d00
0000oooo03loo`0203loo`@0oooo0`0o?ol00d000000oooo0?ooo`030?ooo`<0?coo0`3oool00`00
0000oooo003o000>003o00P0oooo00=000000?ooo`3oool02@3oool00d000000oooo0?ooo`090?oo
o`8000002`3oool00d000000oooo0?ooo`090?ooo`03@000003oool0oooo00T0oooo00=000000?oo
o`3oool02P3oool00`000000oooo0?ooo`090?ooo`03@000003oool0oooo00T0oooo00=000000?oo
o`3oool02@3oool00d000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00=000000?oo
o`3oool02@3oool00d000000oooo0?ooo`0:0?ooo`03@000003oool0oooo00T0oooo00<000000?oo
o`3oool01P3oool00d000000oooo0?ooo`020?ooo`9000000`3oool2@00000060?oood000000oooo
@000003ooom000003@3oool00d000000oooo@00000020?ooo`9000000`3oool00d000000oooo0?oo
o`030?ooo`04@000003oool0oooo0?ooo`9000002P3oool00200oooo00<000000?ooo`3oool01P3o
ool00`0o?ol0oooo0?ooo`030?ooo`0303loo`3oool0oooo00<0oooo00<0?coo0?ooo`3oool0103o
ool00`0o?ol0oooo0?ooo`040?ooo`0303loo`3oool0oooo00H0oooo00<0?coo0?ooo`3oool00P3o
ool01D000000oooo0?ooo`3oool0?coo00L0oooo0`0o?ol20?ooo`P00?l000<0?coo0?ooo`3oool0
5@3oool00d000000oooo0000000_0?ooo`03@000003oool0oooo02h0oooo00=000000?ooo`3oool0
;P3oool00d000000oooo0?ooo`060?ooo`03@000003ooom000000080oooo00E000000?ooo`3ooom0
00000?ooo`02@00000050?oood000000oooo0?oood0000003`3oool01d000000oooo0?ooo`3ooom0
00000?oood0000000P3oool00d000000oooo@00000030?ooo`05@000003oool0oooo0?oood000000
0P3oool00d000000oooo0?ooo`060?ooo`00803oool00`000000oooo0?ooo`0k0?ooo`0303loo`3o
ool0oooo00L0oooo0P0o?ol4003o01L0oooo00<000000?ooo`3oool0U`3oool3@00000030?oood00
0010000000E0000000@0oooo@00004000000oooo0T00000>0?ooo`9000000P3oool2@00000040?oo
od00001000000?ooo`=000000P3oool3@00000030?oood000010000000=00000203oool00200oooo
00<000000?ooo`3oool0AP3oool00`0o?ol0oooo0?ooo`020?ooo`@00?l0503oool00`000000oooo
0?ooo`3E0?ooo`00803oool00`00001000000?ooo`1?0?ooo`<00?l00P0o?ol@0?ooo`030000003o
ool0oooo0=@0oooo000P0?ooo`030000003oool0oooo0540oooo00<0?coo003o0000o`004@3oool0
0`000000oooo0?ooo`3C0?ooo`00803oool00`000000oooo0?ooo`1B0?ooo`0303loo`3oool00?l0
00800?l03`3oool00`000000oooo0?ooo`3B0?ooo`00803oool00`000000oooo0?ooo`1G0?ooo`<0
0?l03@3oool00`000000oooo0?ooo`3A0?ooo`00803oool00`000000oooo0?ooo`1J0?ooo`800?l0
303oool00`000000oooo0?ooo`3@0?ooo`00803oool00`00001000000?ooo`1L0?ooo`800?l00`0o
?ol80?ooo`030000003oool0oooo0<l0oooo000P0?ooo`030000003oool0oooo05h0oooo0P00o`00
0`0o?ol0oooo0?ooo`070?ooo`030000003oool0oooo0<h0oooo000P0?ooo`030000003oool0oooo
05l0oooo00<0?coo003o0000o`002@3oool00`000000oooo0?ooo`3=0?ooo`00803oool00`000000
oooo0?ooo`1R0?ooo`800?l0203oool00`000000oooo0?ooo`3<0?ooo`00803oool00`000000oooo
0?ooo`1T0?ooo`800?l01`3oool00`000000oooo0?ooo`3;0?ooo`00803oool00`00001000000?oo
o`1V0?ooo`800?l01P3oool00`000000oooo0?ooo`3:0?ooo`00803oool00`000000oooo0?ooo`1X
0?ooo`800?l0103oool00`000000oooo0?ooo`3:0?ooo`00803oool00`000000oooo0?ooo`1Z0?oo
o`03003o003oool0oooo0080oooo00<000000?ooo`3oool0b@3oool00200oooo00<000000?ooo`3o
ool0J`3oool2003o00<0oooo00<000000?ooo`3oool0b03oool00200oooo00<000000?ooo`3oool0
K03oool00`0o?ol00?l0003o00020?ooo`030000003oool0oooo0<L0oooo000P0?ooo`0300000400
0000oooo06`0oooo0`0o?ol01000o`00oooo0?ooo`0000380?ooo`00803oool00`000000oooo0?oo
o`1]0?ooo`0303loo`3oool0oooo00800?l000<0oooo0000003oool0aP3oool00200oooo00<00000
0?ooo`3oool0LP3oool00`00o`00oooo000000360?ooo`00803oool00`000000oooo0?ooo`1c0?oo
o`800?l000<000000?ooo`3oool0``3oool001<0oooo1D0000020?ooo`03@000003oool0oooo00<0
oooo00<000000?ooo`3oool0M@3oool2003o0<@0oooo000E0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000040?ooo`030000003oool0oooo07L0oooo00<00?l00?ooo`3oool0`@3oool001D0
oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo0P0000000d000000oooo0?ooo`1f
0?ooo`03003o003oool0oooo0<00oooo000E0?ooo`07@000003oool0oooo0?oood000000oooo@000
00040?ooo`030000003oool0oooo07T0oooo0P00o`300?ooo`005@3oool01d000000oooo0?ooo`3o
oom000000?oood000000103oool00`000000oooo0?ooo`1j0?ooo`0300000000o`00oooo0;h0oooo
000D0?ooo`900000103oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo07/0oooo00<0
0000003o003oool0_@3oool00200oooo00<000000?ooo`3oool0O03oool00`0000000?l0003o002l
0?ooo`00803oool00`00001000000?ooo`1k0?ooo`<0?coo00<0oooo003o003oool0^P3oool00200
oooo00<000000?ooo`3oool0N`3oool303loo`030000003oool00?l00;X0oooo000P0?ooo`030000
003oool0oooo07`0oooo00D0?coo0?ooo`3oool000000?ooo`02003o0;P0oooo000P0?ooo`030000
003oool0oooo0800oooo00@000000?ooo`3oool00?l0]`3oool00200oooo00<000000?ooo`3oool0
P@3oool010000000oooo0?ooo`00o`2f0?ooo`00803oool00`00001000000?ooo`220?ooo`030000
003oool0oooo00800?l0]03oool00200oooo00<000000?ooo`3oool0P`3oool01@000000oooo0?oo
o`3oool00?l00;<0oooo000P0?ooo`030000003oool0oooo08@0oooo00D000000?ooo`3oool0oooo
003o002b0?ooo`00803oool00`000000oooo0?ooo`250?ooo`050000003oool0oooo0?ooo`00o`00
/@3oool00200oooo00<000000?ooo`3oool0QP3oool010000000oooo0?ooo`3oool2003o0:l0oooo
000P0?ooo`03000004000000oooo08L0oooo00<000000?ooo`3oool00P3oool00`00o`00oooo0?oo
o`2/0?ooo`00803oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0080oooo00<00?l0
0?ooo`3oool0Z`3oool00200oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`020?oo
o`03003o003oool0oooo0:X0oooo000P0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3o
ool00P3oool00`00o`00oooo0?ooo`2Y0?ooo`00803oool00`000000oooo0?ooo`2;0?ooo`030000
003oool0oooo0080oooo00<00?l00?ooo`3oool0Z03oool00200oooo00<00000@000003oool0S03o
ool00`000000oooo0?ooo`020?ooo`03003o003oool0oooo0:L0oooo000P0?ooo`030000003oool0
oooo08d0oooo00<000000?ooo`3oool00P3oool2003o0:L0oooo000P0?ooo`030000003oool0oooo
08`0oooo0`0o?ol50?ooo`03003o003oool0oooo0:@0oooo000D0?ooo`=000000`3oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo08`0oooo0`0o?ol00`000000oooo0?ooo`030?ooo`03
003o003oool0oooo0:<0oooo000D0?ooo`03@000003oool0oooo0080oooo00=000000?oood000000
103oool00`000000oooo0?ooo`2=0?ooo`0403loo`3oool0oooo000000D0oooo00<00?l00?ooo`3o
ool0XP3oool001D0oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo0P0000000d00
0000oooo0?ooo`2?0?ooo`030000003oool0oooo00<0oooo00<00?l00?ooo`3oool0X@3oool001D0
oooo00M000000?ooo`3oool0oooo@000003ooom0000000@0oooo00<000000?ooo`3oool0TP3oool0
0`000000oooo0?ooo`030?ooo`03003o003oool0oooo0:00oooo000D0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000103oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo
00<0oooo00<00?l00?ooo`3oool0W`3oool001D0oooo00=000000?ooo`3oool00P3oool00d000000
oooo0?ooo`030?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool00`3oool00`00o`00
oooo0?ooo`2N0?ooo`00803oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo00<0oooo
00<00?l00?ooo`3oool0W@3oool00200oooo00<00000@000003oool0UP3oool00`000000oooo0?oo
o`030?ooo`03003o003oool0oooo09`0oooo000P0?ooo`030000003oool0oooo09L0oooo00<00000
0?ooo`3oool00`3oool2003o09`0oooo000P0?ooo`030000003oool0oooo09P0oooo00<000000?oo
o`3oool0103oool00`00o`00oooo0?ooo`2I0?ooo`00803oool00`000000oooo0?ooo`2I0?ooo`03
0000003oool0oooo00@0oooo00<00?l00?ooo`3oool0V03oool00200oooo00<000000?ooo`3oool0
VP3oool00`000000oooo0?ooo`040?ooo`03003o003oool0oooo09L0oooo000P0?ooo`0300000400
0000oooo09/0oooo00<000000?ooo`3oool0103oool00`00o`00oooo0?ooo`2F0?ooo`00803oool0
0`000000oooo0?ooo`2L0?ooo`030000003oool0oooo00@0oooo00<00?l00?ooo`3oool0U@3oool0
0200oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?ooo`040?ooo`03003o003oool0oooo
09@0oooo000P0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3oool01@3oool00`00o`00
oooo0?ooo`2C0?ooo`00803oool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo00D0oooo
00<00?l00?ooo`3oool0TP3oool00200oooo00<00000@000003oool0W`3oool00`000000oooo0?oo
o`050?ooo`03003o003oool0oooo0940oooo000P0?ooo`030000003oool0oooo09l0oooo0`0o?ol6
0?ooo`03003o003oool0oooo0900oooo000P0?ooo`030000003oool0oooo09l0oooo0`0o?ol70?oo
o`800?l0T03oool00200oooo00<000000?ooo`3oool0X03oool00`0o?ol0oooo000000080?ooo`03
003o003oool0oooo08d0oooo000P0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0
1P3oool00`00o`00oooo0?ooo`2<0?ooo`00803oool00`00001000000?ooo`2T0?ooo`030000003o
ool0oooo00H0oooo00<00?l00?ooo`3oool0R`3oool00200oooo00<000000?ooo`3oool0Y@3oool0
0`000000oooo0?ooo`060?ooo`03003o003oool0oooo08X0oooo000P0?ooo`030000003oool0oooo
0:H0oooo00<000000?ooo`3oool01P3oool00`00o`00oooo0?ooo`290?ooo`00503oool2@00000@0
oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo00H0
oooo00<00?l00?ooo`3oool0R03oool001H0oooo00I000000?ooo`3ooom000000?oood0000040?oo
o`030000003oool0oooo0:P0oooo00<000000?ooo`3oool01P3oool2003o08P0oooo000E0?ooo`07
@000003oool0oooo0?oood000000oooo@00000040?ooo`80000000=000000?ooo`3oool0Y`3oool0
0`000000oooo0?ooo`070?ooo`03003o003oool0oooo08D0oooo000F0?ooo`06@000003oool0oooo
@000003ooom00000103oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo00L0oooo00<0
0?l00?ooo`3oool0Q03oool001@0oooo00=000000?oood0000000P3oool00d000000oooo@0000004
0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool01`3oool00`00o`00oooo0?ooo`23
0?ooo`005@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00<0oooo00<000000?oo
o`3oool0[03oool00`000000oooo0?ooo`070?ooo`03003o003oool0oooo0880oooo000P0?ooo`03
0000003oool0oooo0:d0oooo00<000000?ooo`3oool01`3oool00`00o`00oooo0?ooo`210?ooo`00
803oool00`00001000000?ooo`2^0?ooo`030000003oool0oooo00L0oooo00<00?l00?ooo`3oool0
P03oool00200oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`070?ooo`03003o003o
ool0oooo07l0oooo000P0?ooo`030000003oool0oooo0;00oooo00<000000?ooo`3oool01`3oool0
0`00o`00oooo0?ooo`1n0?ooo`00803oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo
00L0oooo00<00?l00?ooo`3oool0O@3oool00200oooo00<000000?ooo`3oool0/P3oool00`000000
oooo0?ooo`070?ooo`03003o003oool0oooo07`0oooo000P0?ooo`03000004000000oooo0;<0oooo
00<000000?ooo`3oool01`3oool00`00o`00oooo0?ooo`1k0?ooo`00803oool00`000000oooo0?oo
o`2d0?ooo`030000003oool0oooo00L0oooo00<00?l00?ooo`3oool0NP3oool00200oooo00<00000
0?ooo`3oool0]03oool303loo`P0oooo00<00?l00?ooo`3oool0N@3oool00200oooo00<000000?oo
o`3oool0]03oool303loo`T0oooo00<00?l00?ooo`3oool0N03oool00200oooo00<000000?ooo`3o
ool0]@3oool00`0o?ol0oooo000000090?ooo`03003o003oool0oooo07L0oooo000P0?ooo`030000
04000000oooo0;P0oooo00<000000?ooo`3oool01`3oool00`00o`00oooo0?ooo`1f0?ooo`00803o
ool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo00L0oooo00<00?l00?ooo`3oool0M@3o
ool00200oooo00<000000?ooo`3oool0^P3oool00`000000oooo0?ooo`070?ooo`03003o003oool0
oooo07@0oooo000P0?ooo`030000003oool0oooo0;/0oooo00<000000?ooo`3oool01`3oool00`00
o`00oooo0?ooo`1c0?ooo`00803oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo00L0
oooo00<00?l00?ooo`3oool0LP3oool00200oooo00<00000@000003oool0_03oool00`000000oooo
0?ooo`080?ooo`03003o003oool0oooo0740oooo000P0?ooo`030000003oool0oooo0;d0oooo00<0
00000?ooo`3oool0203oool00`00o`00oooo0?ooo`1`0?ooo`00803oool00`000000oooo0?ooo`2n
0?ooo`030000003oool0oooo00P0oooo00<00?l00?ooo`3oool0K`3oool00200oooo00<000000?oo
o`3oool0_`3oool00`000000oooo0?ooo`080?ooo`03003o003oool0oooo06h0oooo000E0?ooo`=0
00000P3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3o
ool0203oool2003o06h0oooo000F0?ooo`06@000003oool0oooo@000003ooom00000103oool00`00
0000oooo0?ooo`310?ooo`030000003oool0oooo00T0oooo00<00?l00?ooo`3oool0J`3oool001@0
oooo14000000103ooom000000?oood0000040?ooo`80000000=000000?ooo`3oool0`03oool00`00
0000oooo0?ooo`090?ooo`03003o003oool0oooo06X0oooo000D0?ooo`03@000003ooom000000080
oooo00=000000?oood000000103oool00`000000oooo0?ooo`330?ooo`030000003oool0oooo00T0
oooo00<00?l00?ooo`3oool0J@3oool001D0oooo0T0000020?ooo`03@000003ooom0000000@0oooo
00<000000?ooo`3oool0a03oool00`000000oooo0?ooo`090?ooo`03003o003oool0oooo06P0oooo
000F0?ooo`05@000003oool0oooo0?oood0000001@3oool00`000000oooo0?ooo`350?ooo`030000
003oool0oooo00T0oooo00<00?l00?ooo`3oool0I`3oool00200oooo00<000000?ooo`3oool0aP3o
ool00`000000oooo0?ooo`090?ooo`03003o003oool0oooo06H0oooo000P0?ooo`03000004000000
oooo0<L0oooo00<000000?ooo`3oool02@3oool00`00o`00oooo0?ooo`1U0?ooo`00803oool00`00
0000oooo0?ooo`380?ooo`030000003oool0oooo00T0oooo00<00?l00?ooo`3oool0I03oool00200
oooo00<000000?ooo`3oool0b@3oool00`000000oooo0?ooo`090?ooo`03003o003oool0oooo06<0
oooo000P0?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`3oool02@3oool00`00o`00oooo
0?ooo`1R0?ooo`00803oool00`000000oooo0?ooo`3:0?ooo`<0?coo2P3oool00`00o`00oooo0?oo
o`1Q0?ooo`00803oool00`00001000000?ooo`3:0?ooo`<0?coo2`3oool00`00o`00oooo0?ooo`1P
0?ooo`00803oool00`000000oooo0?ooo`3;0?ooo`0303loo`3oool0000000/0oooo00<00?l00?oo
o`3oool0G`3oool00200oooo00<000000?ooo`3oool0cP3oool00`000000oooo0?ooo`090?ooo`03
003o003oool0oooo05h0oooo000P0?ooo`030000003oool0oooo0<l0oooo00<000000?ooo`3oool0
2@3oool00`00o`00oooo0?ooo`1M0?ooo`00803oool00`000000oooo0?ooo`3@0?ooo`030000003o
ool0oooo00T0oooo00<00?l00?ooo`3oool0G03oool00200oooo00<00000@000003oool0d@3oool0
0`000000oooo0?ooo`090?ooo`03003o003oool0oooo05/0oooo000P0?ooo`030000003oool0oooo
0=80oooo00<000000?ooo`3oool02@3oool00`00o`00oooo0?ooo`1J0?ooo`00803oool00`000000
oooo0?ooo`3C0?ooo`030000003oool0oooo00T0oooo00<00?l00?ooo`3oool0F@3oool00200oooo
00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`090?ooo`03003o003oool0oooo05P0oooo
000P0?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool02@3oool00`00o`00oooo0?oo
o`1G0?ooo`00803oool00`00001000000?ooo`3F0?ooo`030000003oool0oooo00T0oooo00<00?l0
0?ooo`3oool0EP3oool00200oooo00<000000?ooo`3oool0e`3oool00`000000oooo0?ooo`090?oo
o`03003o003oool0oooo05D0oooo000P0?ooo`030000003oool0oooo0=P0oooo00<000000?ooo`3o
ool02@3oool00`00o`00oooo0?ooo`1D0?ooo`005@3oool00d000000oooo0?ooo`020?ooo`03@000
003oool0oooo00<0oooo00<000000?ooo`3oool0f@3oool00`000000oooo0?ooo`090?ooo`03003o
003oool0oooo05<0oooo000D0?ooo`03@000003ooom000000080oooo00=000000?oood000000103o
ool00`000000oooo0?ooo`3J0?ooo`030000003oool0oooo00T0oooo00<00?l00?ooo`3oool0DP3o
ool001H0oooo00I000000?ooo`3ooom000000?oood0000040?ooo`80000000=000000?ooo`3oool0
f03oool00`000000oooo0?ooo`0:0?ooo`03003o003oool0oooo0540oooo000D0?ooo`9000000`3o
ool00d000000oooo@00000040?ooo`030000003oool0oooo0=/0oooo00<000000?ooo`3oool02P3o
ool00`00o`00oooo0?ooo`1@0?ooo`00503oool00d000000oooo0?ooo`020?ooo`03@000003ooom0
000000@0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`0:0?ooo`03003o003oool0
oooo04l0oooo000D0?ooo`=000000`3oool00d000000oooo0?ooo`030?ooo`030000003oool0oooo
0=d0oooo00<000000?ooo`3oool02P3oool2003o04l0oooo000P0?ooo`030000003oool0oooo0=h0
oooo00<000000?ooo`3oool02`3oool00`00o`00oooo0?ooo`1<0?ooo`00803oool00`0000100000
0?ooo`3O0?ooo`030000003oool0oooo00/0oooo00<00?l00?ooo`3oool0B`3oool00200oooo00<0
00000?ooo`3oool0h03oool00`000000oooo0?ooo`0;0?ooo`03003o003oool0oooo04X0oooo000P
0?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3oool02`3oool00`00o`00oooo0?ooo`19
0?ooo`00803oool00`000000oooo0?ooo`3R0?ooo`030000003oool0oooo00/0oooo00<00?l00?oo
o`3oool0B03oool00200oooo00<000000?ooo`3oool0hP3oool303loo``0oooo00<00?l00?ooo`3o
ool0A`3oool00200oooo00<00000@000003oool0hP3oool303loo`d0oooo00<00?l00?ooo`3oool0
AP3oool00200oooo00<000000?ooo`3oool0h`3oool00`0o?ol0oooo0000000=0?ooo`03003o003o
ool0oooo04D0oooo000P0?ooo`030000003oool0oooo0>H0oooo00<000000?ooo`3oool0DP3oool0
0200oooo00<000000?ooo`3oool0i`3oool00`000000oooo0?ooo`1A0?ooo`00803oool00`000000
oooo0?ooo`3X0?ooo`030000003oool0oooo0500oooo000P0?ooo`03000004000000oooo0>T0oooo
00<000000?ooo`3oool0C`3oool00200oooo00<000000?ooo`3oool0jP3oool00`000000oooo0?oo
o`1>0?ooo`00803oool00`000000oooo0?ooo`3[0?ooo`030000003oool0oooo04d0oooo000P0?oo
o`030000003oool0oooo0>`0oooo00<000000?ooo`3oool0C03oool00200oooo00<000000?ooo`3o
ool0k@3oool00`000000oooo0?ooo`1;0?ooo`00803oool00`00001000000?ooo`3^0?ooo`030000
003oool0oooo04X0oooo000P0?ooo`030000003oool0oooo0>l0oooo00<000000?ooo`3oool0B@3o
ool00200oooo00<000000?ooo`3oool0l03oool00`000000oooo0?ooo`180?ooo`00503oool2@000
00@0oooo00=000000?ooo`3oool00`3oool00`000000oooo0?ooo`3a0?ooo`030000003oool0oooo
04L0oooo000D0?ooo`03@000003ooom000000080oooo00=000000?oood000000103oool00`000000
oooo0?ooo`3b0?ooo`030000003oool0oooo04H0oooo000D0?ooo`03@000003ooom000000080oooo
00=000000?oood000000103oool00d0000000000@000003c0?ooo`03@000003oool0oooo04D0oooo
000D0?ooo`9000000`3oool00d000000oooo@000003o0?oood<0oooo000D0?ooo`03@000003oool0
oooo0080oooo00=000000?oood000000o`3ooom30?ooo`005@3oool2@00000<0oooo00=000000?oo
o`3oool0o`3ooom20?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO
0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00o`3ooomO0?ooo`00103oool2
@00000030?oood000010000000I0000000D0oooo@0000400001000000?ooo`02@00000`0oooo0T00
0000103ooom00000@000040000040?ooo`9000000P3oool3@00000030?oood000010000000=00000
o`3ooolV0?ooo`000`3oool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo@000003ooom0
00000?ooo`03@00000<0oooo00=000000?ooo`3oool02@3oool01T000000oooo0?oood000000oooo
@00000@0oooo00=000000?ooo`3oool00`3oool01D000000oooo0?ooo`3ooom000000080oooo00=0
00000?ooo`3oool0o`3ooolT0?ooo`000`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0
oooo0080oooo00E000000?oood00001000000?ooo`03@00000`0oooo00E000000?ooo`3ooom00000
0?ooo`03@0000080oooo00=000000?ooo`3oool00`3oool01D000000oooo0?ooo`3ooom000000?l0
oooo:@3oool000<0oooo00=000000?ooo`3oool00P3oool2@00000<0oooo0T0000001P3ooom00000
0?oood000000oooo@00000`0oooo00I000000?ooo`3ooom000000?oood0000020?ooo`03@000003o
oom0000000D0oooo00A000000?ooo`3oool0oooo0T00003o0?ooobP0oooo00030?ooo`03@000003o
oom000000080oooo00E000000?ooo`3ooom000000?ooo`02@00000050?oood000000oooo0?oood00
00003@3oool01T000000oooo0?oood000000oooo@0000080oooo00E000000?oood000000oooo@000
00030?ooo`05@000003oool0oooo0?oood0000000P3oool00d000000oooo0?ooo`3o0?ooob@0oooo
00030?ooo`=0000000<0oooo@000040000001D000000103ooom00000@000003oool2@00000h0oooo
0T0000000`3ooom00000@0000002@0000080oooo0d0000020?ooo`=0000000<0oooo@00004000000
0d00003o0?ooobH0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0
oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0
oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0
oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0oooo003o0?oooel0
oooo0000\
\>"],
  ImageRangeCache->{{{0, 349.563}, {215.563, 0}} -> {6.78339, -10.7593, 
  0.406649, 0.394782}}]
}, Open  ]],

Cell["\<\
\"Porovnanie hodnoty payoff diagramu, hodnoty explicitn\[EAcute]ho \
rie\.9aenia euro.call opcie a pribli\.9en\[EAcute]ho rie\.9aenia americkej \
call\"\
\>", "Text"],

Cell["\<\
Table[{xs[[i]],PayoffCall[xs[[i]]],EuropeanCallDiv[xs[[i]],X,str,r,DD,t],ys[[\
i]]},{i,1,2m+1,5}]\
\>", "Input"],

Cell["", "Input"],

Cell["\<\
Do[ g[j]=ListPlot[graf[j],PlotStyle->{PointSize[0.015],RGBColor[ 
         0,j/n,1]},DisplayFunction->Identity],{j,1,n}]\
\>", "Input"],

Cell[TextData[
"\"Grafy v\[YAcute]voja cien americkej call opcie v r\[OHat]znych \
\[CHacek]asov\[YAcute]ch intervaloch\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
Show[g[1],g[25],g[n],DisplayFunction->$DisplayFunction,PlotRange->{{20,130},{\
0,40}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.181818 0.00909091 0 0.0154508 [
[.18182 -0.0125 -6 -9 ]
[.18182 -0.0125 6 0 ]
[.36364 -0.0125 -6 -9 ]
[.36364 -0.0125 6 0 ]
[.54545 -0.0125 -6 -9 ]
[.54545 -0.0125 6 0 ]
[.72727 -0.0125 -9 -9 ]
[.72727 -0.0125 9 0 ]
[.90909 -0.0125 -9 -9 ]
[.90909 -0.0125 9 0 ]
[-0.0125 .07725 -6 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -12 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -12 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -12 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.18182 0 m
.18182 .00625 L
s
[(40)] .18182 -0.0125 0 1 Mshowa
.36364 0 m
.36364 .00625 L
s
[(60)] .36364 -0.0125 0 1 Mshowa
.54545 0 m
.54545 .00625 L
s
[(80)] .54545 -0.0125 0 1 Mshowa
.72727 0 m
.72727 .00625 L
s
[(100)] .72727 -0.0125 0 1 Mshowa
.90909 0 m
.90909 .00625 L
s
[(120)] .90909 -0.0125 0 1 Mshowa
.125 Mabswid
.04545 0 m
.04545 .00375 L
s
.09091 0 m
.09091 .00375 L
s
.13636 0 m
.13636 .00375 L
s
.22727 0 m
.22727 .00375 L
s
.27273 0 m
.27273 .00375 L
s
.31818 0 m
.31818 .00375 L
s
.40909 0 m
.40909 .00375 L
s
.45455 0 m
.45455 .00375 L
s
.5 0 m
.5 .00375 L
s
.59091 0 m
.59091 .00375 L
s
.63636 0 m
.63636 .00375 L
s
.68182 0 m
.68182 .00375 L
s
.77273 0 m
.77273 .00375 L
s
.81818 0 m
.81818 .00375 L
s
.86364 0 m
.86364 .00375 L
s
.95455 0 m
.95455 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07725 m
.00625 .07725 L
s
[(5)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(10)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(15)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(20)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(25)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(30)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(35)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(40)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .02 1 r
.015 w
.03636 0 Mdot
.0404 0 Mdot
.04451 0 Mdot
.04869 0 Mdot
.05296 0 Mdot
.0573 0 Mdot
.06172 0 Mdot
.06623 0 Mdot
.07081 0 Mdot
.07549 0 Mdot
.08025 0 Mdot
.08509 0 Mdot
.09003 0 Mdot
.09506 0 Mdot
.10018 0 Mdot
.10539 0 Mdot
.1107 0 Mdot
.11611 0 Mdot
.12162 0 Mdot
.12724 0 Mdot
.13295 0 Mdot
.13877 0 Mdot
.1447 0 Mdot
.15074 0 Mdot
.15689 0 Mdot
.16316 0 Mdot
.16954 0 Mdot
.17604 0 Mdot
.18265 0 Mdot
.1894 0 Mdot
.19626 0 Mdot
.20325 0 Mdot
.21038 0 Mdot
.21763 0 Mdot
.22502 0 Mdot
.23254 0 Mdot
.2402 0 Mdot
.24801 0 Mdot
.25596 2e-005 Mdot
.26406 0 Mdot
.2723 1e-005 Mdot
.2807 2e-005 Mdot
.28925 1e-005 Mdot
.29797 2e-005 Mdot
.30684 8e-005 Mdot
.31588 .00019 Mdot
.32508 .00042 Mdot
.33446 .00091 Mdot
.34401 .00201 Mdot
.35373 .00445 Mdot
.36364 .00986 Mdot
.37372 .02184 Mdot
.384 .03698 Mdot
.39446 .05371 Mdot
.40512 .07135 Mdot
.41598 .08958 Mdot
.42703 .10827 Mdot
.43829 .12737 Mdot
.44976 .14684 Mdot
.46144 .16669 Mdot
.47334 .1869 Mdot
.48546 .20749 Mdot
.4978 .22847 Mdot
.51037 .24983 Mdot
.52317 .27159 Mdot
.53621 .29375 Mdot
.54949 .31632 Mdot
.56301 .33931 Mdot
.57679 .36272 Mdot
.59082 .38656 Mdot
.60511 .41085 Mdot
.61966 .43559 Mdot
.63449 .46078 Mdot
.64958 .48644 Mdot
.66496 .51257 Mdot
.68062 .53919 Mdot
.69657 .5663 Mdot
.71282 .59391 Mdot
0 .5 1 r
.03636 0 Mdot
.0404 0 Mdot
.04451 0 Mdot
.04869 0 Mdot
.05296 0 Mdot
.0573 0 Mdot
.06172 0 Mdot
.06623 0 Mdot
.07081 0 Mdot
.07549 0 Mdot
.08025 0 Mdot
.08509 0 Mdot
.09003 0 Mdot
.09506 0 Mdot
.10018 0 Mdot
.10539 0 Mdot
.1107 0 Mdot
.11611 1e-005 Mdot
.12162 1e-005 Mdot
.12724 1e-005 Mdot
.13295 2e-005 Mdot
.13877 3e-005 Mdot
.1447 4e-005 Mdot
.15074 6e-005 Mdot
.15689 9e-005 Mdot
.16316 .00012 Mdot
.16954 .00017 Mdot
.17604 .00024 Mdot
.18265 .00034 Mdot
.1894 .00047 Mdot
.19626 .00064 Mdot
.20325 .00087 Mdot
.21038 .00117 Mdot
.21763 .00157 Mdot
.22502 .00208 Mdot
.23254 .00274 Mdot
.2402 .00358 Mdot
.24801 .00464 Mdot
.25596 .00596 Mdot
.26406 .0076 Mdot
.2723 .00961 Mdot
.2807 .01204 Mdot
.28925 .01497 Mdot
.29797 .01845 Mdot
.30684 .02256 Mdot
.31588 .02735 Mdot
.32508 .0329 Mdot
.33446 .03926 Mdot
.34401 .04647 Mdot
.35373 .05459 Mdot
.36364 .06365 Mdot
.37372 .07367 Mdot
.384 .08466 Mdot
.39446 .09663 Mdot
.40512 .10956 Mdot
.41598 .12344 Mdot
.42703 .13824 Mdot
.43829 .15393 Mdot
.44976 .17048 Mdot
.46144 .18784 Mdot
.47334 .20597 Mdot
.48546 .22483 Mdot
.4978 .24438 Mdot
.51037 .26459 Mdot
.52317 .28541 Mdot
.53621 .30683 Mdot
.54949 .32881 Mdot
.56301 .35134 Mdot
.57679 .3744 Mdot
.59082 .39797 Mdot
.60511 .42205 Mdot
.61966 .44663 Mdot
.63449 .47171 Mdot
.64958 .49728 Mdot
.66496 .52335 Mdot
.68062 .54992 Mdot
.69657 .577 Mdot
.71282 .60459 Mdot
0 1 1 r
.03636 0 Mdot
.0404 0 Mdot
.04451 0 Mdot
.04869 0 Mdot
.05296 1e-005 Mdot
.0573 1e-005 Mdot
.06172 1e-005 Mdot
.06623 2e-005 Mdot
.07081 2e-005 Mdot
.07549 3e-005 Mdot
.08025 4e-005 Mdot
.08509 6e-005 Mdot
.09003 7e-005 Mdot
.09506 .0001 Mdot
.10018 .00013 Mdot
.10539 .00016 Mdot
.1107 .00021 Mdot
.11611 .00027 Mdot
.12162 .00035 Mdot
.12724 .00044 Mdot
.13295 .00056 Mdot
.13877 .00071 Mdot
.1447 .0009 Mdot
.15074 .00113 Mdot
.15689 .00141 Mdot
.16316 .00175 Mdot
.16954 .00216 Mdot
.17604 .00266 Mdot
.18265 .00326 Mdot
.1894 .00398 Mdot
.19626 .00483 Mdot
.20325 .00584 Mdot
.21038 .00703 Mdot
.21763 .00842 Mdot
.22502 .01004 Mdot
.23254 .01192 Mdot
.2402 .01408 Mdot
.24801 .01657 Mdot
.25596 .01941 Mdot
.26406 .02263 Mdot
.2723 .02628 Mdot
.2807 .03038 Mdot
.28925 .03497 Mdot
.29797 .04009 Mdot
.30684 .04576 Mdot
.31588 .05202 Mdot
.32508 .0589 Mdot
.33446 .06643 Mdot
.34401 .07463 Mdot
.35373 .08352 Mdot
.36364 .09312 Mdot
.37372 .10345 Mdot
.384 .11452 Mdot
.39446 .12634 Mdot
.40512 .1389 Mdot
.41598 .15223 Mdot
.42703 .1663 Mdot
.43829 .18112 Mdot
.44976 .19668 Mdot
.46144 .21297 Mdot
.47334 .22998 Mdot
.48546 .24769 Mdot
.4978 .2661 Mdot
.51037 .28518 Mdot
.52317 .30493 Mdot
.53621 .32533 Mdot
.54949 .34636 Mdot
.56301 .36801 Mdot
.57679 .39027 Mdot
.59082 .41312 Mdot
.60511 .43656 Mdot
.61966 .46058 Mdot
.63449 .48516 Mdot
.64958 .51031 Mdot
.66496 .53601 Mdot
.68062 .56227 Mdot
.69657 .58909 Mdot
.71282 .61646 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{488, 301.5},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007X0001;B000`400?l00000o`00003oo`3ooooY
0?ooo`00J03oool3@0000080oooo00=000000?ooo`3oool0BP3oool2@00000@0oooo00=000000?oo
o`3oool0B`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo04H0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0A03oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool0:P3oool006T0oooo00I000000?ooo`3ooom000000?oood00
001;0?ooo`03@000003ooom000000080oooo00=000000?oood000000B`3oool00d000000oooo@000
00020?ooo`03@000003ooom0000004T0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000A`3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od000000:`3oool006L0oooo14000000103ooom000000?oood00001;0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000B`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
04T0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000A`3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000[0?ooo`00
I`3oool00d000000oooo@00000020?ooo`03@000003ooom0000004/0oooo0T0000030?ooo`03@000
003ooom0000004`0oooo00M000000?ooo`3oool0oooo@000003ooom0000004T0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000A`3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000[0?ooo`00J03oool2@0000080oooo
00=000000?oood000000B`3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000004/0oooo
00=000000?oood0000000P3oool00d000000oooo@00000190?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000004L0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood000000:`3oool006T0oooo00E000000?ooo`3oool0oooo@000
001=0?ooo`9000000`3oool00d000000oooo0?ooo`1;0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0A`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`150?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02X0oooo003o
0?ooonT0oooo003o0?ooonT0oooo003o0?ooonT0oooo003o0?ooonT0oooo003o0?ooonT0oooo003o
0?ooonT0oooo003o0?ooonT0oooo000V0?ooocl00?oo6000Oolj0005ool0oooo<P3oool001P0oooo
3P00001;003ooaL007oo;`001Ooo000002T0000000=000000?ooo`3oool01P3oool001P0oooo00<0
00000?ooo`3oool02`3ooomA003ooaP007oo;0001Ol30?ooo`030000003oool0oooo0140oooo00=0
00000?ooo`3oool04P3oool00d000000oooo0?ooo`0B0?ooo`03@000003oool0oooo0180oooo00<0
00000?ooo`3oool04@3oool00d000000oooo0?ooo`0B0?ooo`03@000003oool0oooo0180oooo00=0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`03@000003oool0oooo0180oooo00=0
00000?ooo`3oool04@3oool00d000000oooo0?ooo`0B0?ooo`030000003oool0oooo0180oooo00=0
00000?ooo`3oool06P3oool001P0oooo00<000000?ooo`3oool02`3ooomG003ooaH007oo:0001Ol3
0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1@
0?ooo`030000003oool0oooo02l0oooo000H0?ooo`030000003oool0oooo00`0ooooFP00oolE001o
o`<000Go00D0oooo0005o`001Ol000Go0?ooo`030005o`050?ooo`001Ol000Go0005o`3oool00`00
1Ol0103oool000Go0005o`001Ol20?ooo`<000Go00<0oooo0005o`001Ol02`001OmA0?ooo`03@000
003oool0oooo04l0oooo00=000000?ooo`3oool0D03oool00d000000oooo0?ooo`0_0?ooo`00603o
ool00`000000oooo0?ooo`190?ooob000?oo5P00OolL0?ooo`X000Goo`3ooolY0?ooo`00603oool0
0`000000oooo0?ooo`1E0?oooaP00?oo0P00Ool00`3oool007oo001oo`0A001ooaT0oooo0`001Ol0
0`3oool000Go0005o`030005ool0oooo:@3oool001P0oooo00<000000?ooo`3oool0F`3ooolE003o
o`@0oooo3`00OolM0?ooo`D000Goo`3ooolY0?ooo`00603oool200000003@000003oool0oooo0600
oooo4P00ool30?oooa0007oo6P3oool30005ool0oooo:P3oool001P0oooo00<000000?ooo`3oool0
I@3oool?003oo`L0oooo3000Oooo0?ooodL0oooo000H0?ooo`030000003oool0oooo06T0oooo3`00
ool70?ooo``007oo6@3oool50005ool0oooo9@3oool001P0oooo00<000000?ooo`3oool0K03oool<
003oo`X0oooo2@00OolI0?ooo`D000Goo`3ooolU0?ooo`00603oool00`000000oooo0?ooo`1`0?oo
o`/00?oo203oool<001ooaD0oooo1@001Ooo0?ooobD0oooo000H0?ooo`030000003oool0oooo07<0
oooo3000ool70?ooo`T007oo5@3oool50005ool0oooo9@3oool001P0oooo00<000000?ooo`3oool0
M03oool;003oo`P0oooo2000OolF0?ooo`<000Goo`3ooolV0?ooo`00603oool200000003@000003o
ool0oooo07@0oooo3@00ool70?ooo`T007ooo`3ooolk0?ooo`00603oool00`000000oooo0?ooo`1g
0?ooo``00?oo203oool8001ooaH0oooo1@001Ooo0?ooob00oooo000H0?ooo`030000003oool0oooo
07/0oooo2000ool;0?ooo`X007oo4@3oool50005ool0oooo803oool001P0oooo00<000000?ooo`3o
ool0OP3oool9003oo`L0oooo2P00OolA0?ooo`D000Goo`3ooolP0?ooo`00603oool00`000000oooo
0?ooo`1o0?ooo`P00?oo203oool3001oo`030?ooo`00Ool007oo00<007oo4@3oool50005ool0oooo
803oool001P0oooo00<000000?ooo`3oool0PP3oool9003oo`P0oooo1@00OolB0?ooo`<000Goo`3o
oolQ0?ooo`00603oool00`000000oooo0?ooo`220?ooo`T00?oo2@3oool8001oool0oooo<P3oool0
01P0oooo0P0000000d000000oooo0?ooo`210?ooo`P00?oo303oool5001oool0oooo<P3oool001P0
oooo00<000000?ooo`3oool0QP3oool9003oo`P0oooo1@00Oooo0?oooc80oooo000H0?ooo`030000
003oool0oooo08L0oooo2000ool80?ooo`T007oo3P3oool50005ool0oooo6`3oool001P0oooo00<0
00000?ooo`3oool0RP3oool5003oo`T0oooo2000Ool>0?ooo`D000Goo`3ooolK0?ooo`00603oool0
0`000000oooo0?ooo`2:0?ooo`T00?oo203oool5001oo`h0oooo1@001Ooo0?oooa/0oooo000H0?oo
o`030000003oool0oooo08/0oooo2000ool80?ooo`D007oo3P3oool50005ool0oooo6`3oool001P0
oooo00<000000?ooo`3oool0SP3oool5003oo`T0oooo0`00Ool@0?ooo`<000Goo`3ooolL0?ooo`00
603oool200000003@000003oool0oooo08`0oooo1@00ool=0?ooo`D007ooo`3ooolY0?ooo`00603o
ool00`000000oooo0?ooo`2?0?ooo`<00?oo00<0oooo003oo`00ool00`00ool80?ooo`D007ooo`3o
oolY0?ooo`00603oool00`000000oooo0?ooo`2C0?ooo`D00?oo203oool5001oool0oooo:@3oool0
01P0oooo00<000000?ooo`3oool0T`3oool5003oo`P0oooo1@00Ool>0?ooo`D000Goo`3ooolF0?oo
o`00603oool00`000000oooo0?ooo`2C0?ooo`D00?oo2@3oool8001oo`X0oooo1@001Ooo0?oooaH0
oooo000@0?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0U03oool8003oo`P0oooo
1@00Ool:0?ooo`D000Goo`3ooolF0?ooo`003`3oool00d000000oooo@00000060?ooo`030000003o
ool0oooo09L0oooo1@00ool80?ooo`D007oo2P3oool50005ool0oooo5P3oool00140oooo00=00000
0?ooo`3oool0103oool300000003@000003oool0oooo09@0oooo1@00ool80?ooo`D007oo2`3oool3
0005ool0oooo5`3oool000l0oooo0T0000070?ooo`030000003oool0oooo09L0oooo1@00ool90?oo
o`<007ooo`3ooolV0?ooo`003`3oool00d000000oooo0?ooo`060?ooo`030000003oool0oooo09P0
oooo2000ool90?ooo`D007ooo`3ooolP0?ooo`003`3oool3@00000H0oooo00<000000?ooo`3oool0
V`3oool5003oo`T0oooo1@00Oooo0?ooob00oooo000H0?ooo`030000003oool0oooo09/0oooo1@00
ool90?ooo`D007oo2P3oool50005ool0oooo4@3oool001P0oooo00<000000?ooo`3oool0V`3oool5
003oo`T0oooo1@00Ool:0?ooo`D000Goo`3ooolA0?ooo`00603oool00`000000oooo0?ooo`2L0?oo
o`<00?oo00<0oooo003oo`00ool00`00ool50?ooo`<007oo2`3oool50005ool0oooo4@3oool001P0
oooo0P0000000d000000oooo0?ooo`2N0?ooo`D00?oo4`3oool50005ool0oooo4@3oool001P0oooo
00<000000?ooo`3oool0X03oool5003oo`T0oooo1@00Ool60?ooo`<000Goo`3ooolB0?ooo`00603o
ool00`000000oooo0?ooo`2P0?ooo`D00?oo2@3oool5001oool0oooo6`3oool001P0oooo00<00000
0?ooo`3oool0X@3oool3003oo`X0oooo1@00Oooo0?oooa/0oooo000H0?ooo`030000003oool0oooo
0:@0oooo1@00ool50?ooo`D007ooo`3ooolK0?ooo`00603oool00`000000oooo0?ooo`2T0?ooo`D0
0?oo1P3oool3001oool0oooo703oool001P0oooo00<000000?ooo`3oool0Y03oool5003oo`X0oooo
1@00Ool50?ooo`D000Goo`3oool<0?ooo`00603oool200000003@000003oool0oooo0:80oooo1@00
ool:0?ooo`D007oo1@3oool50005ool0oooo303oool001P0oooo00<000000?ooo`3oool0Y@3oool3
003oo`/0oooo1@00Ool50?ooo`D000Goo`3oool<0?ooo`00603oool00`000000oooo0?ooo`2Y0?oo
o`D00?oo1@3oool5001oo`D0oooo1@001Ooo0?ooo``0oooo000H0?ooo`030000003oool0oooo0:T0
oooo1@00ool60?ooo`<007oo1`3oool30005ool0oooo3@3oool001P0oooo00<000000?ooo`3oool0
Z@3oool5003oool0oooo803oool001P0oooo00<000000?ooo`3oool0Z@3oool5003oool0oooo803o
ool001P0oooo00<000000?ooo`3oool0ZP3oool3003oo`/0oooo1@00Oooo0?oooa40oooo000H0?oo
o`80000000=000000?ooo`3oool0[03oool5003oo`D0oooo1@00Oooo0?oooa40oooo000H0?ooo`03
0000003oool0oooo0:h0oooo1@00ool50?ooo`D007oo1@3oool50005ool0oooo1`3oool001P0oooo
00<000000?ooo`3oool0[P3oool5003oo`D0oooo1@00Ool50?ooo`D000Goo`3oool70?ooo`00603o
ool00`000000oooo0?ooo`2^0?ooo`D00?oo1P3oool3001oo`H0oooo1@001Ooo0?ooo`L0oooo000H
0?ooo`030000003oool0oooo0:l0oooo0`00ool@0?ooo`D000Goo`3oool70?ooo`00603oool00`00
0000oooo0?ooo`2m0?ooo`D007oo00@0oooo0005o`001Ol000Goo`3oool80?ooo`00603oool00`00
0000oooo0?ooo`2c0?ooo`D00?oo1@3oool5001oool0oooo303oool001P0oooo0P0000000d000000
oooo0?ooo`2a0?ooo`D00?oo1@3oool5001oool0oooo303oool001P0oooo00<000000?ooo`3oool0
/`3oool5003oo`D0oooo1@00Oooo0?ooo``0oooo000H0?ooo`030000003oool0oooo0;<0oooo1@00
ool60?ooo`<007oo1P3oool50005ool0oooo0P3oool001P0oooo00<000000?ooo`3oool0]03oool3
003ooa00oooo1@001Ooo0?ooo`80oooo000H0?ooo`030000003oool0oooo0<L0oooo1@001Ooo0?oo
o`80oooo00090?ooo`E000000P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0;P0
oooo1@00ool:0?ooo`D000Goo`3oool20?ooo`002`3oool01d000000oooo0?ooo`3ooom000000?oo
od0000001P3oool00`000000oooo0?ooo`2h0?ooo`D00?oo1@3oool5001oo`040?ooo`001Ol000Go
0005ool0oooo0`3oool000/0oooo00M000000?ooo`3oool0oooo@000003ooom0000000H0oooo0`00
00000d000000oooo0?ooo`2e0?ooo`D00?oo1@3oool5001oool0oooo1`3oool000/0oooo00M00000
0?ooo`3oool0oooo@000003ooom0000000H0oooo00<000000?ooo`3oool0^03oool5003oo`D0oooo
1@00Oooo0?ooo`L0oooo000;0?ooo`07@000003oool0oooo0?oood000000oooo@00000060?ooo`03
0000003oool0oooo0;T0oooo0`00ool60?ooo`D007ooo`3oool70?ooo`002P3oool2@00000@0oooo
00=000000?ooo`3oool01@3oool00`000000oooo0?ooo`330?ooo`<007ooo`3oool80?ooo`00603o
ool00`000000oooo0?ooo`2m0?ooo`D00?oo2P3oool50005oo`0oooo000H0?ooo`030000003oool0
oooo0;d0oooo1@00ool:0?ooo`D000Goo03oool001P0oooo00<000000?ooo`3oool0_@3oool5003o
o`D0oooo1@00Ool50005oo`0oooo000H0?ooo`80000000=000000?ooo`3oool0^`3oool5003oo`D0
oooo1@00Ool50005oo`0oooo000H0?ooo`030000003oool0oooo0;h0oooo0`00ool60?ooo`D007oo
00@0oooo0005o`001Ol000Goo@3oool001P0oooo00<000000?ooo`3oool0a`3oool5001oool0oooo
0P3oool001P0oooo00<000000?ooo`3oool0b03oool3001oool0oooo0`3oool001P0oooo00<00000
0?ooo`3oool0`P3oool5003oool0oooo1`3oool001P0oooo00<000000?ooo`3oool0`P3oool5003o
ool0oooo1`3oool001P0oooo00<000000?ooo`3oool0`P3oool5003oool0oooo1`3oool001P0oooo
0P0000000d000000oooo0?ooo`300?ooo`D00?oo1@3oool5001oo`030?ooo`001Ol000Go00<000Go
mP3oool001P0oooo00<000000?ooo`3oool0``3oool3003oo`H0oooo1@00Ool00`3oool000Go0005
o`030005ooH0oooo000H0?ooo`030000003oool0oooo0<`0oooo1@00Ool00`3oool000Go0005o`03
0005ooH0oooo000H0?ooo`030000003oool0oooo0<`0oooo1@00Ool00`3oool000Go0005o`030005
ooH0oooo000H0?ooo`030000003oool0oooo0<L0oooo1@00ool0103oool007oo001oo`00Ool30?oo
o`<000Gom`3oool001P0oooo00<000000?ooo`3oool0a`3oool5003oool0oooo0P3oool001P0oooo
00<000000?ooo`3oool0a`3oool5003oool0oooo0P3oool001P0oooo0P0000000d000000oooo0?oo
o`350?ooo`D00?ooo`3oool20?ooo`00603oool00`000000oooo0?ooo`380?ooo`<00?oo1`3oool5
001oooH0oooo000H0?ooo`030000003oool0oooo0=80oooo1@00Ool50005oo40oooo000H0?ooo`03
0000003oool0oooo0=80oooo1@00Ool50005oo40oooo000H0?ooo`030000003oool0oooo0=80oooo
1@00Ool50005oo40oooo000H0?ooo`030000003oool0oooo0<`0oooo1@00ool20?ooo`<007oo00<0
oooo0005o`001Ol00`001Ooa0?ooo`00603oool00`000000oooo0?ooo`3<0?ooo`D00?oo1`3oool3
0005oo80oooo000H0?ooo`80000000=000000?ooo`3oool0bP3oool5003ooo`0oooo000H0?ooo`03
0000003oool0oooo0<`0oooo1@00oool0?ooo`00603oool00`000000oooo0?ooo`3=0?ooo`<00?oo
o@3oool001P0oooo00<000000?ooo`3oool0e`3oool5001ooo40oooo000H0?ooo`030000003oool0
oooo0=L0oooo1@00Oooa0?ooo`002@3oool5@0000080oooo00=000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`3B0?ooo`D00?oo1@00Ool00`3oool000Go0005o`030005on/0oooo000;0?ooo`07
@000003oool0oooo0?oood000000oooo@00000060?ooo`030000003oool0oooo0=80oooo1@00ool5
001oo`030?ooo`001Ol000Go00<000Goj`3oool000/0oooo00=000000?ooo`3oool00`3oool00d00
0000oooo0?ooo`040?ooo`<0000000=000000?ooo`3oool0c`3oool5003oo`040?ooo`00Ool007oo
001oo`80oooo1@001Oo[0?ooo`002`3oool014000000oooo0?ooo`3oool2@00000L0oooo00<00000
0?ooo`3oool0dP3oool5003oo`H0oooo1@001Oo[0?ooo`002`3oool01D000000oooo0?ooo`3ooom0
000000P0oooo00<000000?ooo`3oool0d`3oool3003oo`P0oooo0`001Oo/0?ooo`002P3oool2@000
00<0oooo0d0000060?ooo`030000003oool0oooo0?l0oooocP3oool001P0oooo00<000000?ooo`3o
ool0o`3oooo>0?ooo`00603oool00`000000oooo0?ooo`3M0?ooo`D007ooj`3oool001P0oooo00<0
00000?ooo`3oool0e`3oool5003oo`030?ooo`00Ool007oo00<007ooj`3oool001P0oooo0P000000
0d000000oooo0?ooo`3E0?ooo`D00?oo00<0oooo001oo`00Ool00`00Ool00`3oool000Go0005o`03
0005onD0oooo000H0?ooo`030000003oool0oooo0=L0oooo1@00ool00`3oool007oo001oo`03001o
o`030?ooo`001Ol000Go00<000Goi@3oool001P0oooo00<000000?ooo`3oool0e`3oool5003oo`80
oooo0`00Ool20?ooo`D000Goi@3oool001P0oooo00<000000?ooo`3oool0f03oool3003oo`P0oooo
1@001OoU0?ooo`00603oool00`000000oooo0?ooo`3T0?ooo`<000GoiP3oool001P0oooo00<00000
0?ooo`3oool0o`3oooo>0?ooo`00603oool00`000000oooo0?ooo`3o0?ooolh0oooo000H0?ooo`80
000000=000000?ooo`3oool0h@3oool5001oonD0oooo000H0?ooo`030000003oool0oooo0=d0oooo
1@00ool00`3oool007oo001oo`03001oonD0oooo000H0?ooo`030000003oool0oooo0=d0oooo1@00
ool00`3oool007oo001oo`03001oonD0oooo000H0?ooo`030000003oool0oooo0=d0oooo1@00ool0
0`3oool007oo001oo`03001oo`030?ooo`001Ol000Go00<000Gog`3oool001P0oooo00<000000?oo
o`3oool0g@3oool5003oo`80oooo0`00Ool20?ooo`D000Gog`3oool001P0oooo00<000000?ooo`3o
ool0gP3oool3003oo`P0oooo1@001OoO0?ooo`00603oool00`000000oooo0?ooo`3Y0?ooo`D000Go
g`3oool001P0oooo0P0000000d000000oooo0?ooo`3X0?ooo`<000Goh03oool001P0oooo00<00000
0?ooo`3oool0o`3oooo>0?ooo`00603oool00`000000oooo0?ooo`3S0?ooo`D00?oo00<0oooo001o
o`00Ool00`00OooO0?ooo`00603oool00`000000oooo0?ooo`3S0?ooo`D00?oo00<0oooo001oo`00
Ool00`00OooO0?ooo`00603oool00`000000oooo0?ooo`3S0?ooo`D00?oo00<0oooo001oo`00Ool0
0`00OooO0?ooo`00603oool00`000000oooo0?ooo`3S0?ooo`D00?oo00<0oooo001oo`00Ool00`00
OooO0?ooo`00603oool00`000000oooo0?ooo`3T0?ooo`<00?oo0`3oool3001oo`030?ooo`001Ol0
00Go00<000GofP3oool001P0oooo0P0000000d000000oooo0?ooo`3/0?ooo`D000GofP3oool001P0
oooo00<000000?ooo`3oool0kP3oool50005omX0oooo000H0?ooo`030000003oool0oooo0>h0oooo
1@001OoJ0?ooo`00603oool00`000000oooo0?ooo`3_0?ooo`<000Gof`3oool001P0oooo00<00000
0?ooo`3oool0j@3oool5003ooml0oooo000:0?ooo`=000000`3oool00d000000oooo0?ooo`050?oo
o`030000003oool0oooo0>T0oooo1@00ool5001oomX0oooo000:0?ooo`03@000003oool0oooo0080
oooo00=000000?oood0000001P3oool00`000000oooo0?ooo`3Y0?ooo`D00?oo1@00OooJ0?ooo`00
2`3oool01d000000oooo0?ooo`3ooom000000?oood0000001P3oool300000003@000003oool0oooo
0>H0oooo1@00ool5001oomX0oooo000;0?ooo`07@000003oool0oooo0?oood000000oooo@0000006
0?ooo`030000003oool0oooo0>X0oooo0`00ool00`3oool007oo001oo`03001oomX0oooo000:0?oo
o`03@000003ooom000000080oooo00=000000?oood0000001P3oool00`000000oooo0?ooo`3_0?oo
o`<007oof`3oool000/0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`050?ooo`03
0000003oool0oooo0?@0oooo1@001OoD0?ooo`00603oool00`000000oooo0?ooo`3d0?ooo`D000Go
e03oool001P0oooo00<000000?ooo`3oool0m03oool50005om@0oooo000H0?ooo`030000003oool0
oooo0?@0oooo1@001OoD0?ooo`00603oool200000003@000003oool0oooo0>`0oooo1@00ool20?oo
o`<000Goe@3oool001P0oooo00<000000?ooo`3oool0kP3oool5003oo`030?ooo`00Ool007oo00<0
07ooe03oool001P0oooo00<000000?ooo`3oool0kP3oool5003oo`030?ooo`00Ool007oo00<007oo
e03oool001P0oooo00<000000?ooo`3oool0kP3oool5003oo`030?ooo`00Ool007oo00<007ooe03o
ool001P0oooo00<000000?ooo`3oool0k`3oool3003oo`80oooo1@00OooD0?ooo`00603oool00`00
0000oooo0?ooo`3e0?ooo`<007ooe@3oool001P0oooo00<000000?ooo`3oool0n`3oool50005old0
oooo000H0?ooo`80000000=000000?ooo`3oool0n@3oool50005old0oooo000H0?ooo`030000003o
ool0oooo0?/0oooo1@001Oo=0?ooo`00603oool00`000000oooo0?ooo`3d0?ooo`D00?oo0P3oool5
0005old0oooo000H0?ooo`030000003oool0oooo0?@0oooo1@00ool30?ooo`<000GocP3oool001P0
oooo00<000000?ooo`3oool0m03oool5003oo`80oooo1@00Ooo=0?ooo`00603oool00`000000oooo
0?ooo`3d0?ooo`D00?oo0P3oool5001oold0oooo000H0?ooo`030000003oool0oooo0?D0oooo0`00
ool30?ooo`D007ooc@3oool001P0oooo0P0000000d000000oooo0?ooo`3i0?ooo`D007ooc@3oool0
01P0oooo00<000000?ooo`3oool0o03oool3001oolh0oooo000H0?ooo`030000003oool0oooo0?l0
oooocP3oool001P0oooo00<000000?ooo`3oool0o`3oool20?ooo`D000Goa`3oool001P0oooo00<0
00000?ooo`3oool0o`3oool20?ooo`D000Goa`3oool001P0oooo00<000000?ooo`3oool0n`3oool5
003oo`030?ooo`001Ol000Go00<000Goa`3oool001P0oooo00<000000?ooo`3oool0n`3oool5003o
o`030?ooo`001Ol000Go00<000Goa`3oool001P0oooo0P0000000d000000oooo0?ooo`3i0?ooo`D0
0?oo0P3oool30005olP0oooo000H0?ooo`030000003oool0oooo0?/0oooo1@00ool00`3oool007oo
001oo`03001oolL0oooo000H0?ooo`030000003oool0oooo0?`0oooo0`00ool20?ooo`D007ooa`3o
ool001P0oooo00<000000?ooo`3oool0o`3oool20?ooo`D007ooa`3oool001P0oooo00<000000?oo
o`3oool0o`3oool20?ooo`D007ooa`3oool001P0oooo00<000000?ooo`3oool0o`3oool30?ooo`<0
07oob03oool000X0oooo0d0000030?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0
o`3oooo>0?ooo`002P3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000000H0oooo00<0
00000?ooo`3oool0o`3oool80?ooo`D000Go`@3oool000/0oooo00=000000?ooo`3oool00`3oool0
0d000000oooo0?ooo`040?ooo`<0000000=000000?ooo`3oool0oP3oool5003oo`030?ooo`001Ol0
00Go00<000Go`@3oool000/0oooo00A000000?ooo`3oool0oooo0T0000070?ooo`030000003oool0
oooo0?l0oooo0P3oool5003oo`030?ooo`001Ol000Go00<000Go`@3oool000X0oooo00=000000?oo
od0000000P3oool00d000000oooo0?ooo`060?ooo`030000003oool0oooo0?l0oooo0P3oool5003o
o`030?ooo`001Ol000Go00<000Go`@3oool000/0oooo00A000000?ooo`3oool0oooo0d0000060?oo
o`030000003oool0oooo0?l0oooo0P3oool5003oo`80oooo0`001Oo20?ooo`00603oool00`000000
oooo0?ooo`3o0?ooo`<0oooo0`00ool20?ooo`D007oo`@3oool001P0oooo00<000000?ooo`3oool0
o`3oool80?ooo`D007oo`@3oool001P0oooo00<000000?ooo`3oool0o`3oool80?ooo`D007oo`@3o
ool001P0oooo0P0000000d000000oooo0?ooo`3o0?ooo`H0oooo1@00Ooo10?ooo`00603oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo0`00Ooo20?ooo`00603oool00`000000oooo0?ooo`3o0?ooolh0
oooo000H0?ooo`030000003oool0oooo0?l0oooo3`3oool50005okX0oooo000H0?ooo`030000003o
ool0oooo0?l0oooo203oool5003oo`80oooo1@001Onj0?ooo`00603oool00`000000oooo0?ooo`3o
0?ooo`P0oooo1@00ool20?ooo`D000Go^P3oool001P0oooo00<000000?ooo`3oool0o`3oool80?oo
o`D00?oo0P3oool50005okX0oooo000H0?ooo`80000000=000000?ooo`3oool0o`3oool60?ooo`D0
0?oo0`3oool30005ok/0oooo000H0?ooo`030000003oool0oooo0?l0oooo2@3oool3003oo`<0oooo
1@00Oonj0?ooo`00603oool00`000000oooo0?ooo`3o0?ooo`l0oooo1@00Oonj0?ooo`00603oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo1@00Oonj0?ooo`00603oool00`000000oooo0?ooo`3o0?oo
o`l0oooo1@00Oonj0?ooo`00603oool00`000000oooo0?ooo`3o0?oooa00oooo0`00Oonk0?ooo`00
603oool00`000000oooo0?ooo`3o0?ooolh0oooo000H0?ooo`80000000=000000?ooo`3oool0o`3o
ool=0?ooo`D00?oo00<0oooo0005o`001Ol00`001Ond0?ooo`00603oool00`000000oooo0?ooo`3o
0?ooo`l0oooo1@00ool00`3oool000Go0005o`030005ok@0oooo000H0?ooo`030000003oool0oooo
0?l0oooo3`3oool5003oo`030?ooo`001Ol000Go00<000Go]03oool001P0oooo00<000000?ooo`3o
ool0o`3oool?0?ooo`D00?oo00<0oooo0005o`001Ol00`001Ond0?ooo`00603oool00`000000oooo
0?ooo`3o0?oooa00oooo0`00ool30?ooo`<000Go]@3oool001P0oooo00<000000?ooo`3oool0o`3o
oolE0?ooo`D007oo]03oool001P0oooo00<000000?ooo`3oool0o`3ooolE0?ooo`D007oo]03oool0
01P0oooo0P0000000d000000oooo0?ooo`3o0?oooa<0oooo1@00Oond0?ooo`00603oool00`000000
oooo0?ooo`3o0?oooaD0oooo1@00Oond0?ooo`00603oool00`000000oooo0?ooo`3o0?oooaH0oooo
0`00Oone0?ooo`00603oool00`000000oooo0?ooo`3o0?ooolh0oooo000H0?ooo`030000003oool0
oooo0?l0oooo5@3oool5003oo`80oooo1@001On]0?ooo`002P3oool2@00000@0oooo00=000000?oo
o`3oool01@3oool00`000000oooo0?ooo`3o0?oooaD0oooo1@00ool20?ooo`D000Go[@3oool000`0
oooo00I000000?ooo`3ooom000000?oood0000060?ooo`030000003oool0oooo0?l0oooo5@3oool5
003oo`80oooo1@001On]0?ooo`002`3oool01d000000oooo0?ooo`3ooom000000?oood0000001P3o
ool300000003@000003oool0oooo0?l0oooo4P3oool5003oo`80oooo1@001On]0?ooo`00303oool0
1T000000oooo0?oood000000oooo@00000H0oooo00<000000?ooo`3oool0o`3ooolF0?ooo`<00?oo
103oool30005ojh0oooo000:0?ooo`03@000003ooom000000080oooo00=000000?oood0000001P3o
ool00`000000oooo0?ooo`3o0?oooa`0oooo1@00Oon]0?ooo`002`3oool00d000000oooo0?ooo`02
0?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`D007oo[@3oool0
01P0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`D007oo[@3oool001P0oooo00<000000?ooo`3o
ool0o`3ooolL0?ooo`D007oo[@3oool001P0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`<007oo
[P3oool001P0oooo0P0000000d000000oooo0?ooo`3o0?oool`0oooo000H0?ooo`030000003oool0
oooo0?l0oooo703oool5003oojd0oooo000H0?ooo`030000003oool0oooo0?l0oooo703oool5003o
o`80oooo1@001OnV0?ooo`00603oool00`000000oooo0?ooo`3o0?oooa`0oooo1@00ool20?ooo`D0
00GoYP3oool001P0oooo00<000000?ooo`3oool0o`3ooolL0?ooo`D00?oo0P3oool50005ojH0oooo
000H0?ooo`030000003oool0oooo0?l0oooo7@3oool3003oo`<0oooo1@001OnV0?ooo`00603oool0
0`000000oooo0?ooo`3o0?ooob@0oooo0`001OnW0?ooo`00603oool200000003@000003oool0oooo
0?l0oooo8@3oool5001oojH0oooo000H0?ooo`030000003oool0oooo0?l0oooo8`3oool5001oojH0
oooo000H0?ooo`030000003oool0oooo0?l0oooo8`3oool5001oojH0oooo000H0?ooo`030000003o
ool0oooo0?l0oooo8`3oool5001oojH0oooo000H0?ooo`030000003oool0oooo0?l0oooo903oool3
001oojL0oooo000H0?ooo`030000003oool0oooo0?l0oooocP3oool001P0oooo00<000000?ooo`3o
ool0o`3ooolS0?ooo`D00?ooYP3oool001P0oooo0P0000000d000000oooo0?ooo`3o0?ooob40oooo
1@00ool20?ooo`D000GoW`3oool001P0oooo00<000000?ooo`3oool0o`3ooolS0?ooo`D00?oo0P3o
ool50005oil0oooo000H0?ooo`030000003oool0oooo0?l0oooo8`3oool5003oo`80oooo1@001OnO
0?ooo`00603oool00`000000oooo0?ooo`3o0?ooob@0oooo0`00ool30?ooo`D000GoW`3oool001P0
oooo00<000000?ooo`3oool0o`3oool[0?ooo`<000GoX03oool001P0oooo00<000000?ooo`3oool0
o`3ooolZ0?ooo`D007ooW`3oool001P0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`D007ooW`3o
ool001P0oooo0P0000000d000000oooo0?ooo`3o0?ooobP0oooo1@00OonO0?ooo`00603oool00`00
0000oooo0?ooo`3o0?ooobX0oooo1@00OonO0?ooo`00603oool00`000000oooo0?ooo`3o0?ooob/0
oooo0`00OonP0?ooo`00603oool00`000000oooo0?ooo`3o0?ooolh0oooo000H0?ooo`030000003o
ool0oooo0?l0oooo:P3oool5003ooil0oooo000:0?ooo`900000103oool00d000000oooo0?ooo`05
0?ooo`030000003oool0oooo0?l0oooo:P3oool5003oo`80oooo1@001OnH0?ooo`00303oool01T00
0000oooo0?oood000000oooo@00000H0oooo00<000000?ooo`3oool0o`3ooolZ0?ooo`D00?oo0P3o
ool50005oiP0oooo000;0?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3oool0103oool3
00000003@000003oool0oooo0?l0oooo9`3oool5003oo`80oooo1@001OnH0?ooo`00303oool00d00
0000oooo0?ooo`02@00000L0oooo00<000000?ooo`3oool0o`3oool[0?ooo`<00?oo0`3oool50005
oiP0oooo000:0?ooo`03@000003ooom000000080oooo00=000000?ooo`3oool01P3oool00`000000
oooo0?ooo`3o0?oooc80oooo0`001OnI0?ooo`002`3oool014000000oooo0?ooo`3oool3@00000H0
oooo00<000000?ooo`3oool0o`3ooola0?ooo`D007ooV03oool001P0oooo00<000000?ooo`3oool0
o`3ooola0?ooo`D007ooV03oool001P0oooo00<000000?ooo`3oool0o`3ooola0?ooo`D007ooV03o
ool001P0oooo00<000000?ooo`3oool0o`3ooola0?ooo`D007ooV03oool001P0oooo0P0000000d00
0000oooo0?ooo`3o0?oooc00oooo0`00OonI0?ooo`00603oool00`000000oooo0?ooo`3o0?oooc40
oooo1@00oonH0?ooo`00603oool00`000000oooo0?ooo`3o0?oooc40oooo1@00oonH0?ooo`00603o
ool00`000000oooo0?ooo`3o0?oooc40oooo1@00ool20?ooo`D000GoT@3oool001P0oooo00<00000
0?ooo`3oool0o`3ooola0?ooo`D00?oo0P3oool50005oi40oooo000H0?ooo`030000003oool0oooo
0?l0oooo<P3oool3003oo`<0oooo1@001OnA0?ooo`00603oool00`000000oooo0?ooo`3o0?ooocP0
oooo1@001OnA0?ooo`00603oool200000003@000003oool0oooo0?l0oooo=`3oool30005oi80oooo
000H0?ooo`030000003oool0oooo0?l0oooo>03oool5001ooi40oooo000H0?ooo`030000003oool0
oooo0?l0oooo>03oool5001ooi40oooo000H0?ooo`030000003oool0oooo0?l0oooo>03oool5001o
oi40oooo000H0?ooo`030000003oool0oooo0?l0oooo>03oool5001ooi40oooo000H0?ooo`030000
003oool0oooo0?l0oooo>@3oool3001ooi80oooo000H0?ooo`030000003oool0oooo0?l0oooocP3o
ool001P0oooo0P0000000d000000oooo0?ooo`3o0?ooocH0oooo1@00oonA0?ooo`00603oool00`00
0000oooo0?ooo`3o0?ooocP0oooo1@00oonA0?ooo`00603oool00`000000oooo0?ooo`3o0?ooocP0
oooo1@00ool30?ooo`D000GoR@3oool001P0oooo00<000000?ooo`3oool0o`3ooolh0?ooo`D00?oo
0`3oool50005ohT0oooo000H0?ooo`030000003oool0oooo0?l0oooo>@3oool3003oo`@0oooo1@00
1On90?ooo`00603oool00`000000oooo0?ooo`3o0?oood00oooo1@001On90?ooo`00603oool00`00
0000oooo0?ooo`3o0?oood40oooo0`001On:0?ooo`00603oool200000003@000003oool0oooo0?l0
oooo?P3oool5001oohT0oooo000H0?ooo`030000003oool0oooo0?l0oooo@03oool5001oohT0oooo
000H0?ooo`030000003oool0oooo0?l0oooo@03oool5001oohT0oooo000H0?ooo`030000003oool0
oooo0?l0oooo@03oool5001oohT0oooo000H0?ooo`030000003oool0oooo0?l0oooo@@3oool3001o
ohX0oooo000;0?ooo`=000000P3oool00d000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0
oooo@03oool5003oohT0oooo000<0?ooo`06@000003oool0oooo@000003ooom000001P3oool00`00
0000oooo0?ooo`3o0?oood00oooo1@00oon90?ooo`002P3oool4@00000040?oood000000oooo@000
00H0oooo00A000000000000000100000o`3ooolo0?ooo`D00?ooR@3oool000X0oooo00=000000?oo
od0000000P3oool00d000000oooo@000003o0?ooodT0oooo1@00oon90?ooo`002`3oool2@0000080
oooo00=000000?oood000000o`3ooom:0?ooo`<00?ooRP3oool000`0oooo00E000000?ooo`3oool0
oooo@000003o0?ooomP0oooo003o0?ooonT0oooo0000\
\>"],
  ImageRangeCache->{{{0, 487}, {300.5, 0}} -> {14.0161, -2.08896, 0.241669, 
  0.142193}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{462, 346},
WindowMargins->{{29, Automatic}, {Automatic, 9}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 54, 0, 30, "Input"],
Cell[1766, 51, 344, 18, 318, "Input"],
Cell[2113, 71, 1105, 45, 858, "Input"],
Cell[3221, 118, 44, 0, 33, "Text"],
Cell[3268, 120, 134, 13, 228, "Input"],
Cell[3405, 135, 47, 0, 33, "Text"],
Cell[3455, 137, 73, 0, 30, "Input"],
Cell[3531, 139, 64, 0, 30, "Input"],
Cell[3598, 141, 54, 0, 33, "Text"],
Cell[3655, 143, 44, 0, 30, "Input"],
Cell[3702, 145, 24, 0, 33, "Text"],
Cell[3729, 147, 360, 8, 174, "Input"],

Cell[CellGroupData[{
Cell[4114, 159, 147, 3, 66, "Input"],
Cell[4264, 164, 27065, 681, 225, 6316, 420, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[31344, 848, 176, 4, 52, "Text"],
Cell[31523, 854, 122, 3, 48, "Input"],
Cell[31648, 859, 17, 0, 30, "Input"],
Cell[31668, 861, 145, 3, 66, "Input"],
Cell[31816, 866, 132, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[31973, 872, 111, 3, 48, "Input"],
Cell[32087, 877, 31689, 808, 310, 7595, 506, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

