(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     70692,       1907]*)
(*NotebookOutlinePosition[     71387,       1932]*)
(*  CellTagsIndexPosition[     71343,       1928]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["<<c:\\math\\kniz\\options\\optvalue.m", "Input"],

Cell["\<\
PSOR[V_,ps_,g_,a_,b_,c_,m_,eps_,omega_]:=
Module[{error},
error=1;
While
   [error>eps*eps,
    error=0.0;
    V[-m]=g[-m];
    V[m]=g[m];
    
    For[i=-m+1,i<m,i++,
        y= (ps[i]-a*V[i-1]-c*V[i+1])/b;
        y= Max[g[i],V[i]+omega*(y-V[i])];
        error += (y - V[i])^2;
        V[i]= y;];
    
   ];
]       \
\>", "Input"],

Cell["\<\
AmericanPut[X_,sigma_,r_,D_,t_,m_,n_,trans_,time_,eps_]:=
Module[{omega},
omega=1.5;

xright=Log[Slarge/X];
xleft=-xright;
k1=N[r/(0.5*sigma^2)];
k2=N[(r-D)/(0.5*sigma^2)];
k3=N[2*Sqrt[2/Pi]*trans/(sigma*Sqrt[time])];
k4=N[0.25*(k1^2-1)];

h=N[xright/m];
k=N[0.5*sigma^2*t/n];

Print[\"Pomer k/h^2  \",k/h^2];

TransfPutPayoff[x_,tau_]:=N[Exp[(0.25*(k2-1)^2+k1)*tau]*Max[0,Exp[0.5*(k2-1)*\
x]-Exp[0.5*(k2+1)*x]]];

Do[u[i,0]=TransfPutPayoff[i*h,0],{i,-m,m}];

a=N[-k/h^2];
b=N[1.+2*k/h^2];
c=N[-k/h^2];

Do
[
 Do[  g[i]=TransfPutPayoff[i*h,j*k];
      grad=(u[i+1,j-1]-u[i-1,j-1])/(2*h);
      kriv=(u[i+1,j-1]-2*u[i,j-1]+u[i-1,j-1])/h^2;
 ps[i]=N[u[i,j-1]-k3*k*Abs[k4*u[i,j-1]-k2*grad+kriv]],{i,-m+1,m-1}];

 g[-m]   =TransfPutPayoff[-m*h,j*k];
 g[m]    =TransfPutPayoff[m*h,j*k];

 Do[V[i]=Max[g[i],u[i,j-1]],{i,-m+1,m-1}];
 
 PSOR[V,ps,g,a,b,c,m,eps,omega]; 
  
 Do[u[i,j]=V[i],{i,-m,m}];  

 xs=Table[X*Exp[i*h],{i,-m,m}];
 ys=Table[X*Exp[-0.5*(k2-1)*i*h-(0.25*(k2-1)^2+k1)*j*k]*u[i,j],{i,-
 m,m}];
 graf[j]=Table[{xs[[i]],ys[[i]]},{i,2m+1}],
 {j,1,n}]
]\
\>", "Input"],

Cell["\"Zadan\[EAcute] parametre\"", "Text"],

Cell["\<\
X=60;
sigma=0.29;
r=0.04;
DD=0.0;
t=0.6;
m=50;
n=50;
Slarge=150;
trans=0.0;
time=0.03;
eps=0.000001;\
\>", "Input"],

Cell["\"Upraven\[AAcute] volatilita\"", "Text"],

Cell["str=N[Sqrt[sigma^2-2*Sqrt[2/Pi]*trans*sigma/Sqrt[time]]]", "Input"],

Cell["AmericanPut[X,sigma,r,DD,t,m,n,trans,time,eps]", "Input"],

Cell["\"Defin\[IAcute]cia payoff diagramu\"", "Text"],

Cell["PayoffPut[S_]:=Max[X-S,0];", "Input"],

Cell["\<\
gt=ListPlot[graf[n],PlotStyle->{PointSize[0.02],RGBColor[0,0,1]},\
DisplayFunction->Identity];\
\>", "Input"],

Cell["\<\
g1=ListPlot[graf[n],PlotStyle->{PointSize[0.015],RGBColor[1,0,1]},\
DisplayFunction->Identity];
g2=Plot[PayoffPut[S],{S,0,150},PlotRange->All, DisplayFunction->Identity];\
\>", "Input"],

Cell["\"Graf\"", "Text"],

Cell[CellGroupData[{

Cell["\<\
Show[gt,g1,g2,AxesLabel->{\"S\",\"P\"},DisplayFunction->$DisplayFunction,\
PlotRange->{{20,130},{0,40}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.181818 0.00909091 0 0.0154508 [
[.18182 -0.0125 -6 -9 ]
[.18182 -0.0125 6 0 ]
[.36364 -0.0125 -6 -9 ]
[.36364 -0.0125 6 0 ]
[.54545 -0.0125 -6 -9 ]
[.54545 -0.0125 6 0 ]
[.72727 -0.0125 -9 -9 ]
[.72727 -0.0125 9 0 ]
[.90909 -0.0125 -9 -9 ]
[.90909 -0.0125 9 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[-0.0125 .07725 -6 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -12 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -12 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -12 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -5 0 ]
[0 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.18182 0 m
.18182 .00625 L
s
[(40)] .18182 -0.0125 0 1 Mshowa
.36364 0 m
.36364 .00625 L
s
[(60)] .36364 -0.0125 0 1 Mshowa
.54545 0 m
.54545 .00625 L
s
[(80)] .54545 -0.0125 0 1 Mshowa
.72727 0 m
.72727 .00625 L
s
[(100)] .72727 -0.0125 0 1 Mshowa
.90909 0 m
.90909 .00625 L
s
[(120)] .90909 -0.0125 0 1 Mshowa
.125 Mabswid
.04545 0 m
.04545 .00375 L
s
.09091 0 m
.09091 .00375 L
s
.13636 0 m
.13636 .00375 L
s
.22727 0 m
.22727 .00375 L
s
.27273 0 m
.27273 .00375 L
s
.31818 0 m
.31818 .00375 L
s
.40909 0 m
.40909 .00375 L
s
.45455 0 m
.45455 .00375 L
s
.5 0 m
.5 .00375 L
s
.59091 0 m
.59091 .00375 L
s
.63636 0 m
.63636 .00375 L
s
.68182 0 m
.68182 .00375 L
s
.77273 0 m
.77273 .00375 L
s
.81818 0 m
.81818 .00375 L
s
.86364 0 m
.86364 .00375 L
s
.95455 0 m
.95455 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(S) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .07725 m
.00625 .07725 L
s
[(5)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(10)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(15)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(20)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(25)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(30)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(35)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(40)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.02 w
.03636 .55623 Mdot
.0404 .54937 Mdot
.04451 .54239 Mdot
.04869 .53527 Mdot
.05296 .52803 Mdot
.0573 .52065 Mdot
.06172 .51313 Mdot
.06623 .50548 Mdot
.07081 .49768 Mdot
.07549 .48974 Mdot
.08025 .48165 Mdot
.08509 .47341 Mdot
.09003 .46502 Mdot
.09506 .45648 Mdot
.10018 .44777 Mdot
.10539 .43891 Mdot
.1107 .42988 Mdot
.11611 .42069 Mdot
.12162 .41132 Mdot
.12724 .40178 Mdot
.13295 .39207 Mdot
.13877 .38217 Mdot
.1447 .3721 Mdot
.15074 .36183 Mdot
.15689 .35138 Mdot
.16316 .34073 Mdot
.16954 .32989 Mdot
.17604 .31884 Mdot
.18265 .3076 Mdot
.1894 .29614 Mdot
.19626 .28447 Mdot
.20325 .27259 Mdot
.21038 .26048 Mdot
.21763 .24815 Mdot
.22502 .2356 Mdot
.23254 .22281 Mdot
.2402 .20978 Mdot
.24801 .19652 Mdot
.25596 .18301 Mdot
.26406 .16925 Mdot
.2723 .15523 Mdot
.2807 .14096 Mdot
.28925 .12687 Mdot
.29797 .11339 Mdot
.30684 .10058 Mdot
.31588 .08848 Mdot
.32508 .07718 Mdot
.33446 .0667 Mdot
.34401 .0571 Mdot
.35373 .0484 Mdot
.36364 .04061 Mdot
.37372 .03372 Mdot
.384 .02771 Mdot
.39446 .02253 Mdot
.40512 .01813 Mdot
.41598 .01443 Mdot
.42703 .01137 Mdot
.43829 .00887 Mdot
.44976 .00685 Mdot
.46144 .00524 Mdot
.47334 .00397 Mdot
.48546 .00298 Mdot
.4978 .00221 Mdot
.51037 .00163 Mdot
.52317 .00119 Mdot
.53621 .00086 Mdot
.54949 .00062 Mdot
.56301 .00044 Mdot
.57679 .00031 Mdot
.59082 .00022 Mdot
.60511 .00015 Mdot
.61966 .00011 Mdot
.63449 7e-005 Mdot
.64958 5e-005 Mdot
.66496 3e-005 Mdot
.68062 2e-005 Mdot
.69657 2e-005 Mdot
.71282 1e-005 Mdot
.72936 1e-005 Mdot
.74622 0 Mdot
.76338 0 Mdot
.78086 0 Mdot
.79867 0 Mdot
.8168 0 Mdot
.83527 0 Mdot
.85408 0 Mdot
.87324 0 Mdot
.89275 0 Mdot
.91262 0 Mdot
.93287 0 Mdot
.95348 0 Mdot
.97448 0 Mdot
.99586 0 Mdot
1 0 1 r
.015 w
.03636 .55623 Mdot
.0404 .54937 Mdot
.04451 .54239 Mdot
.04869 .53527 Mdot
.05296 .52803 Mdot
.0573 .52065 Mdot
.06172 .51313 Mdot
.06623 .50548 Mdot
.07081 .49768 Mdot
.07549 .48974 Mdot
.08025 .48165 Mdot
.08509 .47341 Mdot
.09003 .46502 Mdot
.09506 .45648 Mdot
.10018 .44777 Mdot
.10539 .43891 Mdot
.1107 .42988 Mdot
.11611 .42069 Mdot
.12162 .41132 Mdot
.12724 .40178 Mdot
.13295 .39207 Mdot
.13877 .38217 Mdot
.1447 .3721 Mdot
.15074 .36183 Mdot
.15689 .35138 Mdot
.16316 .34073 Mdot
.16954 .32989 Mdot
.17604 .31884 Mdot
.18265 .3076 Mdot
.1894 .29614 Mdot
.19626 .28447 Mdot
.20325 .27259 Mdot
.21038 .26048 Mdot
.21763 .24824 Mdot
.22502 .23609 Mdot
.23254 .22404 Mdot
.2402 .21213 Mdot
.24801 .20037 Mdot
.25596 .18879 Mdot
.26406 .17741 Mdot
.2723 .16627 Mdot
.2807 .15538 Mdot
.28925 .14478 Mdot
.29797 .1345 Mdot
.30684 .12454 Mdot
.31588 .11495 Mdot
.32508 .10574 Mdot
.33446 .09693 Mdot
.34401 .08854 Mdot
.35373 .08058 Mdot
.36364 .07305 Mdot
.37372 .06598 Mdot
.384 .05936 Mdot
.39446 .05318 Mdot
.40512 .04746 Mdot
.41598 .04218 Mdot
.42703 .03732 Mdot
.43829 .03289 Mdot
.44976 .02885 Mdot
.46144 .0252 Mdot
.47334 .02191 Mdot
.48546 .01897 Mdot
.4978 .01635 Mdot
.51037 .01403 Mdot
.52317 .01198 Mdot
.53621 .01018 Mdot
.54949 .00861 Mdot
.56301 .00725 Mdot
.57679 .00608 Mdot
.59082 .00507 Mdot
.60511 .00421 Mdot
.61966 .00348 Mdot
.63449 .00287 Mdot
.64958 .00235 Mdot
.66496 .00191 Mdot
.68062 .00155 Mdot
.69657 .00125 Mdot
.71282 .00101 Mdot
.72936 .00081 Mdot
.74622 .00064 Mdot
.76338 .00051 Mdot
.78086 .0004 Mdot
.79867 .00032 Mdot
.8168 .00025 Mdot
.83527 .00019 Mdot
.85408 .00015 Mdot
.87324 .00011 Mdot
.89275 9e-005 Mdot
.91262 7e-005 Mdot
.93287 5e-005 Mdot
.95348 4e-005 Mdot
.97448 3e-005 Mdot
.99586 2e-005 Mdot
0 g
.5 Mabswid
0 .61803 m
.04498 .54159 L
.10298 .44301 L
.15881 .34812 L
.21815 .24726 L
.27533 .15009 L
.33033 .05661 L
.34499 .03169 L
.35873 .00834 L
.36042 .00546 L
.36227 .00232 L
.36401 0 L
.36563 0 L
.36951 0 L
.37306 0 L
.38884 0 L
.44487 0 L
.50441 0 L
.56177 0 L
.61697 0 L
.67568 0 L
.73222 0 L
.78659 0 L
.84447 0 L
.90018 0 L
.9594 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{371.563, 229.563},
  ImageMargins->{{20, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005c0000iB000`400?l00000o`00003oo`3ooomd
0?ooo`00DP3oool3@0000080oooo00=000000?ooo`3oool0;`3oool2@00000@0oooo00=000000?oo
o`3oool0<@3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02`0oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0:P3oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool0=03oool005<0oooo00I000000?ooo`3ooom000000?oood00
000`0?ooo`03@000003ooom000000080oooo00=000000?oood000000<@3oool00d000000oooo@000
00020?ooo`03@000003ooom0000002l0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000;@3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od000000=@3oool00540oooo14000000103ooom000000?oood00000`0?ooo`03@000003ooom00000
0080oooo00=000000?oood000000<@3oool00d000000oooo@00000020?ooo`03@000003ooom00000
02l0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000;@3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000e0?ooo`00
D@3oool00d000000oooo@00000020?ooo`03@000003ooom000000300oooo0T0000030?ooo`03@000
003ooom000000380oooo00M000000?ooo`3oool0oooo@000003ooom0000002l0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000;@3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000e0?ooo`00DP3oool2@0000080oooo
00=000000?oood000000<03oool00d000000oooo0?ooo`020?ooo`03@000003ooom000000340oooo
00=000000?oood0000000P3oool00d000000oooo@000000_0?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000002d0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood000000=@3oool005<0oooo00E000000?ooo`3oool0oooo@000
000b0?ooo`9000000`3oool00d000000oooo0?ooo`0a0?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0;@3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`0[0?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo03@0oooo003o
0?ooog@0oooo003o0?ooog@0oooo003o0?ooog@0oooo003o0?ooog@0oooo003=0?ooocl0003o00<0
oooo0000o`000?l020000?l00`3oool0003o0000o`030000o`030?ooo`000?l0003o00<0003o00<0
oooo0000o`000?l00`000?l00`3oool0003o0000o`030000o`030?ooo`000?l0003o00<0003o00<0
oooo0000o`000?l00`000?l00`3oool0003o0000o`030000o`80oooo1@000?l00`3oool0003o0000
o`030000o`80oooo1@000?l:0?ooo`=000004@3oool00;40ooooF`000?l00`3oool0003o0000o`08
0000o`030?ooo`000?l0003o00<0003o00<0oooo0000o`000?l00`000?l00`3oool0003o0000o`03
0000o`030?ooo`000?l0003o00<0003o00<0oooo0000o`000?l00`000?l00`3oool0003o0000o`03
0000o`030?ooo`000?l0003o00<0003o0P3oool50000o`030?ooo`000?l0003o00<0003o0P3oool5
0000o`X0oooo00=000000?oood0000004@3oool001`0ooooo`00000/00000003@00000000000003o
00<0o`3o00@0003o000000000000003o0`3o0?l00`000?l0oooo0?ooo`0:0?ooo`03@000003oool0
oooo00l0oooo000L0?ooo`030000003oool0oooo00/0oooo00=000000?ooo`3oool02`3oool00d00
0000oooo0?ooo`0;0?ooo`03@000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00d00
0000oooo0?ooo`0;0?ooo`03@000003oool0oooo00/0oooo00=000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`03@000003oool0oooo00@0oooo<0000?l30?l0o`80003o0`3o0?l01000
0?l0o`3o0?l0o`3o0?l20000o`<0o`3o0P000?l30?l0o`040000o`3o0?l0o`3o0?l0o`80003o0`3o
0?l20000o`<0o`3o0P000?l30?l0o`<0003o0`3o0?l20000o`<0o`3o0P000?l30?l0o`030000o`3o
ool0003o00<0o`3o0P000?l30?l0o`030000o`3oool0003o00<0o`3o00<0003o0?ooo`000?l00`3o
0?l00`000?l0oooo0000o`030?l0o`030000od000000o`3o0080o`3o0P000?l00`3oool0003o0?l0
o`020?l0o`030000o`3oool0003o00<0o`3o00<0003o0?ooo`000?l00`3o0?l010000?l0oooo0?oo
o`000?l30?l0o`030000o`3oool0003o00<0o`3o00@0003o0?ooo`3oool0003o0`3o0?l00`000?l0
oooo0?ooo`090?ooo`03@000003oool0oooo0100oooo000L0?ooo`030000003oool0oooo03H0oooo
00=000000?ooo`3oool0=03oool00`00001000000?ooo`0?0?ooobL0003o0`3o0?l20000o`<0o`3o
00D0003o0?l0o`3o0?l0o`3o0?ooo`030?l0o`030000o`3oool0o`3o0080o`3o00H0oooo0?l0o`3o
0?l0o`3o0000o`3oool30?l0o`80oooo00<0003o0?l0o`000?l00P3oool00`3o0?l0003o0000o`02
0?ooo`030?l0o`000?l0003o0080oooo00<0o`3o0000o`000?l00P3oool00`3o0?l0003o0000o`02
0?ooo`030000o`3o0?l0003o0080oooo00<0003o0?l0o`000?l00P3oool00`000?l0o`3o0000o`03
0?ooo`030000o`3o0?l0003o0080oooo00<0003o0?l0o`000?l00`3oool00`000?l0o`3o0000o`03
0?ooo`030000o`3o0?l0003o00<0oooo00<0003o0?l0o`000?l00`3oool00`3o0?l0003o0000o`03
0?ooo`030000o`3o0?l0003o00<0oooo00<0003o0?l0o`000?l00`3oool00`000?l0o`3o0000o`04
0?ooo`030000o`3o0?l0003o00<0oooo00<0003o0?l0o`000?l0103oool00`000?l0o`3o0000o`0;
0?ooo`03@000003ooom000000140oooo000L0?ooo`030000003oool0oooo06`0oooo00<000000?oo
o`3oool03@3ooolJ0000o`050?ooo`000?l0003o0000o`3oool00`000?l30?l0o`050000o`3o0?l0
o`3o0?l0o`000?l00`3o0?l00`000?l0oooo0?l0o`020?l0o`040?ooo`3o0?l0o`3o0?l0o`80oooo
00<0o`3o0?ooo`3oool00P3oool01@3o0?l0oooo0?ooo`3oool0o`3o00@0oooo00<0o`3o0?ooo`3o
ool0N`3oool3@0000140oooo000L0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0
2P3ooolE0000o`040?ooo`000?l0003o0000o`P0oooo0`3o0?l01@3oool0o`3o0?l0o`3o0?l0oooo
00<0o`3o0P3oool00`3o0?l0oooo0?ooo`020?ooo`050?l0o`3oool0oooo0?ooo`3o0?l0X`3oool0
01`0oooo00<00000@000003oool0J`3oool00`000000oooo0?ooo`070?oooa80003o00@0oooo0000
o`000?l0003o2`3oool30?l0o`040?ooo`3o0?l0o`3o0?l0o`80oooo00D0o`3o0?ooo`3oool0oooo
0?l0o`2`0?ooo`00703oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00P0oooo3P00
0?l<0?ooo`H0o`3o00@0oooo0?l0o`3o0?l0o`3o0P3oool00`3o0?l0oooo0?ooo`2f0?ooo`00703o
ool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00D0oooo3P000?l?0?ooo`H0o`3o0P3o
ool00`3o0?l0oooo0?ooo`2j0?ooo`00703oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0
oooo00H0oooo2`000?l>0?ooo`<0o`3o0P3oool0103o0?l0oooo0?ooo`3o0?o00?ooo`00703oool0
0`00001000000?ooo`1Y0?ooo`030000003oool0oooo00<0oooo2P000?l>0?ooo`<0o`3o00@0oooo
0?l0o`3o0?l0o`3oaP3oool001`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`04
0?ooo`P0003o3@3oool60?l0o`80oooo00<0o`3o0?ooo`3oool0a@3oool001`0oooo00<000000?oo
o`3oool0I`3oool00`000000oooo0?ooo`020?ooo`X0003o2P3oool30?l0o`060?ooo`3o0?l0o`3o
0?l0o`3oool0o`3ob`3oool001`0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`02
0?ooo`P0003o303oool30?l0o`80oooo00<0o`3o0?ooo`3oool0c03oool001`0oooo00<000000?oo
o`3oool0IP3oool00`000000oooo0?ooo`030?ooo`L0003o2P3oool30?l0o`030?ooo`3o0?l0oooo
0=40oooo000L0?ooo`03000004000000oooo06H0oooo00<000000?ooo`3oool020000?l80?ooo`<0
o`3o00@0oooo0?l0o`3o0?l0o`3oe03oool001`0oooo00<000000?ooo`3oool0I@3oool010000000
oooo0?ooo`3oool70000o`T0oooo0`3o0?l20?ooo`030?l0o`3oool0oooo0=<0oooo000L0?ooo`03
0000003oool0oooo06D0oooo00<000000000o`000?l01P000?l80?ooo`<0o`3o00<0oooo0?l0o`3o
ool0f03oool001`0oooo00<000000?ooo`3oool0I03oool00`000000oooo0000o`070000o`P0oooo
0`3o0?oK0?ooo`00703oool00`000000oooo0?ooo`1T0?ooo`030000003oool0003o00H0003o1P3o
ool30?l0o`030?ooo`3o0?l0oooo0=/0oooo000L0?ooo`03000004000000oooo06<0oooo00<00000
0000o`000?l01@000?l80?ooo`<0o`3ogP3oool001`0oooo00<000000?ooo`3oool0H`3oool00`00
0000003o0000o`040000o`H0oooo0`3o0?l00`3oool0o`3o0?ooo`3N0?ooo`00703oool00`000000
oooo0?ooo`1R0?ooo`03000000000?l0003o00<0003o203oool30?l0on40oooo000E0?ooo`03@000
003oool0oooo00@0oooo00<000000?ooo`3oool0H03oool20000o`03000000000?l0003o00<0003o
103oool30?l0o`80oooo00<0o`3o0?ooo`3oool0h03oool001@0oooo00=000000?oood0000001@3o
ool00`000000oooo0?ooo`1P0?ooo`030000o`000000003o00@0003o1@3oool30?l0onD0oooo000F
0?ooo`03@000003oool0oooo00<0oooo0P0000000d000000oooo0?ooo`1N0?ooo`03000000000?l0
003o0080003o203oool00`3o0?l0oooo0?ooo`3T0?ooo`00503oool2@00000H0oooo00<000000?oo
o`3oool0H03oool00`000000003o0000o`020000o`@0oooo0`3o0?oX0?ooo`00503oool00d000000
oooo0?ooo`050?ooo`030000003oool0oooo05d0oooo0P000?l00`000000003o0000o`020000o`D0
oooo0`3o0?oX0?ooo`00503oool3@00000D0oooo00<000000?ooo`3oool0G@3oool20000o`030000
00000?l0003o00@0oooo0`3o0?l00`3oool0o`3o0?ooo`3X0?ooo`00703oool00`000000oooo0?oo
o`1M0?ooo`030000o`000000003o0080003o103oool30?l0on/0oooo000L0?ooo`03000004000000
oooo05d0oooo00<0003o000000000?l00P000?l50?ooo`030?l0o`3oool0oooo0>X0oooo000L0?oo
o`030000003oool0oooo05X0oooo0`000?l010000000003o0000o`000?l20?ooo`<0o`3okP3oool0
01`0oooo00<000000?ooo`3oool0FP3oool20000o`03000000000?l0003o00@0oooo0`3o0?o^0?oo
o`00703oool00`000000oooo0?ooo`1J0?ooo`80003o00<000000000o`000?l01@3oool00`3o0?l0
oooo0?ooo`3]0?ooo`00703oool00`000000oooo0?ooo`1J0?ooo`030000o`000000003o0080003o
00@0oooo0?l0o`3o0?l0o`3ol@3oool001`0oooo00<00000@000003oool0E`3oool40000o`030000
00000?l0003o0080oooo0`3o0?oa0?ooo`00703oool00`000000oooo0?ooo`1G0?ooo`<0003o00<0
00000000o`3oool0103oool00`3o0?l0oooo0?ooo`3`0?ooo`00703oool00`000000oooo0?ooo`1G
0?ooo`80003o00<000000000o`000?l00P3oool30?l0oo<0oooo000L0?ooo`030000003oool0oooo
05L0oooo0P000?l00`000000003o0000o`020?ooo`<0o`3ol`3oool001`0oooo00<00000@000003o
ool0E@3oool30000o`03000000000?l0003o00@0oooo00<0o`3o0?ooo`3oool0lP3oool001`0oooo
00<000000?ooo`3oool0E@3oool30000o`03000000000?l0oooo00<0o`3omP3oool001`0oooo00<0
00000?ooo`3oool0E@3oool20000o`04000000000?l0003o0?ooo`<0o`3omP3oool001`0oooo00<0
00000?ooo`3oool0E@3oool20000o`03000000000?l0003o0080oooo00<0o`3o0?ooo`3oool0m@3o
ool001`0oooo00<000000?ooo`3oool0DP3oool40000o`03000000000?l0o`3o0080o`3on@3oool0
01`0oooo00<00000@000003oool0DP3oool30000o`03000000000?l0oooo00<0o`3on@3oool001`0
oooo00<000000?ooo`3oool0DP3oool30000o`05000000000?l0oooo0?ooo`3o0?l0nP3oool001`0
oooo00<000000?ooo`3oool0DP3oool20000o`040000003o0?l0o`3o0?l0oo`0oooo000>0?ooo`E0
00000P3oool00d000000oooo0?ooo`040?ooo`030000003oool0oooo05<0oooo00<0003o0000003o
0?l00P3o0?ol0?ooo`00403oool01d000000oooo0?ooo`3ooom000000?oood0000001@3oool00`00
0000oooo0?ooo`1?0?ooo`@0003o00@000000?ooo`3oool0o`3oo@3oool00100oooo00M000000?oo
o`3oool0oooo@000003ooom0000000D0oooo0P0000000d000000oooo0?ooo`1=0?ooo`<0003o00@0
00000?l0o`3o0?l0o`3ooP3oool00100oooo00M000000?ooo`3oool0oooo@000003ooom0000000D0
oooo00<000000?ooo`3oool0C`3oool30000o`040000003o0?l0o`3o0?l0ooh0oooo000@0?ooo`07
@000003oool0oooo0?oood000000oooo@00000050?ooo`030000003oool0oooo04l0oooo0P000?l0
10000000003o0000o`3o0?oo0?ooo`003`3oool2@00000@0oooo00=000000?ooo`3oool0103oool0
0`000000oooo0?ooo`1=0?ooo`@0003o00<000000000o`3oool0o`3oool10?ooo`00703oool00`00
0000oooo0?ooo`1=0?ooo`<0003o00<000000?l0o`3o0?l0o`3oool20?ooo`00703oool00`000010
00000?ooo`1=0?ooo`80003o00@000000?l0o`3o0?l0o`3oo`3oool20?ooo`00703oool00`000000
oooo0?ooo`1=0?ooo`80003o00<000000000o`3o0?l0o`3oool30?ooo`00703oool00`000000oooo
0?ooo`1=0?ooo`040?l0o`000000o`3o0000ool0oooo103oool001`0oooo00<000000?ooo`3oool0
BP3oool30000o`030?l0o`000000o`3o0?l0oooo1@3oool001`0oooo00<000000?ooo`3oool0BP3o
ool30000o`030000003o0?l0oooo0?l0oooo1@3oool001`0oooo00<00000@000003oool0BP3oool2
0000o`03000000000?l0003o0?l0oooo1P3oool001`0oooo00<000000?ooo`3oool0BP3oool01@00
0?l0o`3o0000003o0?l0003o0?l0oooo1P3oool001`0oooo00<000000?ooo`3oool0B03oool30000
o`030000003o0?l0o`3o0?l0oooo1`3oool001`0oooo00<000000?ooo`3oool0B03oool30000o`03
0000003o0?l0oooo0?l0oooo1`3oool001`0oooo00<000000?ooo`3oool0B03oool20?l0o`030000
00000?l0003o0?l0oooo203oool001`0oooo00<00000@000003oool0B03oool00`3o0?l000000?l0
o`020000ool0oooo203oool001`0oooo00<000000?ooo`3oool0A@3oool40000o`03000000000?l0
003o0?l0oooo2@3oool001`0oooo00<000000?ooo`3oool0A@3oool30000o`03000000000?l0oooo
0?l0oooo2P3oool001`0oooo00<000000?ooo`3oool0A@3oool01@000?l0o`3o0?l0o`000000003o
0?l0oooo2`3oool001`0oooo00<00000@000003oool0A@3oool01@000?l0o`3o0000003o0?l0003o
0?l0oooo2`3oool001`0oooo00<000000?ooo`3oool0@`3oool30000o`030000003o0?l0003o0?l0
oooo303oool001`0oooo00<000000?ooo`3oool0@`3oool30000o`03000000000?l0oooo0?l0oooo
303oool000h0oooo1D0000020?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0@`3o
ool01@000?l0o`3o0000003o0?l0003o0?l0oooo3@3oool00100oooo00M000000?ooo`3oool0oooo
@000003ooom0000000D0oooo00<000000?ooo`3oool0@`3oool01@000?l0o`3o0000003o0?l0003o
0?l0oooo3@3oool00100oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`030?ooo`80
000000=000000?ooo`3oool0?P3oool40000o`030000003o0?l0003o0?l0oooo3P3oool00100oooo
00A000000?ooo`3oool0oooo0T0000060?ooo`030000003oool0oooo0400oooo00D0003o0?l0o`3o
0?l000000000o`3o0?oooa00oooo000@0?ooo`05@000003oool0oooo0?oood0000001`3oool00`00
0000oooo0?ooo`100?ooo`050000o`3o0?l0o`3o000000000?l0o`3oool@0?ooo`003`3oool2@000
00<0oooo0d0000050?ooo`030000003oool0oooo0400oooo0P000?l00`000000003o0000o`3o0?oo
oa00oooo000L0?ooo`030000003oool0oooo03h0oooo10000?l00`000000003o0?ooo`3o0?oooa00
oooo000L0?ooo`03000004000000oooo03h0oooo00D0003o0?l0o`3o0?l000000000o`3o0?oooa80
oooo000L0?ooo`030000003oool0oooo03h0oooo00D0003o0?l0o`000000o`3o0000o`3o0?oooa80
oooo000L0?ooo`030000003oool0oooo03h0oooo0P000?l00`000000003o0000o`3o0?oooa80oooo
000L0?ooo`030000003oool0oooo03`0oooo0`000?l00`000000003o0000o`3o0?oooa<0oooo000L
0?ooo`030000003oool0oooo03`0oooo00D0003o0?l0o`3o0?l000000000o`3o0?oooa@0oooo000L
0?ooo`03000004000000oooo03`0oooo00D0003o0?l0o`000000o`3o0000o`3o0?oooa@0oooo000L
0?ooo`030000003oool0oooo03X0oooo0`000?l010000000o`3o0000o`000?oo0?oooa@0oooo000L
0?ooo`030000003oool0oooo03X0oooo0`000?l00`000000003o0000o`3o0?oooaD0oooo000L0?oo
o`030000003oool0oooo03X0oooo0P3o0?l00`000000003o0000o`3o0?oooaH0oooo000L0?ooo`03
0000003oool0oooo03X0oooo00<0o`3o0000003o0?l00P000?oo0?oooaH0oooo000L0?ooo`030000
04000000oooo03L0oooo10000?l00`000000003o0000o`3o0?oooaL0oooo000L0?ooo`030000003o
ool0oooo03L0oooo00D0003o0?l0o`3o0?l000000000o`3o0?oooaT0oooo000L0?ooo`030000003o
ool0oooo03L0oooo00D0003o0?l0o`3o0?l000000000o`3o0?oooaT0oooo000L0?ooo`030000003o
ool0oooo03L0oooo0P000?l00`000000003o0000o`3o0?oooaT0oooo000L0?ooo`03000004000000
oooo03D0oooo0`000?l00`000000003o0000o`3o0?oooaX0oooo000L0?ooo`030000003oool0oooo
03D0oooo00D0003o0?l0o`3o0?l000000000o`3o0?oooa/0oooo000L0?ooo`030000003oool0oooo
03D0oooo00D0003o0?l0o`000000o`3o0000o`3o0?oooa/0oooo000?0?ooo`=000000`3oool00d00
0000oooo0?ooo`040?ooo`030000003oool0oooo03<0oooo10000?l00`000000003o0000o`3o0?oo
oa/0oooo000?0?ooo`03@000003oool0oooo0080oooo00=000000?oood0000001@3oool00`000000
oooo0?ooo`0c0?ooo`<0003o00<000000000o`000?l0o`3ooolL0?ooo`00403oool01d000000oooo
0?ooo`3ooom000000?oood0000001@3oool200000003@000003oool0oooo0340oooo00D0003o0?l0
o`000000o`3o0000o`3o0?oooad0oooo000@0?ooo`07@000003oool0oooo0?oood000000oooo@000
00050?ooo`030000003oool0oooo03<0oooo00D0003o0?l0o`000000o`3o0000o`3o0?oooad0oooo
000?0?ooo`03@000003ooom000000080oooo00=000000?oood0000001@3oool00`000000oooo0?oo
o`0a0?ooo`<0003o00<000000?l0o`000?l0o`3ooolN0?ooo`00403oool00d000000oooo0?ooo`02
0?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool0<@3oool01@000?l0o`3o0?l0o`00
0000003o0?l0oooo7`3oool001`0oooo00<000000?ooo`3oool0<@3oool01@000?l0o`3o0000003o
0?l0003o0?l0oooo7`3oool001`0oooo00<00000@000003oool0;`3oool30000o`040000003o0?l0
003o0000ool0oooo7`3oool001`0oooo00<000000?ooo`3oool0;`3oool30000o`03000000000?l0
003o0?l0oooo803oool001`0oooo00<000000?ooo`3oool0;`3oool01@000?l0o`3o0000003o0?l0
003o0?l0oooo8@3oool001`0oooo00<000000?ooo`3oool0;`3oool01@000?l000000?l0o`3o0?l0
003o0?l0oooo8@3oool001`0oooo00<000000?ooo`3oool0;@3oool30000o`030000003o0?l0003o
0?l0oooo8P3oool001`0oooo00<00000@000003oool0;@3oool01@000?l0o`3o0000003o0?l0003o
0?l0oooo8`3oool001`0oooo00<000000?ooo`3oool0;@3oool01@000?l0o`3o0000003o0?l0003o
0?l0oooo8`3oool001`0oooo00<000000?ooo`3oool0:`3oool30000o`040000003o0?l0003o0000
ool0oooo8`3oool001`0oooo00<000000?ooo`3oool0:`3oool010000?l0o`3o0000003o0?l20000
ool0oooo903oool001`0oooo00<000000?ooo`3oool0:`3oool01@000?l0o`3o0000003o0?l0003o
0?l0oooo9@3oool001`0oooo00<00000@000003oool0:@3oool30000o`040000003o0?l0003o0000
ool0oooo9@3oool001`0oooo00<000000?ooo`3oool0:@3oool30000o`03000000000?l0003o0?l0
oooo9P3oool001`0oooo00<000000?ooo`3oool0:@3oool01@000?l0o`3o0000003o0?l0003o0?l0
oooo9`3oool001`0oooo00<000000?ooo`3oool0:@3oool01@000?l0o`3o0000003o0?l0003o0?l0
oooo9`3oool001`0oooo00<000000?ooo`3oool09`3oool30000o`030000003o0?l0003o0?l0oooo
:03oool001`0oooo00<00000@000003oool09`3oool01@000?l0o`3o0000003o0?l0003o0?l0oooo
:@3oool001`0oooo00<000000?ooo`3oool09`3oool01@000?l0o`3o0000003o0?l0003o0?l0oooo
:@3oool000l0oooo0d0000030?ooo`03@000003oool0oooo00@0oooo00<000000?ooo`3oool09P3o
ool20000o`040000003o0?l0003o0000ool0oooo:@3oool000l0oooo00=000000?ooo`3oool00P3o
ool00d000000oooo@00000050?ooo`030000003oool0oooo02H0oooo0P3o0?l00`000000003o0000
o`3o0?ooobX0oooo000@0?ooo`03@000003oool0oooo00<0oooo00=000000?ooo`3oool00`3oool2
00000003@000003oool0oooo02@0oooo00<0o`3o0000003o0?l00P000?oo0?ooobX0oooo000@0?oo
o`04@000003oool0oooo0?ooo`9000001P3oool00`000000oooo0?ooo`0T0?ooo`<0003o00@00000
0000o`000?l0003oo`3ooolZ0?ooo`003`3oool00d000000oooo@00000020?ooo`03@000003oool0
oooo00D0oooo00<000000?ooo`3oool0903oool20?l0o`04000000000?l0003o0000ool0oooo:`3o
ool00100oooo00A000000?ooo`3oool0oooo0d0000050?ooo`030000003oool0oooo02@0oooo00<0
o`3o0000003o0?l00P000?oo0?ooob`0oooo000L0?ooo`030000003oool0oooo0280oooo0`000?l0
10000000003o0000o`000?oo0?ooob`0oooo000L0?ooo`03000004000000oooo0280oooo00@0003o
0?l0o`000000o`3o0P000?oo0?ooobd0oooo000L0?ooo`030000003oool0oooo0280oooo00D0003o
0?l0o`000000o`3o0000o`3o0?ooobh0oooo000L0?ooo`030000003oool0oooo0200oooo0`000?l0
10000000o`3o0000o`000?oo0?ooobh0oooo000L0?ooo`030000003oool0oooo0200oooo00@0003o
0?l0o`3o0?l000000P000?oo0?ooobl0oooo000L0?ooo`030000003oool0oooo0200oooo00D0003o
0?l0o`000000o`3o0000o`3o0?oooc00oooo000L0?ooo`03000004000000oooo01h0oooo10000?l0
0`000000003o0000o`3o0?oooc00oooo000L0?ooo`030000003oool0oooo01h0oooo00@0003o0?l0
o`3o0?l000000P000?oo0?oooc40oooo000L0?ooo`030000003oool0oooo01h0oooo00D0003o0?l0
o`000000o`3o0000o`3o0?oooc80oooo000L0?ooo`030000003oool0oooo01d0oooo0`000?l00`00
0000003o0000o`3o0?oooc80oooo000L0?ooo`030000003oool0oooo01d0oooo00D0003o0?l0o`00
0000o`3o0000o`3o0?oooc<0oooo000L0?ooo`03000004000000oooo01/0oooo0`000?l0103o0?l0
00000?l0o`000?oo0?oooc<0oooo000L0?ooo`030000003oool0oooo01/0oooo0`000?l010000000
o`3o0000o`000?oo0?oooc<0oooo000L0?ooo`030000003oool0oooo01/0oooo00@0003o0?l0o`3o
0?l000000P000?oo0?oooc@0oooo000L0?ooo`030000003oool0oooo01X0oooo0P000?l0103o0?l0
00000?l0o`000?oo0?ooocD0oooo000L0?ooo`030000003oool0oooo01X0oooo0P3o0?l00`000000
o`3o0000o`3o0?ooocH0oooo000L0?ooo`03000004000000oooo01X0oooo0P3o0?l00`000000003o
0000o`3o0?ooocH0oooo000L0?ooo`030000003oool0oooo01P0oooo0`000?l010000000003o0000
o`000?oo0?ooocH0oooo000?0?ooo`900000103oool00d000000oooo0?ooo`040?ooo`030000003o
ool0oooo01P0oooo00@0003o0?l0o`3o0?l000000P000?oo0?ooocL0oooo000A0?ooo`06@000003o
ool0oooo@000003ooom000001@3oool00`000000oooo0?ooo`0H0?ooo`050000o`3o0?l000000?l0
o`000?l0o`3ooolh0?ooo`00403oool01d000000oooo0?ooo`3ooom000000?oood0000001@3oool2
00000003@000003oool0oooo01@0oooo10000?l00`000000003o0000o`3o0?ooocP0oooo000A0?oo
o`06@000003oool0oooo@000003ooom000001@3oool00`000000oooo0?ooo`0F0?ooo`040000o`3o
0?l0o`3o00000080003oo`3oooli0?ooo`003`3oool00d000000oooo@00000020?ooo`03@000003o
oom0000000D0oooo00<000000?ooo`3oool05@3oool20000o`040?l0o`000000o`3o0000ool0oooo
>P3oool00100oooo00=000000?ooo`3oool00P3oool00d000000oooo0?ooo`040?ooo`030000003o
ool0oooo01D0oooo00@0003o0?l0o`3o0?l000000P000?oo0?ooocX0oooo000L0?ooo`030000003o
ool0oooo01D0oooo00D0003o0?l0o`000000o`3o0000o`3o0?oooc/0oooo000L0?ooo`0300000400
0000oooo01<0oooo10000?l00`000000003o0000o`3o0?oooc/0oooo000L0?ooo`030000003oool0
oooo01<0oooo00@0003o0?l0o`3o0?l000000P000?oo0?oooc`0oooo000L0?ooo`030000003oool0
oooo0180oooo0P000?l0103o0?l000000?l0o`000?oo0?ooocd0oooo000L0?ooo`030000003oool0
oooo0180oooo00@0003o0?l0o`3o0?l000000P000?oo0?ooocd0oooo000L0?ooo`030000003oool0
oooo0180oooo00D0003o0?l0o`000000o`3o0000o`3o0?oooch0oooo000L0?ooo`03000004000000
oooo0100oooo10000?l00`000000003o0000o`3o0?oooch0oooo000L0?ooo`030000003oool0oooo
0100oooo00@0003o0?l0o`3o0?l000000P000?oo0?ooocl0oooo000L0?ooo`030000003oool0oooo
00l0oooo0P000?l20?l0o`03000000000?l0oooo0?l0oooo?`3oool001`0oooo00<000000?ooo`3o
ool03`3oool010000?l0o`3o0?l0o`0000020000ool0oooo@03oool001`0oooo00<000000?ooo`3o
ool03`3oool01@000?l0o`3o0000003o0?l0003o0?l0oooo@@3oool001`0oooo00<00000@000003o
ool03P3oool30000o`03000000000?l0003o0?l0oooo@@3oool001`0oooo00<000000?ooo`3oool0
3P3oool20?l0o`03000000000?l0003o0?l0oooo@P3oool001`0oooo00<000000?ooo`3oool0303o
ool20000o`80o`3o00<000000000o`000?l0o`3ooom20?ooo`00703oool00`000000oooo0?ooo`0<
0?ooo`040000o`3o0?l0o`3o000000<0003oo`3ooom20?ooo`00703oool00`000000oooo0?ooo`0;
0?ooo`80003o00<0o`3o0000003o0?l00P000?oo0?oood<0oooo000L0?ooo`03000004000000oooo
00/0oooo00@0003o0?l0o`3o0?l000000P000?oo0?oood@0oooo000L0?ooo`030000003oool0oooo
00T0oooo0`000?l0103o0?l000000?l0o`000?oo0?ooodD0oooo000L0?ooo`030000003oool0oooo
00T0oooo10000?l00`000000003o0000o`3o0?ooodD0oooo000?0?ooo`900000103oool00d000000
oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00@0003o0?l0o`3o0?l000000P000?oo0?oo
odH0oooo000A0?ooo`06@000003oool0oooo@000003ooom000001@3oool00`000000oooo0?ooo`08
0?ooo`80003o0P3o0?l00`000000003o0?ooo`3o0?ooodH0oooo000@0?ooo`03@000003oool0oooo
00<0oooo00=000000?ooo`3oool00`3oool200000003@000003oool0oooo00H0oooo00D0003o0?l0
o`3o0?l000000000o`3o0?ooodP0oooo000A0?ooo`03@000003oool0oooo009000001P3oool00`00
0000oooo0?ooo`070?ooo`80003o00@0o`3o0000003o0?l0003oo`3ooom80?ooo`003`3oool00d00
0000oooo@00000020?ooo`03@000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool01000
0?l0o`3o0?l0o`0000020000ool0ooooB03oool00100oooo00A000000?ooo`3oool0oooo0d000005
0?ooo`030000003oool0oooo00H0oooo0P000?l0103o0?l000000?l0o`000?oo0?ooodT0oooo000L
0?ooo`03000004000000oooo00H0oooo0`3o0?l00`000000003o0000o`3o0?ooodT0oooo000L0?oo
o`030000003oool0oooo00H0oooo0P3o0?l00`000000003o0000o`3o0?ooodX0oooo000L0?ooo`03
0000003oool0oooo00H0oooo00<0003o000000000?l00P000?oo0?ooodX0oooo000L0?ooo`030000
003oool0oooo00L0oooo00<000000000o`000?l0o`3ooom;0?ooo`00703oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0?l0ooooC03oool001`0oooo00<00000@000003oool01P3oool0
0`000000oooo0?ooo`3o0?oood`0oooo000L0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0o`3ooom=0?ooo`00703oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0
ooooC@3oool001`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooodh0oooo
000L0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooom?0?ooo`00703oool0
0`00001000000?ooo`030?ooo`030000003oool0oooo0?l0ooooC`3oool001`0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`3o0?oooe00oooo000L0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0o`3ooom@0?ooo`00703oool01@000000oooo0?ooo`3oool000000?l0
ooooD`3oool001`0oooo00@000000?ooo`3oool00000o`3ooomD0?ooo`00703oool0100000100000
0?ooo`00003o0?oooe@0oooo000L0?ooo`030000003oool000000?l0ooooE@3oool001`0oooo00<0
00000?ooo`000000o`3ooomE0?ooo`00403oool3@0000080oooo00=000000?ooo`3oool0103oool2
00000?l0ooooEP3oool00140oooo00I000000?ooo`3ooom000000?oood0000050?ooo`800000o`3o
oomF0?ooo`003`3oool4@00000040?oood000000oooo@00000D0oooo0P0000000d000000oooo0?oo
o`3o0?oooe<0oooo000?0?ooo`03@000003ooom000000080oooo00=000000?oood000000o`3ooomM
0?ooo`00403oool2@0000080oooo00=000000?oood000000o`3ooomM0?ooo`004@3oool01D000000
oooo0?ooo`3ooom000000?l0ooooGP3oool00?l0ooooM03oool00?l0ooooM03oool00?l0ooooM03o
ool00?l0ooooM03oool00?l0ooooM03oool00?l0ooooM03oool00?l0ooooM03oool00?l0ooooM03o
ool00?l0ooooM03oool001T0oooo0d00003o0?oooeP0oooo000J0?ooo`03@000003oool0oooo0?l0
ooooE`3oool001X0oooo0d00003o0?oooeL0oooo000J0?ooo`04@000003oool0oooo@0000?l0oooo
EP3oool001X0oooo00A000000?ooo`3ooom00000o`3ooomF0?ooo`006@3oool4@0000?l0ooooE`3o
ool00?l0ooooM03oool00?l0ooooM03oool00?l0ooooM03oool00?l0ooooM03oool00001\
\>"],
  ImageRangeCache->{{{0, 370.563}, {228.563, 0}} -> {10.0227, -2.67588, 
  0.352504, 0.207405}}]
}, Open  ]],

Cell["\<\
\"Porovnanie hodnoty payoff diagramu, explicitn\[EAcute]ho rie\.9aenia
eur\[OAcute]pskej put opcie a pribli\.9en\[EAcute]ho rie\.9aenia americkej \
put opcie.\"\
\>", "Text"],

Cell["\<\
Table[{xs[[i]],PayoffPut[xs[[i]]],EuropeanPutDiv[xs[[i]],X,str,r,DD,t],ys[[i]]\
},{i,1,2m+1,5}]\
\>", "Input"],

Cell["\<\
Do[ g[j]=ListPlot[graf[j],PlotStyle->{PointSize[0.015],RGBColor[ 
         0,j/n,1]},DisplayFunction->Identity],{j,1,n}]\
\>", "Input"],

Cell[TextData[
"\"Graf americkej put opcie v r\[OHat]znom \[CHacek]ase pred \
expir\[AAcute]ciou.\""], "Text"],

Cell[CellGroupData[{

Cell["\<\
Show[g[1],g[n/2],g[n],DisplayFunction->$DisplayFunction,PlotRange->{{20,130},{\
0,40}}]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.181818 0.00909091 0 0.0154508 [
[.18182 -0.0125 -6 -9 ]
[.18182 -0.0125 6 0 ]
[.36364 -0.0125 -6 -9 ]
[.36364 -0.0125 6 0 ]
[.54545 -0.0125 -6 -9 ]
[.54545 -0.0125 6 0 ]
[.72727 -0.0125 -9 -9 ]
[.72727 -0.0125 9 0 ]
[.90909 -0.0125 -9 -9 ]
[.90909 -0.0125 9 0 ]
[-0.0125 .07725 -6 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -12 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -12 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -12 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -12 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -12 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -12 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.18182 0 m
.18182 .00625 L
s
[(40)] .18182 -0.0125 0 1 Mshowa
.36364 0 m
.36364 .00625 L
s
[(60)] .36364 -0.0125 0 1 Mshowa
.54545 0 m
.54545 .00625 L
s
[(80)] .54545 -0.0125 0 1 Mshowa
.72727 0 m
.72727 .00625 L
s
[(100)] .72727 -0.0125 0 1 Mshowa
.90909 0 m
.90909 .00625 L
s
[(120)] .90909 -0.0125 0 1 Mshowa
.125 Mabswid
.04545 0 m
.04545 .00375 L
s
.09091 0 m
.09091 .00375 L
s
.13636 0 m
.13636 .00375 L
s
.22727 0 m
.22727 .00375 L
s
.27273 0 m
.27273 .00375 L
s
.31818 0 m
.31818 .00375 L
s
.40909 0 m
.40909 .00375 L
s
.45455 0 m
.45455 .00375 L
s
.5 0 m
.5 .00375 L
s
.59091 0 m
.59091 .00375 L
s
.63636 0 m
.63636 .00375 L
s
.68182 0 m
.68182 .00375 L
s
.77273 0 m
.77273 .00375 L
s
.81818 0 m
.81818 .00375 L
s
.86364 0 m
.86364 .00375 L
s
.95455 0 m
.95455 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07725 m
.00625 .07725 L
s
[(5)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(10)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(15)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(20)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(25)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(30)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(35)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(40)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .02 1 r
.015 w
.03636 .55623 Mdot
.0404 .54937 Mdot
.04451 .54239 Mdot
.04869 .53527 Mdot
.05296 .52803 Mdot
.0573 .52065 Mdot
.06172 .51313 Mdot
.06623 .50548 Mdot
.07081 .49768 Mdot
.07549 .48974 Mdot
.08025 .48165 Mdot
.08509 .47341 Mdot
.09003 .46502 Mdot
.09506 .45648 Mdot
.10018 .44777 Mdot
.10539 .43891 Mdot
.1107 .42988 Mdot
.11611 .42069 Mdot
.12162 .41132 Mdot
.12724 .40178 Mdot
.13295 .39207 Mdot
.13877 .38217 Mdot
.1447 .3721 Mdot
.15074 .36183 Mdot
.15689 .35138 Mdot
.16316 .34073 Mdot
.16954 .32989 Mdot
.17604 .31884 Mdot
.18265 .3076 Mdot
.1894 .29614 Mdot
.19626 .28447 Mdot
.20325 .27259 Mdot
.21038 .26048 Mdot
.21763 .24815 Mdot
.22502 .2356 Mdot
.23254 .22281 Mdot
.2402 .20978 Mdot
.24801 .19652 Mdot
.25596 .18301 Mdot
.26406 .16925 Mdot
.2723 .15523 Mdot
.2807 .14096 Mdot
.28925 .12642 Mdot
.29797 .11161 Mdot
.30684 .09653 Mdot
.31588 .08117 Mdot
.32508 .06561 Mdot
.33446 .05011 Mdot
.34401 .03495 Mdot
.35373 .02085 Mdot
.36364 .00942 Mdot
.37372 .00426 Mdot
.384 .00192 Mdot
.39446 .00087 Mdot
.40512 .00039 Mdot
.41598 .00018 Mdot
.42703 8e-005 Mdot
.43829 4e-005 Mdot
.44976 2e-005 Mdot
.46144 1e-005 Mdot
.47334 0 Mdot
.48546 0 Mdot
.4978 0 Mdot
.51037 0 Mdot
.52317 0 Mdot
.53621 0 Mdot
.54949 0 Mdot
.56301 0 Mdot
.57679 0 Mdot
.59082 0 Mdot
.60511 0 Mdot
.61966 0 Mdot
.63449 0 Mdot
.64958 0 Mdot
.66496 0 Mdot
.68062 0 Mdot
.69657 0 Mdot
.71282 0 Mdot
.72936 0 Mdot
.74622 0 Mdot
.76338 0 Mdot
.78086 0 Mdot
.79867 0 Mdot
.8168 0 Mdot
.83527 0 Mdot
.85408 0 Mdot
.87324 0 Mdot
.89275 0 Mdot
.91262 0 Mdot
.93287 0 Mdot
.95348 0 Mdot
.97448 0 Mdot
.99586 0 Mdot
0 .5 1 r
.03636 .55623 Mdot
.0404 .54937 Mdot
.04451 .54239 Mdot
.04869 .53527 Mdot
.05296 .52803 Mdot
.0573 .52065 Mdot
.06172 .51313 Mdot
.06623 .50548 Mdot
.07081 .49768 Mdot
.07549 .48974 Mdot
.08025 .48165 Mdot
.08509 .47341 Mdot
.09003 .46502 Mdot
.09506 .45648 Mdot
.10018 .44777 Mdot
.10539 .43891 Mdot
.1107 .42988 Mdot
.11611 .42069 Mdot
.12162 .41132 Mdot
.12724 .40178 Mdot
.13295 .39207 Mdot
.13877 .38217 Mdot
.1447 .3721 Mdot
.15074 .36183 Mdot
.15689 .35138 Mdot
.16316 .34073 Mdot
.16954 .32989 Mdot
.17604 .31884 Mdot
.18265 .3076 Mdot
.1894 .29614 Mdot
.19626 .28447 Mdot
.20325 .27259 Mdot
.21038 .26048 Mdot
.21763 .24815 Mdot
.22502 .2356 Mdot
.23254 .22281 Mdot
.2402 .20978 Mdot
.24801 .1967 Mdot
.25596 .18372 Mdot
.26406 .17086 Mdot
.2723 .1582 Mdot
.2807 .14576 Mdot
.28925 .13362 Mdot
.29797 .12182 Mdot
.30684 .11043 Mdot
.31588 .09949 Mdot
.32508 .08907 Mdot
.33446 .07921 Mdot
.34401 .06996 Mdot
.35373 .06134 Mdot
.36364 .05339 Mdot
.37372 .04611 Mdot
.384 .03951 Mdot
.39446 .03359 Mdot
.40512 .02832 Mdot
.41598 .02368 Mdot
.42703 .01964 Mdot
.43829 .01614 Mdot
.44976 .01316 Mdot
.46144 .01064 Mdot
.47334 .00853 Mdot
.48546 .00677 Mdot
.4978 .00534 Mdot
.51037 .00417 Mdot
.52317 .00323 Mdot
.53621 .00248 Mdot
.54949 .00189 Mdot
.56301 .00143 Mdot
.57679 .00107 Mdot
.59082 .0008 Mdot
.60511 .00059 Mdot
.61966 .00043 Mdot
.63449 .00031 Mdot
.64958 .00023 Mdot
.66496 .00016 Mdot
.68062 .00012 Mdot
.69657 8e-005 Mdot
.71282 6e-005 Mdot
.72936 4e-005 Mdot
.74622 3e-005 Mdot
.76338 2e-005 Mdot
.78086 1e-005 Mdot
.79867 1e-005 Mdot
.8168 1e-005 Mdot
.83527 0 Mdot
.85408 0 Mdot
.87324 0 Mdot
.89275 0 Mdot
.91262 0 Mdot
.93287 0 Mdot
.95348 0 Mdot
.97448 0 Mdot
.99586 0 Mdot
0 1 1 r
.03636 .55623 Mdot
.0404 .54937 Mdot
.04451 .54239 Mdot
.04869 .53527 Mdot
.05296 .52803 Mdot
.0573 .52065 Mdot
.06172 .51313 Mdot
.06623 .50548 Mdot
.07081 .49768 Mdot
.07549 .48974 Mdot
.08025 .48165 Mdot
.08509 .47341 Mdot
.09003 .46502 Mdot
.09506 .45648 Mdot
.10018 .44777 Mdot
.10539 .43891 Mdot
.1107 .42988 Mdot
.11611 .42069 Mdot
.12162 .41132 Mdot
.12724 .40178 Mdot
.13295 .39207 Mdot
.13877 .38217 Mdot
.1447 .3721 Mdot
.15074 .36183 Mdot
.15689 .35138 Mdot
.16316 .34073 Mdot
.16954 .32989 Mdot
.17604 .31884 Mdot
.18265 .3076 Mdot
.1894 .29614 Mdot
.19626 .28447 Mdot
.20325 .27259 Mdot
.21038 .26048 Mdot
.21763 .24824 Mdot
.22502 .23609 Mdot
.23254 .22404 Mdot
.2402 .21213 Mdot
.24801 .20037 Mdot
.25596 .18879 Mdot
.26406 .17741 Mdot
.2723 .16627 Mdot
.2807 .15538 Mdot
.28925 .14478 Mdot
.29797 .1345 Mdot
.30684 .12454 Mdot
.31588 .11495 Mdot
.32508 .10574 Mdot
.33446 .09693 Mdot
.34401 .08854 Mdot
.35373 .08058 Mdot
.36364 .07305 Mdot
.37372 .06598 Mdot
.384 .05936 Mdot
.39446 .05318 Mdot
.40512 .04746 Mdot
.41598 .04218 Mdot
.42703 .03732 Mdot
.43829 .03289 Mdot
.44976 .02885 Mdot
.46144 .0252 Mdot
.47334 .02191 Mdot
.48546 .01897 Mdot
.4978 .01635 Mdot
.51037 .01403 Mdot
.52317 .01198 Mdot
.53621 .01018 Mdot
.54949 .00861 Mdot
.56301 .00725 Mdot
.57679 .00608 Mdot
.59082 .00507 Mdot
.60511 .00421 Mdot
.61966 .00348 Mdot
.63449 .00287 Mdot
.64958 .00235 Mdot
.66496 .00191 Mdot
.68062 .00155 Mdot
.69657 .00125 Mdot
.71282 .00101 Mdot
.72936 .00081 Mdot
.74622 .00064 Mdot
.76338 .00051 Mdot
.78086 .0004 Mdot
.79867 .00032 Mdot
.8168 .00025 Mdot
.83527 .00019 Mdot
.85408 .00015 Mdot
.87324 .00011 Mdot
.89275 9e-005 Mdot
.91262 7e-005 Mdot
.93287 5e-005 Mdot
.95348 4e-005 Mdot
.97448 3e-005 Mdot
.99586 2e-005 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{466.938, 288.5},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007B000182000`400?l00000o`00003oo`3ooooC
0?ooo`00I03oool3@0000080oooo00=000000?ooo`3oool0AP3oool2@00000@0oooo00=000000?oo
o`3oool0A`3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo0480oooo1D0000020?oo
o`03@000003oool0oooo0080oooo00=000000?ooo`3oool0@03oool5@00000040?oood0000100000
@00000<0oooo00=000000?ooo`3oool0:03oool006D0oooo00I000000?ooo`3ooom000000?oood00
00170?ooo`03@000003ooom000000080oooo00=000000?oood000000A`3oool00d000000oooo@000
00020?ooo`03@000003ooom0000004D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080
oooo00=000000?oood000000@`3oool01D000000oooo0?ooo`3ooom0000000@0oooo00=000000?oo
od000000:@3oool006<0oooo14000000103ooom000000?oood0000170?ooo`03@000003ooom00000
0080oooo00=000000?oood000000A`3oool00d000000oooo@00000020?ooo`03@000003ooom00000
04D0oooo00M000000?ooo`3oool0oooo@000003ooom000000080oooo00=000000?oood000000@`3o
ool00d000000oooo0?ooo`020?ooo`07@000003oool0oooo0?oood000000oooo@000000Y0?ooo`00
H`3oool00d000000oooo@00000020?ooo`03@000003ooom0000004L0oooo0T0000030?ooo`03@000
003ooom0000004P0oooo00M000000?ooo`3oool0oooo@000003ooom0000004D0oooo00M000000?oo
o`3oool0oooo@000003ooom000000080oooo00=000000?oood000000@`3oool00d000000oooo0?oo
o`020?ooo`07@000003oool0oooo0?oood000000oooo@000000Y0?ooo`00I03oool2@0000080oooo
00=000000?oood000000A`3oool00d000000oooo0?ooo`020?ooo`03@000003ooom0000004L0oooo
00=000000?oood0000000P3oool00d000000oooo@00000150?ooo`07@000003oool0oooo0?oood00
0000oooo@00000020?ooo`03@000003ooom0000004<0oooo00M000000?ooo`3oool0oooo@000003o
oom000000080oooo00=000000?oood000000:@3oool006D0oooo00E000000?ooo`3oool0oooo@000
00190?ooo`9000000`3oool00d000000oooo0?ooo`170?ooo`03@000003oool0oooo0080oooo00=0
00000?ooo`3oool0@`3oool2@00000@0oooo00=000000?ooo`3oool00P3oool00d000000oooo0?oo
o`110?ooo`900000103oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo02P0oooo003o
0?ooom<0oooo003o0?ooom<0oooo003o0?ooom<0oooo003o0?ooom<0oooo003o0?ooom<0oooo003o
0?ooom<0oooo00350?ooobd000Go00<0oooo0005o`001Ol00`001Ol00`3oool000Go0005o`080005
o`030?ooo`001Ol000Go00<000Go00<0oooo0005o`001Ol00`001Ol00`3oool000Go0005o`030005
o`030?ooo`001Ol000Go00<000Go00<0oooo001oo`00Ool00`00Ool00`3oool007oo001oo`03001o
o`80oooo1@00Ool00`3oool007oo001oo`03001oo`80oooo1@00Ool20?ooo`D007oo0P3oool5001o
o`80oooo1@00Ool20?ooo`D007oo0P3oool5003oo`<0oooo1@00ool20?ooo`D00?oo0`3oool5003o
o`<0oooo1@00ool30?ooo`D00?oo0`3oool5003oo`@0oooo1@00ool30?ooo`D00?oo103oool5003o
o`@0oooo1@00ool30?ooo`D00?oo1@3oool5003oo`@0oooo1@00ool70?ooo`00603ooonT000003H0
00Go00<000000005o`001Ol00`001Ol00`00000000Go0005o`030005o`D007oo00<00000001oo`00
Ool00`00Ool00`00000007oo001oo`03001oo`0300000000Ool007oo00<007oo00<00000001oo`00
Ool00`00Ool00`00000007oo001oo`03001oo`0300000000Ool007oo00<007oo0P000005003oo`03
00000000ool00?oo00<00?oo0P000005003oo`8000001@00ool2000000D00?oo0P000005003oo`80
00001@00ool2000000D00?oo0`000005003oo`8000001@00ool3000000D00?oo0`000005003oo`<0
00001@00ool3000000D00?oo10000005003oo`<000001@00ool4000000D00?oo10000005003oo`<0
00001@00ool5000000D00?oo10000005003oo`L0oooo000H0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool04@3oool00`000000oooo0005o`0i0005o`030?ooo`00Ool007oo00<007oo
00<0oooo001oo`00Ool02000Ool00`3oool007oo001oo`03001oo`030?ooo`00Ool007oo00<007oo
00<0oooo001oo`00Ool00`00Ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo00<00?oo
00<0oooo003oo`00ool00`00ool20?ooo`D00?oo00<0oooo003oo`00ool00`00ool20?ooo`D00?oo
0P3oool5003oo`80oooo1@00ool20?ooo`D00?oo0P3oool5003oo`80oooo1@00ool30?ooo`D00?oo
0P3oool5003oo`<0oooo1@00ool30?ooo`D00?oo0`3oool5003oo`<0oooo1@00ool20?ooo`030000
003oool00?oo00@00?oo0`3oool5003oo`@0oooo1@00ool40?ooo`D00?oo0`3oool5003oo`D0oooo
1@00ool40?ooo`D00?oo1`3oool001P0oooo00<000000?ooo`3oool04@3oool00d000000oooo0?oo
o`0@0?ooo`03@000003oool0oooo0140oooo00=000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0A0?ooo`03@000003oool0oooo0100oooo00=000000?ooo`3oool04@3oool00d000000oooo0?oo
o`0A0?ooo`030000003oool000Go02l000Go2P00Ool00`3oool007oo001oo`03001oo`030?ooo`00
Ool007oo00P007oo00<0oooo001oo`00Ool00`00Ool00`3oool00?oo003oo`03003oo`030?ooo`00
ool00?oo00<00?oo00<0oooo003oo`00ool00`00ool00`3oool00?oo003oo`03003oo`030?ooo`00
ool00?oo00<00?oo0P3oool5003oo`030?ooo`00ool00?oo00<00?oo0P3oool5003oo`80oooo1@00
ool20?ooo`D00?oo0P3oool5003oo`80oooo1@00ool20?ooo`D00?oo0`3oool5003oo`80oooo1@00
ool30?ooo`D00?oo0`3oool5003oo`<0oooo1@00ool30?ooo`D00?oo0P3oool00d000000oooo003o
o`04003oo`<0oooo1@00ool40?ooo`D00?oo103oool5003oo`<0oooo1@00ool50?ooo`D00?oo103o
ool5003oo`L0oooo000H0?ooo`030000003oool0oooo04`0oooo00=000000?ooo`3oool0B@3ooolF
0005o`80oooo0`001Ol20?ooo`<000Go0P3oool30005o`80oooo0`001Ol20?ooo`<000Go00<0oooo
001oo`00Ool03@00Ool00`3oool007oo001oo`03001oo`030?ooo`00Ool007oo00P007oo00<0oooo
003oo`00ool00`00ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo00<00?oo00<0oooo
003oo`00ool00`00ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo00<00?oo0P3oool5
003oo`030?ooo`00ool00?oo00<00?oo0P3oool5003oo`80oooo1@00ool20?ooo`D00?oo0P3oool5
003oo`80oooo1@00ool30?ooo`<00?oo1@3oool3003oo`@0oooo0`00ool50?ooo`<00?oo1@3oool3
003oo`D0oooo0`00ool50?ooo`<00?oo1P3oool3003oo`D0oooo0`00ool60?ooo`<00?oo1P3oool3
003oo`D0oooo0`00ool70?ooo`<00?oo1P3oool3003oo`P0oooo000H0?ooo`030000003oool0oooo
09P0oooo3@001Ol20?ooo`<000Go6@3ooolD001oo`030?ooo`00Ool007oo00<007oo00<0oooo003o
o`00ool02000ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo00<00?oo00<0oooo003o
o`00ool00`00ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo00<00?oo00<0oooo003o
o`00ool00`00ool30?ooo`<00?oo0`3oool3003oo`@0oooo0`00ool40?ooo`<00?oo103oool3003o
o`@0oooo0`00ool40?ooo`<00?ooO03oool001P0oooo00<000000?ooo`3oool0V03oool50005o`04
0?ooo`001Ol000Go0005oad0oooo6@00Ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo
00P00?oo00<0oooo003oo`00ool00`00ool00`3oool00?oo003oo`03003oo`030?ooo`00ool00?oo
00<00?oo0P3oool3003oo`<0oooo0`00ool30?ooo`<00?oo[03oool001P0oooo00<000000?ooo`3o
ool0V03oool50005oa`0oooo5000Ool01@3oool007oo001oo`00Ool0oooo00D00?oo00<0oooo003o
o`00ool00`00ool00`3oool00?oo003oo`08003oo`030?ooo`00ool00?oo00<00?oo0P3oool3003o
o`<0oooo0`00oonn0?ooo`00603oool200000003@000003oool0oooo09L0oooo0`001OlM0?ooo`l0
07oo00D0oooo001oo`00Ool007oo0?ooo`0:003oo`030?ooo`00ool00?oo00<00?oo00<0oooo003o
o`00ool02000ool20?ooo`<00?oobP3oool001P0oooo00<000000?ooo`3oool0U03oool50005oa/0
oooo3`00Ool0103oool007oo001oo`00Ool60?ooo`X00?oo00<0oooo003oo`00ool00`00ool20?oo
o`<00?oo0P3oool3003oom00oooo000H0?ooo`030000003oool0oooo09@0oooo1@001OlF0?ooo`l0
07oo00@0oooo001oo`00Ool007oo1P3oool?003oo`80oooo0`00oooK0?ooo`00603oool00`000000
oooo0?ooo`2D0?ooo`D000Go5P3oool:001oo`040?ooo`00Ool007oo001oo`H0oooo3`00ool0103o
ool00?oo003oo`00oooQ0?ooo`00603oool00`000000oooo0?ooo`2D0?ooo`D000Go4@3oool?001o
o`X0oooo2P00ool0103oool00?oo003oo`00oooV0?ooo`00603oool00`000000oooo0?ooo`2E0?oo
o`<000Go4P3oool:001oo`040?ooo`00Ool007oo001oo`H0oooo3`00oooZ0?ooo`00603oool00`00
0000oooo0?ooo`2Z0?ooo`D007oo00@0oooo001oo`00Ool007oo1P3oool?003oo`040?ooo`00ool0
0?oo003oon/0oooo000H0?ooo`80000000=000000?ooo`3oool0SP3oool50005oa40oooo2@00Ool:
0?ooo`X00?oo00@0oooo003oo`00ool00?ool03oool001P0oooo00<000000?ooo`3oool0T03oool5
0005oa40oooo2000Ool60?ooo`l00?oom03oool001P0oooo00<000000?ooo`3oool0T03oool50005
o``0oooo2P00Ool90?ooo`X00?oo00@0oooo003oo`00ool00?oom@3oool001P0oooo00<000000?oo
o`3oool0T03oool50005o``0oooo2P00Ool90?ooo`D00?oo00@0oooo003oo`00ool00?oonP3oool0
01P0oooo00<000000?ooo`3oool0T@3oool30005o`d0oooo1@00Ool0103oool007oo001oo`00Ool5
0?ooo`X00?oooP3oool001P0oooo00<000000?ooo`3oool0W@3oool9001oo`T0oooo1@00ool0103o
ool00?oo003oo`00oooo0?ooo`00603oool00`000000oooo0?ooo`2M0?ooo`P007oo1@3oool:003o
ool0oooo103oool001P0oooo0P0000000d000000oooo0?ooo`2:0?ooo`D000Go303oool5001oo`P0
oooo2P00oooo0?ooo`@0oooo000H0?ooo`030000003oool0oooo08`0oooo1@001Ol70?ooo`X007oo
103oool9003oo`040?ooo`00ool00?oo003oool0oooo1@3oool001P0oooo00<000000?ooo`3oool0
S03oool50005o`L0oooo1@00Ool0103oool007oo001oo`00Ool50?ooo`T00?ooo`3oool90?ooo`00
603oool00`000000oooo0?ooo`2<0?ooo`D000Go1`3oool5001oo`T0oooo2000oooo0?ooo`X0oooo
000H0?ooo`030000003oool0oooo08d0oooo0`001Ol80?ooo`D007oo103oool:003oool0oooo3@3o
ool001P0oooo00<000000?ooo`3oool0U03oool8001oo`D0oooo1@00ool0103oool00?oo003oo`00
oooo0?ooo`h0oooo000H0?ooo`80000000=000000?ooo`3oool0TP3oool5001oo`P0oooo1@00oooo
0?oooa80oooo000H0?ooo`030000003oool0oooo08L0oooo1@001Ol80?ooo`D007oo103oool9003o
ool0oooo4P3oool001P0oooo00<000000?ooo`3oool0Q`3oool50005o`P0oooo1@00Ool40?ooo`P0
0?ooo`3ooolC0?ooo`00603oool00`000000oooo0?ooo`270?ooo`D000Go103oool8001oo`D0oooo
1@00oooo0?oooaH0oooo000H0?ooo`030000003oool0oooo08L0oooo1@001Ol40?ooo`D007oo0`3o
ool:003oool0oooo5P3oool000l0oooo00=000000?ooo`3oool01P3oool00`000000oooo0?ooo`28
0?ooo`<000Go1@3oool5001oo`<0oooo1@00ool0103oool00?oo003oo`00oooo0?oooaL0oooo000>
0?ooo`03@000003ooom0000000L0oooo00<000000?ooo`3oool0T03oool5001oo`<0oooo1@00oooo
0?oooa/0oooo000@0?ooo`03@000003oool0oooo00D0oooo0`0000000d000000oooo0?ooo`200?oo
o`D000Go103oool8001oo`T00?ooo`3ooolK0?ooo`003P3oool2@00000P0oooo00<000000?ooo`3o
ool0P`3oool50005o`@0oooo1@00Ool30?ooo`P00?ooo`3ooolL0?ooo`003P3oool00d000000oooo
0?ooo`070?ooo`030000003oool0oooo08<0oooo1@001Ol40?ooo`D007oo0`3oool5003oool0oooo
7`3oool000h0oooo0d0000070?ooo`030000003oool0oooo08<0oooo1@001Ol40?ooo`D007oo0`3o
ool5003oool0oooo7`3oool001P0oooo00<000000?ooo`3oool0Q03oool30005o`D007oo00@0oooo
001oo`00Ool007oo2000oooo0?ooob00oooo000H0?ooo`030000003oool0oooo08L0oooo1@00Ool4
0?ooo`D00?ooo`3ooolS0?ooo`00603oool00`000000oooo0?ooo`270?ooo`D007oo103oool5003o
ool0oooo8`3oool001P0oooo0P0000000d000000oooo0?ooo`1m0?ooo`D000Go0`3oool5001oo`T0
0?ooo`3ooolS0?ooo`00603oool00`000000oooo0?ooo`1o0?ooo`@000Go2000Ool00`3oool00?oo
003oo`06003oool0oooo903oool001P0oooo00<000000?ooo`3oool0O`3oool40005o`D007oo103o
ool5003oool0oooo9`3oool001P0oooo00<000000?ooo`3oool0O`3oool40005o`D007oo103oool5
003oool0oooo9`3oool001P0oooo00<000000?ooo`3oool0P03oool30005o`@007oo1@00ool0103o
ool00?oo003oo`00oooo0?ooobP0oooo000H0?ooo`030000003oool0oooo08@0oooo0`00Ool5003o
ool0oooo;03oool001P0oooo0P0000000d000000oooo0?ooo`1m0?ooo`D007oo0`3oool5003oool0
oooo;03oool001P0oooo00<000000?ooo`3oool0O03oool30005o`D007oo0`3oool5003oool0oooo
;03oool001P0oooo00<000000?ooo`3oool0O03oool30005o`@007oo2000oooo0?ooobd0oooo000H
0?ooo`030000003oool0oooo07`0oooo0`001Ol4001oo`D00?ooo`3oool`0?ooo`00603oool00`00
0000oooo0?ooo`1l0?ooo`@000Go0`00Ool5003oool0oooo<03oool001P0oooo00<000000?ooo`3o
ool0O03oool5001oo`80oooo1@00oooo0?oooc00oooo000H0?ooo`030000003oool0oooo07`0oooo
0`00Ool8003oool0oooo<@3oool001P0oooo0P0000000d000000oooo0?ooo`1f0?ooo`@000Go0`00
Ool5003oool0oooo=03oool001P0oooo00<000000?ooo`3oool0N03oool40005o`<007oo1@00oooo
0?oooc@0oooo000H0?ooo`030000003oool0oooo07P0oooo1@001Ol2001oo`D00?ooo`3ooold0?oo
o`00603oool00`000000oooo0?ooo`1h0?ooo`D007oo0`3oool3003oool0oooo=@3oool001P0oooo
00<000000?ooo`3oool0N03oool4001oo`D00?ooo`3ooolg0?ooo`00603oool00`000000oooo0?oo
o`1h0?ooo`@007oo1@00oooo0?ooocL0oooo000H0?ooo`030000003oool0oooo07@0oooo10001Ol4
001oo`D00?ooo`3ooolg0?ooo`00603oool200000003@000003oool0oooo0780oooo1@001Ol3001o
o`D00?ooo`3ooolg0?ooo`00603oool00`000000oooo0?ooo`1d0?ooo`@000Go2000oooo0?ooocP0
oooo000H0?ooo`030000003oool0oooo07@0oooo1000Ool5003oool0oooo>`3oool001P0oooo00<0
00000?ooo`3oool0M03oool4001oo`D00?ooo`3ooolk0?ooo`00603oool00`000000oooo0?ooo`1d
0?ooo`@007oo1@00oooo0?oooc/0oooo00080?ooo`E000000P3oool00d000000oooo0?ooo`060?oo
o`030000003oool0oooo07@0oooo1@00Ool3003oool0oooo?03oool000X0oooo00M000000?ooo`3o
ool0oooo@000003ooom0000000L0oooo00<000000?ooo`3oool0L03oool40005o`D00?ooo`3ooolo
0?ooo`002P3oool01d000000oooo0?ooo`3ooom000000?oood0000001`3oool300000003@000003o
ool0oooo06d0oooo1000Ool5003oool0oooo?`3oool000X0oooo00M000000?ooo`3oool0oooo@000
003ooom0000000L0oooo00<000000?ooo`3oool0L03oool4001oo`D00?ooo`3ooolo0?ooo`002P3o
ool01d000000oooo0?ooo`3ooom000000?oood0000001`3oool00`000000oooo0?ooo`1`0?ooo`@0
07oo1@00oooo0?ooocl0oooo00090?ooo`900000103oool00d000000oooo0?ooo`060?ooo`030000
003oool0oooo0700oooo2000oooo0?oood00oooo000H0?ooo`030000003oool0oooo0700oooo1@00
oooo0?oood<0oooo000H0?ooo`030000003oool0oooo06d0oooo0`00Ool5003oool0oooo@`3oool0
01P0oooo0P0000000d000000oooo0?ooo`1[0?ooo`<007oo1@00oooo0?oood<0oooo000H0?ooo`03
0000003oool0oooo06d0oooo1000Ool3003oool0ooooA03oool001P0oooo00<000000?ooo`3oool0
K@3oool5003oool0ooooAP3oool001P0oooo00<000000?ooo`3oool0K@3oool5003oool0ooooAP3o
ool001P0oooo00<000000?ooo`3oool0K@3oool5003oool0ooooAP3oool001P0oooo00<000000?oo
o`3oool0J@3oool4001oo`D00?ooo`3ooom60?ooo`00603oool00`000000oooo0?ooo`1Y0?ooo`D0
07oo0`00oooo0?ooodL0oooo000H0?ooo`80000000=000000?ooo`3oool0I`3oool5003oool0oooo
BP3oool001P0oooo00<000000?ooo`3oool0J@3oool5003oool0ooooBP3oool001P0oooo00<00000
0?ooo`3oool0J@3oool5003oool0ooooBP3oool001P0oooo00<000000?ooo`3oool0J@3oool5003o
ool0ooooBP3oool001P0oooo00<000000?ooo`3oool0IP3oool4001oo`<00?ooo`3ooom;0?ooo`00
603oool00`000000oooo0?ooo`1V0?ooo`D00?ooo`3ooom=0?ooo`00603oool00`000000oooo0?oo
o`1V0?ooo`D00?ooo`3ooom=0?ooo`00603oool200000003@000003oool0oooo06@0oooo1@00oooo
0?ooodd0oooo000H0?ooo`030000003oool0oooo06H0oooo1@00oooo0?ooodd0oooo000H0?ooo`03
0000003oool0oooo06<0oooo1000Ool3003oool0ooooCP3oool001P0oooo00<000000?ooo`3oool0
H`3oool5003oool0ooooD03oool001P0oooo00<000000?ooo`3oool0H`3oool5003oool0ooooD03o
ool001P0oooo00<000000?ooo`3oool0H`3oool5003oool0ooooD03oool001P0oooo0P0000000d00
0000oooo0?ooo`1Q0?ooo`D00?ooo`3ooom@0?ooo`00603oool00`000000oooo0?ooo`1T0?ooo`<0
0?ooo`3ooomA0?ooo`00603oool00`000000oooo0?ooo`1O0?ooo`D007ooo`3ooomD0?ooo`00603o
ool00`000000oooo0?ooo`1O0?ooo`D00?ooo`3ooomD0?ooo`00603oool00`000000oooo0?ooo`1O
0?ooo`D00?ooo`3ooomD0?ooo`00203oool5@0000080oooo00=000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`1O0?ooo`D00?ooo`3ooomD0?ooo`002P3oool01d000000oooo0?ooo`3ooom00000
0?oood0000001`3oool00`000000oooo0?ooo`1O0?ooo`D00?ooo`3ooomD0?ooo`002P3oool00d00
0000oooo0?ooo`030?ooo`03@000003oool0oooo00D0oooo0`0000000d000000oooo0?ooo`1M0?oo
o`<00?ooo`3ooomE0?ooo`002P3oool014000000oooo0?ooo`3oool2@00000P0oooo00<000000?oo
o`3oool0G03oool5003oool0ooooE`3oool000X0oooo00E000000?ooo`3oool0oooo@00000090?oo
o`030000003oool0oooo05`0oooo1@00oooo0?oooeL0oooo00090?ooo`9000000`3oool3@00000L0
oooo00<000000?ooo`3oool0G03oool5003oool0ooooE`3oool001P0oooo00<000000?ooo`3oool0
G03oool5003oool0ooooE`3oool001P0oooo00<000000?ooo`3oool0G@3oool3003oool0ooooF03o
ool001P0oooo00<000000?ooo`3oool0F@3oool5003oool0ooooFP3oool001P0oooo0P0000000d00
0000oooo0?ooo`1G0?ooo`D00?ooo`3ooomJ0?ooo`00603oool00`000000oooo0?ooo`1I0?ooo`D0
0?ooo`3ooomJ0?ooo`00603oool00`000000oooo0?ooo`1I0?ooo`D00?ooo`3ooomJ0?ooo`00603o
ool00`000000oooo0?ooo`1J0?ooo`<00?ooo`3ooomK0?ooo`00603oool00`000000oooo0?ooo`1F
0?ooo`D00?ooo`3ooomM0?ooo`00603oool00`000000oooo0?ooo`1F0?ooo`D00?ooo`3ooomM0?oo
o`00603oool00`000000oooo0?ooo`1F0?ooo`D00?ooo`3ooomM0?ooo`00603oool200000003@000
003oool0oooo05@0oooo1@00oooo0?oooed0oooo000H0?ooo`030000003oool0oooo05L0oooo0`00
oooo0?oooeh0oooo000H0?ooo`030000003oool0oooo0?l0oooo^03oool001P0oooo00<000000?oo
o`3oool0DP3oool5003oool0ooooH@3oool001P0oooo00<000000?ooo`3oool0DP3oool5003oool0
ooooH@3oool001P0oooo00<000000?ooo`3oool0DP3oool5003oool0ooooH@3oool001P0oooo0P00
00000d000000oooo0?ooo`1@0?ooo`D00?ooo`3ooomQ0?ooo`00603oool00`000000oooo0?ooo`1C
0?ooo`<00?ooo`3ooomR0?ooo`00603oool00`000000oooo0?ooo`1?0?ooo`D00?ooo`3ooomT0?oo
o`00603oool00`000000oooo0?ooo`1?0?ooo`D00?ooo`3ooomT0?ooo`00603oool00`000000oooo
0?ooo`1?0?ooo`D00?ooo`3ooomT0?ooo`00603oool00`000000oooo0?ooo`1?0?ooo`D00?ooo`3o
oomT0?ooo`00603oool00`000000oooo0?ooo`1@0?ooo`<00?ooo`3ooomU0?ooo`00603oool20000
0003@000003oool0oooo04X0oooo1@00oooo0?ooofL0oooo000H0?ooo`030000003oool0oooo04`0
oooo1@00oooo0?ooofL0oooo000H0?ooo`030000003oool0oooo04`0oooo1@00oooo0?ooofL0oooo
000H0?ooo`030000003oool0oooo04`0oooo1@00oooo0?ooofL0oooo000H0?ooo`030000003oool0
oooo04d0oooo0`00oooo0?ooofP0oooo00090?ooo`=000000`3oool00d000000oooo0?ooo`060?oo
o`030000003oool0oooo04X0oooo1@00oooo0?ooofT0oooo00090?ooo`03@000003oool0oooo0080
oooo00=000000?oood0000001`3oool00`000000oooo0?ooo`1:0?ooo`D00?ooo`3ooomY0?ooo`00
2P3oool01d000000oooo0?ooo`3ooom000000?oood0000001`3oool300000003@000003oool0oooo
04L0oooo1@00oooo0?ooofT0oooo000:0?ooo`07@000003oool0oooo0?oood000000oooo@0000007
0?ooo`030000003oool0oooo04X0oooo1@00oooo0?ooofT0oooo00090?ooo`03@000003ooom00000
0080oooo00=000000?oood0000001`3oool00`000000oooo0?ooo`1;0?ooo`<00?ooo`3ooomZ0?oo
o`002P3oool00d000000oooo0?ooo`020?ooo`03@000003oool0oooo00H0oooo00<000000?ooo`3o
ool0A`3oool5003oool0ooooK03oool001P0oooo00<000000?ooo`3oool0A`3oool5003oool0oooo
K03oool001P0oooo00<000000?ooo`3oool0A`3oool5003oool0ooooK03oool001P0oooo0P000000
0d000000oooo0?ooo`150?ooo`D00?ooo`3ooom/0?ooo`00603oool00`000000oooo0?ooo`180?oo
o`<00?ooo`3ooom]0?ooo`00603oool00`000000oooo0?ooo`140?ooo`D00?ooo`3ooom_0?ooo`00
603oool00`000000oooo0?ooo`140?ooo`D00?ooo`3ooom_0?ooo`00603oool00`000000oooo0?oo
o`140?ooo`D00?ooo`3ooom_0?ooo`00603oool00`000000oooo0?ooo`140?ooo`D00?ooo`3ooom_
0?ooo`00603oool00`000000oooo0?ooo`110?ooo`L00?ooo`3ooom`0?ooo`00603oool200000003
@000003oool0oooo03l0oooo1@00oooo0?ooog80oooo000H0?ooo`030000003oool0oooo0440oooo
1@00oooo0?ooog80oooo000H0?ooo`030000003oool0oooo0440oooo1@00oooo0?ooog80oooo000H
0?ooo`030000003oool0oooo0480oooo0`00oooo0?ooog<0oooo000H0?ooo`030000003oool0oooo
03h0oooo1@00oooo0?ooogD0oooo000H0?ooo`030000003oool0oooo03h0oooo1@00oooo0?ooogD0
oooo000H0?ooo`030000003oool0oooo03h0oooo1@00oooo0?ooogD0oooo000H0?ooo`80000000=0
00000?ooo`3oool0?03oool5003oool0ooooM@3oool001P0oooo00<000000?ooo`3oool0?03oool6
003oool0ooooMP3oool001P0oooo00<000000?ooo`3oool0?03oool5003oool0ooooM`3oool001P0
oooo00<000000?ooo`3oool0?03oool5003oool0ooooM`3oool001P0oooo00<000000?ooo`3oool0
?03oool5003oool0ooooM`3oool001P0oooo00<000000?ooo`3oool0?@3oool3003oool0ooooN03o
ool001P0oooo00<000000?ooo`3oool0>@3oool5003oool0ooooNP3oool001P0oooo0P0000000d00
0000oooo0?ooo`0g0?ooo`D00?ooo`3ooomj0?ooo`00603oool00`000000oooo0?ooo`0i0?ooo`D0
0?ooo`3ooomj0?ooo`00603oool00`000000oooo0?ooo`0i0?ooo`D00?ooo`3ooomj0?ooo`00603o
ool00`000000oooo0?ooo`0f0?ooo`L00?ooo`3ooomk0?ooo`002@3oool3@00000<0oooo00=00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0f0?ooo`D00?ooo`3ooomm0?ooo`002@3oool00d00
0000oooo0?ooo`020?ooo`03@000003ooom0000000L0oooo00<000000?ooo`3oool0=P3oool5003o
ool0ooooO@3oool000X0oooo00=000000?ooo`3oool00`3oool00d000000oooo0?ooo`050?ooo`<0
000000=000000?ooo`3oool0<`3oool5003oool0ooooO@3oool000X0oooo00A000000?ooo`3oool0
oooo0T0000080?ooo`030000003oool0oooo03L0oooo0`00oooo0?ooogh0oooo00090?ooo`03@000
003ooom000000080oooo00=000000?ooo`3oool01`3oool00`000000oooo0?ooo`0d0?ooo`D00?oo
o`3ooomo0?ooo`002P3oool014000000oooo0?ooo`3oool3@00000L0oooo00<000000?ooo`3oool0
=03oool5003oool0ooooO`3oool001P0oooo00<000000?ooo`3oool0=03oool5003oool0ooooO`3o
ool001P0oooo00<000000?ooo`3oool0=03oool5003oool0ooooO`3oool001P0oooo00<000000?oo
o`3oool0<@3oool7003oool0ooooP03oool001P0oooo0P0000000d000000oooo0?ooo`0_0?ooo`D0
0?ooo`3ooon20?ooo`00603oool00`000000oooo0?ooo`0a0?ooo`D00?ooo`3ooon20?ooo`00603o
ool00`000000oooo0?ooo`0a0?ooo`D00?ooo`3ooon20?ooo`00603oool00`000000oooo0?ooo`0_
0?ooo`H00?ooo`3ooon30?ooo`00603oool00`000000oooo0?ooo`0_0?ooo`D00?ooo`3ooon40?oo
o`00603oool00`000000oooo0?ooo`0_0?ooo`D00?ooo`3ooon40?ooo`00603oool00`000000oooo
0?ooo`0_0?ooo`D00?ooo`3ooon40?ooo`00603oool200000003@000003oool0oooo02/0oooo1P00
oooo0?ooohD0oooo000H0?ooo`030000003oool0oooo02d0oooo1@00oooo0?ooohH0oooo000H0?oo
o`030000003oool0oooo02d0oooo1@00oooo0?ooohH0oooo000H0?ooo`030000003oool0oooo02d0
oooo1@00oooo0?ooohH0oooo000H0?ooo`030000003oool0oooo02X0oooo1`00oooo0?ooohL0oooo
000H0?ooo`030000003oool0oooo02X0oooo1@00oooo0?ooohT0oooo000H0?ooo`80000000=00000
0?ooo`3oool0:03oool5003oool0ooooR@3oool001P0oooo00<000000?ooo`3oool0:P3oool5003o
ool0ooooR@3oool001P0oooo00<000000?ooo`3oool0:03oool6003oool0ooooRP3oool001P0oooo
00<000000?ooo`3oool0:03oool5003oool0ooooR`3oool001P0oooo00<000000?ooo`3oool0:03o
ool5003oool0ooooR`3oool001P0oooo00<000000?ooo`3oool0:03oool5003oool0ooooR`3oool0
01P0oooo00<000000?ooo`3oool09P3oool6003oool0ooooS03oool001P0oooo0P0000000d000000
oooo0?ooo`0T0?ooo`D00?ooo`3ooon=0?ooo`00603oool00`000000oooo0?ooo`0V0?ooo`D00?oo
o`3ooon=0?ooo`00603oool00`000000oooo0?ooo`0V0?ooo`D00?ooo`3ooon=0?ooo`00603oool0
0`000000oooo0?ooo`0S0?ooo`L00?ooo`3ooon>0?ooo`00603oool00`000000oooo0?ooo`0S0?oo
o`D00?ooo`3ooon@0?ooo`002@3oool2@00000@0oooo00=000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0S0?ooo`D00?ooo`3ooon@0?ooo`002`3oool01T000000oooo0?oood000000oooo@000
00L0oooo00<000000?ooo`3oool08@3oool7003oool0ooooT03oool000X0oooo00M000000?ooo`3o
ool0oooo@000003ooom0000000L0oooo0`0000000d000000oooo0?ooo`0N0?ooo`H00?ooo`3ooonA
0?ooo`002`3oool01T000000oooo0?oood000000oooo@00000L0oooo00<000000?ooo`3oool08@3o
ool5003oool0ooooTP3oool000T0oooo00=000000?oood0000000P3oool00d000000oooo@0000007
0?ooo`030000003oool0oooo0240oooo1@00oooo0?oooi80oooo000:0?ooo`03@000003oool0oooo
0080oooo00=000000?ooo`3oool01P3oool00`000000oooo0?ooo`0O0?ooo`H00?ooo`3ooonC0?oo
o`00603oool00`000000oooo0?ooo`0O0?ooo`D00?ooo`3ooonD0?ooo`00603oool00`000000oooo
0?ooo`0O0?ooo`D00?ooo`3ooonD0?ooo`00603oool00`000000oooo0?ooo`0M0?ooo`L00?ooo`3o
oonD0?ooo`00603oool200000003@000003oool0oooo01/0oooo1P00oooo0?oooiD0oooo000H0?oo
o`030000003oool0oooo01d0oooo1@00oooo0?oooiH0oooo000H0?ooo`030000003oool0oooo01d0
oooo1@00oooo0?oooiH0oooo000H0?ooo`030000003oool0oooo01/0oooo1P00oooo0?oooiL0oooo
000H0?ooo`030000003oool0oooo01/0oooo1@00oooo0?oooiP0oooo000H0?ooo`030000003oool0
oooo01/0oooo1@00oooo0?oooiP0oooo000H0?ooo`80000000=000000?ooo`3oool05`3oool7003o
ool0ooooV03oool001P0oooo00<000000?ooo`3oool06@3oool6003oool0ooooV@3oool001P0oooo
00<000000?ooo`3oool06@3oool5003oool0ooooVP3oool001P0oooo00<000000?ooo`3oool06@3o
ool5003oool0ooooVP3oool001P0oooo00<000000?ooo`3oool05`3oool6003oool0ooooV`3oool0
01P0oooo00<000000?ooo`3oool05`3oool5003oool0ooooW03oool001P0oooo00<000000?ooo`3o
ool05`3oool5003oool0ooooW03oool001P0oooo0P0000000d000000oooo0?ooo`0C0?ooo`L00?oo
o`3ooonL0?ooo`00603oool00`000000oooo0?ooo`0E0?ooo`H00?ooo`3ooonM0?ooo`00603oool0
0`000000oooo0?ooo`0E0?ooo`D00?ooo`3ooonN0?ooo`00603oool00`000000oooo0?ooo`0C0?oo
o`L00?ooo`3ooonN0?ooo`00603oool00`000000oooo0?ooo`0C0?ooo`H00?ooo`3ooonO0?ooo`00
603oool00`000000oooo0?ooo`0C0?ooo`D00?ooo`3ooonP0?ooo`00603oool00`000000oooo0?oo
o`0C0?ooo`D00?ooo`3ooonP0?ooo`00603oool200000003@000003oool0oooo00l0oooo1P00oooo
0?oooj40oooo000H0?ooo`030000003oool0oooo0140oooo1@00oooo0?oooj80oooo000H0?ooo`03
0000003oool0oooo0140oooo1@00oooo0?oooj80oooo000H0?ooo`030000003oool0oooo00l0oooo
1`00oooo0?oooj80oooo00090?ooo`900000103oool00d000000oooo0?ooo`060?ooo`030000003o
ool0oooo00l0oooo1P00oooo0?oooj<0oooo000;0?ooo`06@000003oool0oooo@000003ooom00000
1`3oool00`000000oooo0?ooo`0?0?ooo`D00?ooo`3ooonT0?ooo`002P3oool00d000000oooo0?oo
o`030?ooo`03@000003oool0oooo00D0oooo0`0000000d000000oooo0?ooo`0;0?ooo`H00?ooo`3o
oonT0?ooo`002`3oool00d000000oooo0?ooo`02@00000P0oooo00<000000?ooo`3oool03P3oool5
003oool0ooooY@3oool000T0oooo00=000000?oood0000000P3oool00d000000oooo0?ooo`070?oo
o`030000003oool0oooo00h0oooo1@00oooo0?ooojD0oooo000:0?ooo`04@000003oool0oooo0?oo
o`=000001`3oool00`000000oooo0?ooo`0<0?ooo`L00?ooo`3ooonU0?ooo`00603oool00`000000
oooo0?ooo`0<0?ooo`H00?ooo`3ooonV0?ooo`00603oool00`000000oooo0?ooo`0<0?ooo`D00?oo
o`3ooonW0?ooo`00603oool00`000000oooo0?ooo`0:0?ooo`L00?ooo`3ooonW0?ooo`00603oool2
00000003@000003oool0oooo00P0oooo1P00oooo0?ooojP0oooo000H0?ooo`030000003oool0oooo
00X0oooo1@00oooo0?ooojT0oooo000H0?ooo`030000003oool0oooo00X0oooo1@00oooo0?ooojT0
oooo000H0?ooo`030000003oool0oooo00/0oooo0`00oooo0?ooojX0oooo000H0?ooo`030000003o
ool0oooo0?l0oooo^03oool001P0oooo00<000000?ooo`3oool0o`3ooonh0?ooo`00603oool00`00
0000oooo0?ooo`3o0?oookP0oooo000H0?ooo`80000000=000000?ooo`3oool0o`3ooonf0?ooo`00
603oool00`000000oooo0?ooo`3o0?oookP0oooo000H0?ooo`030000003oool0oooo0?l0oooo^03o
ool001P0oooo00<000000?ooo`3oool0o`3ooonh0?ooo`00603oool00`000000oooo0?ooo`3o0?oo
okP0oooo000H0?ooo`030000003oool0oooo0?l0oooo^03oool001P0oooo00<000000?ooo`3oool0
o`3ooonh0?ooo`00603oool200000003@000003oool0oooo0?l0oooo]P3oool001P0oooo00<00000
0?ooo`3oool0o`3ooonh0?ooo`00603oool00`000000oooo0?ooo`3o0?oookP0oooo000H0?ooo`03
0000003oool0oooo0?l0oooo^03oool001P0oooo00<000000?ooo`3oool0o`3ooonh0?ooo`00603o
ool00`000000oooo0?ooo`3o0?oookP0oooo000H0?ooo`80000000=000000?ooo`3oool0o`3ooonf
0?ooo`00603oool00`000000oooo0?ooo`3o0?oookP0oooo000H0?ooo`030000003oool0oooo0?l0
oooo^03oool001P0oooo00<000000?ooo`3oool0o`3ooonh0?ooo`00603oool00`000000oooo0?oo
o`3o0?oookP0oooo000:0?ooo`=000000P3oool00d000000oooo0?ooo`060?ooo`030000003oool0
oooo0?l0oooo^03oool000/0oooo00I000000?ooo`3ooom000000?oood0000070?ooo`030000003o
ool0oooo0?l0oooo^03oool000T0oooo14000000103ooom000000?oood0000070?ooo`04@0000000
00000000@0000?l0oooo]`3oool000T0oooo00=000000?oood0000000P3oool00d000000oooo@000
003o0?oool80oooo000:0?ooo`9000000P3oool00d000000oooo@000003o0?oool80oooo000;0?oo
o`05@000003oool0oooo0?oood000000o`3oooo30?ooo`00o`3ooooC0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 465.938}, {287.5, 0}} -> {13.8211, -2.14968, 
  0.253135, 0.148939}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{532, 410},
WindowMargins->{{29, Automatic}, {Automatic, 9}},
PrintingCopies->1,
PrintingPageRange->{2, 2}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 54, 0, 30, "Input"],
Cell[1766, 51, 344, 18, 318, "Input"],
Cell[2113, 71, 1083, 48, 894, "Input"],
Cell[3199, 121, 44, 0, 33, "Text"],
Cell[3246, 123, 125, 12, 210, "Input"],
Cell[3374, 137, 47, 0, 33, "Text"],
Cell[3424, 139, 73, 0, 30, "Input"],
Cell[3500, 141, 63, 0, 30, "Input"],
Cell[3566, 143, 53, 0, 33, "Text"],
Cell[3622, 145, 43, 0, 30, "Input"],
Cell[3668, 147, 119, 3, 48, "Input"],
Cell[3790, 152, 195, 4, 84, "Input"],
Cell[3988, 158, 24, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4037, 162, 129, 3, 48, "Input"],
Cell[4169, 167, 32154, 842, 238, 9073, 553, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[36338, 1012, 184, 4, 52, "Text"],
Cell[36525, 1018, 120, 3, 48, "Input"],
Cell[36648, 1023, 145, 3, 48, "Input"],
Cell[36796, 1028, 110, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[36931, 1034, 112, 3, 48, "Input"],
Cell[37046, 1039, 33630, 865, 297, 8536, 551, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

